/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.command;

import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.spell.SpellRingCache;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeModifier;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceModifier;
import com.teamwizardry.wizardry.api.spell.module.ModuleRegistry;
import com.teamwizardry.wizardry.common.network.PacketSyncModules;
import com.teamwizardry.wizardry.proxy.CommonProxy;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommandWizardry
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "wizardry";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "wizardry.command.usage";
    }

    public int func_82362_a() {
        return 3;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args[0].equalsIgnoreCase("reload")) {
            SpellRingCache.INSTANCE.clear();
            ModuleRegistry.INSTANCE.loadUnprocessedModules();
            ModuleRegistry.INSTANCE.loadOverrideDefaults();
            ModuleRegistry.INSTANCE.copyMissingModules(CommonProxy.directory);
            ModuleRegistry.INSTANCE.loadModules(CommonProxy.directory);
            if (server.func_71262_S()) {
                PacketHandler.NETWORK.sendToAll((IMessage)new PacketSyncModules(ModuleRegistry.INSTANCE.modules));
            }
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"wizardry.command.success", (Object[])new Object[0]);
        } else if (args[0].equalsIgnoreCase("reset")) {
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"wizardry.command.reset", (Object[])new Object[0]);
            File moduleDirectory = new File(CommonProxy.directory, "modules");
            if (moduleDirectory.exists()) {
                File[] files = moduleDirectory.listFiles();
                if (files != null) {
                    for (File file : files) {
                        String name = file.getName();
                        if (!file.delete()) {
                            throw new CommandException("wizardry.command.fail", new Object[]{name});
                        }
                        CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"wizardry.command.success_delete", (Object[])new Object[]{name});
                    }
                }
                if (!moduleDirectory.delete()) {
                    throw new CommandException("wizardry.command.fail_dir_delete", new Object[0]);
                }
            }
            if (!moduleDirectory.exists() && !moduleDirectory.mkdirs()) {
                throw new CommandException("wizardry.command.fail_dir_create", new Object[0]);
            }
            ModuleRegistry.INSTANCE.loadUnprocessedModules();
            ModuleRegistry.INSTANCE.copyMissingModules(CommonProxy.directory);
            ModuleRegistry.INSTANCE.loadModules(CommonProxy.directory);
            if (server.func_71262_S()) {
                PacketHandler.NETWORK.sendToAll((IMessage)new PacketSyncModules(ModuleRegistry.INSTANCE.modules));
            }
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"wizardry.command.success", (Object[])new Object[0]);
        } else if (args[0].equalsIgnoreCase("listModules")) {
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " ________________________________________________\\\\"), (Object[])new Object[0]);
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " | " + TextFormatting.GRAY + "Module List"), (Object[])new Object[0]);
            for (ModuleInstance module : ModuleRegistry.INSTANCE.modules) {
                CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " | |_ " + TextFormatting.GREEN + module.getSubModuleID() + TextFormatting.RESET + ": " + TextFormatting.GRAY + module.getReadableName()), (Object[])new Object[0]);
            }
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |________________________________________________//"), (Object[])new Object[0]);
        } else if (args[0].equalsIgnoreCase("debug")) {
            if (args.length < 2) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            ModuleInstance module = ModuleRegistry.INSTANCE.getModule(args[1]);
            if (module == null) {
                CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"Module not found.", (Object[])new Object[0]);
                return;
            }
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " ________________________________________________\\\\"), (Object[])new Object[0]);
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " | " + TextFormatting.GRAY + "Module " + module.getReadableName() + ":"), (Object[])new Object[0]);
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |  |_ " + TextFormatting.GREEN + "Description           " + TextFormatting.GRAY + " | " + TextFormatting.GRAY + module.getDescription()), (Object[])new Object[0]);
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |  |_ " + TextFormatting.GREEN + "Item Stack            " + TextFormatting.GRAY + " | " + TextFormatting.GRAY + module.getItemStack().func_82833_r()), (Object[])new Object[0]);
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |  |_ " + TextFormatting.GREEN + "Burnout Fill          " + TextFormatting.GRAY + " | " + TextFormatting.GRAY + module.getBurnoutFill()), (Object[])new Object[0]);
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |  |  |_ " + TextFormatting.DARK_GREEN + "Burnout Multiplier" + TextFormatting.GRAY + " | " + TextFormatting.GRAY + module.getBurnoutMultiplier()), (Object[])new Object[0]);
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |  |_ " + TextFormatting.GREEN + "Mana Drain           " + TextFormatting.GRAY + " | " + TextFormatting.GRAY + module.getManaDrain()), (Object[])new Object[0]);
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |  |  |_" + TextFormatting.DARK_GREEN + "Mana Multiplier     " + TextFormatting.GRAY + " | " + TextFormatting.GRAY + module.getManaMultiplier()), (Object[])new Object[0]);
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |  |_ " + TextFormatting.GREEN + "Power Multiplier     " + TextFormatting.GRAY + " | " + TextFormatting.GRAY + module.getPowerMultiplier()), (Object[])new Object[0]);
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |  |_ " + TextFormatting.GREEN + "Charge Up Time      " + TextFormatting.GRAY + " | " + TextFormatting.GRAY + module.getChargeupTime()), (Object[])new Object[0]);
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |  |_ " + TextFormatting.GREEN + "Cooldown Time        " + TextFormatting.GRAY + " | " + TextFormatting.GRAY + module.getCooldownTime()), (Object[])new Object[0]);
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |  |_ " + TextFormatting.GREEN + "Primary Color        " + TextFormatting.GRAY + " | " + TextFormatting.RED + module.getPrimaryColor().getRed() + TextFormatting.GRAY + ", " + TextFormatting.GREEN + module.getPrimaryColor().getGreen() + TextFormatting.GRAY + ", " + TextFormatting.BLUE + module.getPrimaryColor().getBlue()), (Object[])new Object[0]);
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |  |_ " + TextFormatting.GREEN + "Secondary Color    " + TextFormatting.GRAY + " | " + TextFormatting.RED + module.getSecondaryColor().getRed() + TextFormatting.GRAY + ", " + TextFormatting.GREEN + module.getSecondaryColor().getGreen() + TextFormatting.GRAY + ", " + TextFormatting.BLUE + module.getSecondaryColor().getBlue()), (Object[])new Object[0]);
            if (!module.getAttributes().isEmpty()) {
                CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |  |_ " + TextFormatting.GREEN + "Default AttributeRegistry"), (Object[])new Object[0]);
            }
            for (AttributeModifier attributeModifier : module.getAttributes()) {
                CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |  |  |_ " + TextFormatting.GRAY + attributeModifier.toString()), (Object[])new Object[0]);
            }
            ModuleInstanceModifier[] modifierList = module.applicableModifiers();
            if (modifierList != null) {
                CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |  |_ " + TextFormatting.GREEN + "Applicable Modifiers "), (Object[])new Object[0]);
                for (ModuleInstanceModifier modifier : modifierList) {
                    CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |     |_ " + TextFormatting.DARK_GREEN + modifier.getSubModuleID()), (Object[])new Object[0]);
                }
            }
            CommandWizardry.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(TextFormatting.YELLOW + " |________________________________________________//"), (Object[])new Object[0]);
        } else {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
    }
}

