/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell.module;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import com.teamwizardry.librarianlib.features.helpers.ItemNBTHelper;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorld;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorldCapability;
import com.teamwizardry.wizardry.api.events.SpellCastEvent;
import com.teamwizardry.wizardry.api.spell.ILingeringModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellDataTypes;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeModifier;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRange;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModule;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.IModuleEvent;
import com.teamwizardry.wizardry.api.spell.module.IModuleModifier;
import com.teamwizardry.wizardry.api.spell.module.IModuleShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleFactory;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEvent;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceModifier;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleRegistry;
import com.teamwizardry.wizardry.api.spell.module.ModuleType;
import com.teamwizardry.wizardry.api.util.DefaultHashMap;
import com.teamwizardry.wizardry.api.util.PosUtils;
import com.teamwizardry.wizardry.api.util.RenderUtils;
import com.teamwizardry.wizardry.common.core.SpellTicker;
import com.teamwizardry.wizardry.common.network.PacketRenderSpell;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class ModuleInstance {
    protected final String subModuleID;
    protected final ModuleFactory createdByFactory;
    protected final IModule moduleClass;
    protected final ResourceLocation icon;
    protected final List<AttributeModifier> attributes = new ArrayList<AttributeModifier>();
    protected Map<AttributeRegistry.Attribute, AttributeRange> attributeRanges = new DefaultHashMap<AttributeRegistry.Attribute, AttributeRange>(AttributeRange.BACKUP);
    protected Color primaryColor;
    protected Color secondaryColor;
    protected ItemStack itemStack;
    protected ModuleInstanceModifier[] applicableModifiers = null;

    @Nullable
    public static ModuleInstance deserialize(NBTTagString tagString) {
        return ModuleRegistry.INSTANCE.getModule(tagString.func_150285_a_());
    }

    @Nullable
    public static ModuleInstance deserialize(String id) {
        return ModuleRegistry.INSTANCE.getModule(id);
    }

    protected ModuleInstance(IModule moduleClass, ModuleFactory createdByFactory, String moduleName, ResourceLocation icon, ItemStack itemStack, Color primaryColor, Color secondaryColor, DefaultHashMap<AttributeRegistry.Attribute, AttributeRange> attributeRanges) {
        this.moduleClass = moduleClass;
        this.createdByFactory = createdByFactory;
        this.subModuleID = moduleName;
        this.icon = icon;
        this.itemStack = itemStack;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.attributeRanges = attributeRanges;
    }

    static ModuleInstance createInstance(IModule moduleClass, ModuleFactory createdByFactory, String subModuleID, ResourceLocation icon, ItemStack itemStack, Color primaryColor, Color secondaryColor, DefaultHashMap<AttributeRegistry.Attribute, AttributeRange> attributeRanges) {
        if (moduleClass instanceof IModuleEffect) {
            return new ModuleInstanceEffect((IModuleEffect)moduleClass, createdByFactory, subModuleID, icon, itemStack, primaryColor, secondaryColor, attributeRanges);
        }
        if (moduleClass instanceof IModuleModifier) {
            return new ModuleInstanceModifier((IModuleModifier)moduleClass, createdByFactory, subModuleID, icon, itemStack, primaryColor, secondaryColor, attributeRanges);
        }
        if (moduleClass instanceof IModuleEvent) {
            return new ModuleInstanceEvent((IModuleEvent)moduleClass, createdByFactory, itemStack, subModuleID, icon, primaryColor, secondaryColor, attributeRanges);
        }
        if (moduleClass instanceof IModuleShape) {
            return new ModuleInstanceShape((IModuleShape)moduleClass, createdByFactory, itemStack, subModuleID, icon, primaryColor, secondaryColor, attributeRanges);
        }
        throw new UnsupportedOperationException("Unknown module type.");
    }

    public final IModule getModuleClass() {
        return this.moduleClass;
    }

    public final ModuleFactory getFactory() {
        return this.createdByFactory;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public SpellData renderVisualization(@Nonnull SpellData data, @Nonnull SpellRing ring, @Nonnull SpellData previousData) {
        return this.standardRenderVisualization(data, ring, previousData);
    }

    public final SpellData standardRenderVisualization(@Nonnull SpellData data, @Nonnull SpellRing ring, @Nonnull SpellData previousData) {
        return new SpellData(data.world);
    }

    @Nullable
    public final ItemStack getAvailableStack(Collection<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return null;
    }

    @Nullable
    public final IBlockState getSelectedBlockState(EntityLivingBase caster) {
        ItemStack hand = caster.func_184614_ca();
        if (hand.func_190926_b()) {
            return null;
        }
        if (ItemNBTHelper.verifyExistence((ItemStack)hand, (String)"selected")) {
            NBTTagCompound compound = ItemNBTHelper.getCompound((ItemStack)hand, (String)"selected");
            if (compound == null) {
                return null;
            }
            return NBTUtil.func_190008_d((NBTTagCompound)compound);
        }
        return null;
    }

    public final List<ItemStack> getAllOfStackFromInventory(@Nonnull EntityPlayer player, @Nonnull IBlockState state) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        World world = player.field_70170_p;
        ItemStack search = state.func_177230_c().func_185473_a(world, null, state);
        if (search.func_190926_b()) {
            return stacks;
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock) || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)search)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public final List<ItemStack> getAllOfStackFromInventory(@Nonnull EntityPlayer player, @Nonnull ItemStack search) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (search.func_190926_b()) {
            return stacks;
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock) || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)search)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public final int getCountOfStackFromInventory(@Nonnull EntityPlayer player, @Nonnull IBlockState state) {
        World world = player.field_70170_p;
        ItemStack search = state.func_177230_c().func_185473_a(world, null, state);
        List<ItemStack> stacks = this.getAllOfStackFromInventory(player, search);
        int count = 0;
        for (ItemStack stack : stacks) {
            count += stack.func_190916_E();
        }
        return count;
    }

    public final int getCountOfStackFromInventory(@Nonnull EntityPlayer player, @Nonnull ItemStack search) {
        List<ItemStack> stacks = this.getAllOfStackFromInventory(player, search);
        int count = 0;
        for (ItemStack stack : stacks) {
            count += stack.func_190916_E();
        }
        return count;
    }

    public final int getCountOfStacks(@Nonnull Collection<ItemStack> stacks) {
        int count = 0;
        for (ItemStack stack : stacks) {
            count += stack.func_190916_E();
        }
        return count;
    }

    public abstract ModuleType getModuleType();

    public final String getSubModuleID() {
        return this.subModuleID;
    }

    public final String getReferenceModuleID() {
        return this.createdByFactory.getReferenceModuleID();
    }

    public final String toString() {
        return this.getSubModuleID();
    }

    @Nonnull
    public final String getReadableName() {
        return LibrarianLib.PROXY.translate(this.getNameKey(), new Object[0]);
    }

    @Nonnull
    public final String getNameKey() {
        return "wizardry.spell." + this.subModuleID + ".name";
    }

    @Nonnull
    public final String getDescription() {
        return LibrarianLib.PROXY.translate(this.getDescriptionKey(), new Object[0]);
    }

    @Nonnull
    public final IBlockState getCachableBlockstate(@Nonnull World world, @Nonnull BlockPos targetBlock, @Nonnull SpellData previousData) {
        IBlockState state;
        SpellDataTypes.BlockStateCache cacheData = previousData.getData(SpellData.DefaultKeys.BLOCKSTATE_CACHE);
        if (cacheData != null && cacheData.getBlockStateCache() != null) {
            Map<BlockPos, IBlockState> cache = cacheData.getBlockStateCache();
            if (cache.containsKey(targetBlock)) {
                return cache.get(targetBlock);
            }
            state = world.func_180495_p(targetBlock);
            cache.put(targetBlock, state);
            previousData.addData(SpellData.DefaultKeys.BLOCKSTATE_CACHE, new SpellDataTypes.BlockStateCache(cache));
        } else {
            HashMap<BlockPos, IBlockState> cache = new HashMap<BlockPos, IBlockState>();
            state = world.func_180495_p(targetBlock);
            cache.put(targetBlock, state);
            previousData.addData(SpellData.DefaultKeys.BLOCKSTATE_CACHE, new SpellDataTypes.BlockStateCache(cache));
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public final void drawCubeOutline(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179129_p();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179142_g();
        int color = Color.HSBtoRGB((float)(ClientTickHandler.getTicks() % 200) / 200.0f, 0.6f, 1.0f);
        Color colorRGB = new Color(color);
        GL11.glLineWidth((float)1.0f);
        GL11.glColor4ub((byte)((byte)colorRGB.getRed()), (byte)((byte)colorRGB.getGreen()), (byte)((byte)colorRGB.getBlue()), (byte)-1);
        RenderUtils.renderBlockOutline(state.func_185918_c(world, pos));
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179119_h();
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public final void drawFaceOutline(@Nonnull BlockPos pos, @Nonnull EnumFacing facing) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179129_p();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179142_g();
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(1, DefaultVertexFormats.field_181705_e);
        int color = Color.HSBtoRGB((float)(ClientTickHandler.getTicks() % 200) / 200.0f, 0.6f, 1.0f);
        Color colorRGB = new Color(color);
        Vec3d directionOffsetVec = new Vec3d(facing.func_176730_m()).func_186678_a(0.5);
        Vec3d adjPos = new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5).func_178787_e(directionOffsetVec);
        GL11.glLineWidth((float)1.0f);
        GL11.glColor4ub((byte)((byte)colorRGB.getRed()), (byte)((byte)colorRGB.getGreen()), (byte)((byte)colorRGB.getBlue()), (byte)-1);
        for (EnumFacing facing1 : PosUtils.getPerpendicularFacings(facing)) {
            for (EnumFacing facing2 : PosUtils.getPerpendicularFacings(facing)) {
                if (facing1 == facing2 || facing1.func_176734_d() == facing2 || facing2.func_176734_d() == facing1) continue;
                Vec3d p1 = new Vec3d(facing1.func_176730_m()).func_186678_a(0.5);
                Vec3d p2 = new Vec3d(facing2.func_176730_m()).func_186678_a(0.5);
                Vec3d edge = adjPos.func_178787_e(p1.func_178787_e(p2));
                tessellator.func_178180_c().func_181662_b(edge.field_72450_a, edge.field_72448_b, edge.field_72449_c).func_181675_d();
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179119_h();
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    public List<String> getDetailedInfo() {
        ArrayList<String> detailedInfo = new ArrayList<String>();
        for (AttributeRegistry.Attribute attribute : this.attributeRanges.keySet()) {
            if (!attribute.hasDetailedText()) continue;
            detailedInfo.addAll(this.getDetailedInfo(attribute));
        }
        return detailedInfo;
    }

    @Nonnull
    public final List<String> getDetailedInfo(AttributeRegistry.Attribute attribute) {
        ArrayList<String> detailedInfo = new ArrayList<String>();
        String infoKey = this.getDescriptionKey() + ".";
        String rangeKey = "wizardry.misc.attribute_range";
        detailedInfo.add(LibrarianLib.PROXY.translate(infoKey + attribute.getShortName(), new Object[0]));
        detailedInfo.add("    " + LibrarianLib.PROXY.translate(rangeKey, new Object[0]) + this.attributeRanges.get(attribute));
        return detailedInfo;
    }

    @Nullable
    public ModuleInstanceModifier[] applicableModifiers() {
        if (this.applicableModifiers == null) {
            LinkedList<ModuleInstanceModifier> applicableModifiersList = new LinkedList<ModuleInstanceModifier>();
            String[] modifierNames = this.moduleClass.compatibleModifiers();
            if (modifierNames != null) {
                block0: for (ModuleInstance mod : ModuleRegistry.INSTANCE.modules) {
                    for (String modifier : modifierNames) {
                        if (!mod.getSubModuleID().equals(modifier) || !(mod instanceof ModuleInstanceModifier)) continue;
                        applicableModifiersList.add((ModuleInstanceModifier)mod);
                        continue block0;
                    }
                }
            }
            this.applicableModifiers = applicableModifiersList.toArray(new ModuleInstanceModifier[applicableModifiersList.size()]);
        }
        return this.applicableModifiers;
    }

    @Nonnull
    public final String getDescriptionKey() {
        return "wizardry.spell." + this.subModuleID + ".desc";
    }

    @Nonnull
    public final Color getPrimaryColor() {
        return this.primaryColor;
    }

    public final double getBurnoutFill() {
        return this.attributeRanges.get((Object)AttributeRegistry.BURNOUT).base;
    }

    public final int getCooldownTime() {
        return (int)this.attributeRanges.get((Object)AttributeRegistry.COOLDOWN).base;
    }

    public final int getChargeupTime() {
        return (int)this.attributeRanges.get((Object)AttributeRegistry.CHARGEUP).base;
    }

    public final ItemStack getItemStack() {
        return this.itemStack;
    }

    public final double getManaDrain() {
        return this.attributeRanges.get((Object)AttributeRegistry.MANA).base;
    }

    public final double getPowerMultiplier() {
        return this.attributeRanges.get((Object)AttributeRegistry.POWER_MULTI).base;
    }

    public final double getManaMultiplier() {
        return this.attributeRanges.get((Object)AttributeRegistry.MANA_MULTI).base;
    }

    public final double getBurnoutMultiplier() {
        return this.attributeRanges.get((Object)AttributeRegistry.BURNOUT_MULTI).base;
    }

    @Nonnull
    public final Color getSecondaryColor() {
        return this.secondaryColor;
    }

    public List<AttributeModifier> getAttributes() {
        return this.attributes;
    }

    public Map<AttributeRegistry.Attribute, AttributeRange> getAttributeRanges() {
        return this.attributeRanges;
    }

    public final void addAttribute(AttributeModifier attribute) {
        this.attributes.add(attribute);
    }

    public final void addAttributeRange(AttributeRegistry.Attribute attribute, AttributeRange range) {
        this.attributeRanges.put(attribute, range);
    }

    public boolean ignoreResultsForRendering() {
        return false;
    }

    public boolean shouldRunChildren() {
        return true;
    }

    public boolean run(@Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderSpell(@Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
    }

    public final boolean castSpell(@Nonnull SpellData spell, @Nonnull SpellRing spellRing, boolean doRendering) {
        boolean success = true;
        if (!spell.world.field_72995_K) {
            boolean alreadyCasted = false;
            if (this.moduleClass instanceof ILingeringModule) {
                boolean alreadyLingering = false;
                WizardryWorld worldCap = WizardryWorldCapability.get(spell.world);
                for (SpellTicker.LingeringObject lingeringObject : worldCap.getLingeringObjects()) {
                    if (lingeringObject.getSpellRing() != spellRing && lingeringObject.getSpellData() != spell) continue;
                    alreadyLingering = true;
                    break;
                }
                if (!alreadyLingering) {
                    boolean bl = success = this.internalCastSpell(spell, spellRing) && ((ILingeringModule)((Object)this.moduleClass)).runOnce(this, spell, spellRing);
                    if (success) {
                        worldCap.addLingerSpell(spellRing, spell, ((ILingeringModule)((Object)this.moduleClass)).getLingeringTime(spell, spellRing));
                    }
                    alreadyCasted = true;
                }
            }
            if (!alreadyCasted) {
                success = this.internalCastSpell(spell, spellRing);
                alreadyCasted = true;
            }
        }
        if (success || this.ignoreResultsForRendering()) {
            this.sendRenderPacket(spell, spellRing);
        }
        return success;
    }

    private final boolean internalCastSpell(@Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        SpellCastEvent event = new SpellCastEvent(spellRing, spell);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled() && this.run(spell, spellRing);
    }

    public final void sendRenderPacket(@Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d target = spell.getTargetWithFallback();
        if (target != null) {
            PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketRenderSpell(spell, spellRing), new NetworkRegistry.TargetPoint(spell.world.field_73011_w.getDimension(), target.field_72450_a, target.field_72448_b, target.field_72449_c, 60.0));
        }
    }

    @Nonnull
    public final NBTTagString serialize() {
        return new NBTTagString(this.getSubModuleID());
    }

    public ResourceLocation getIconLocation() {
        if (this.icon == null) {
            return new ResourceLocation("wizardry", "textures/gui/worktable/icons/" + this.getSubModuleID() + ".png");
        }
        return this.icon;
    }
}

