/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell;

import com.teamwizardry.wizardry.Wizardry;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;

public class SpellRingCache {
    private final HashMap<NBTTagCompound, SpellRing> cache = new HashMap();
    public static final SpellRingCache INSTANCE = new SpellRingCache();

    private SpellRingCache() {
    }

    public SpellRing getSpellRingByNBT(NBTTagCompound key) {
        return this.internalGetSpellRingByNBT(key, true);
    }

    synchronized SpellRing internalGetSpellRingByNBT(NBTTagCompound key, boolean mayCreate) {
        SpellRing spellRing = this.cache.get(key);
        if (spellRing == null && mayCreate) {
            spellRing = SpellRing.deserializeRing(key);
            spellRing = this.registerSpellRing(spellRing);
        }
        return spellRing;
    }

    synchronized SpellRing registerSpellRing(SpellRing spellRing) {
        if (spellRing.getParentRing() != null) {
            throw new IllegalArgumentException("Expects a spell ring chain head.");
        }
        NBTTagCompound nbt = spellRing.serializeNBT();
        SpellRing other = this.cache.put(nbt, spellRing);
        if (other != null && other != spellRing) {
            this.cache.put(nbt, other);
            return other;
        }
        if (other == null) {
            Wizardry.logger.info("SpellRing cache miss for " + spellRing);
        }
        return spellRing;
    }

    public synchronized void clear() {
        this.cache.clear();
    }
}

