/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.item;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import com.google.common.collect.ImmutableList;
import com.teamwizardry.wizardry.api.item.wheels.FindPearlWheelEvent;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(modid="wizardry")
public final class BaublesSupport {
    @SubscribeEvent
    @Optional.Method(modid="baubles")
    public static void pearlInventory(FindPearlWheelEvent inventories) {
        inventories.addItems((IItemHandler)BaublesApi.getBaublesHandler((EntityPlayer)inventories.player), 5000);
    }

    public static ItemStack getItem(EntityLivingBase entity, Item item) {
        for (ItemStack stack : BaublesSupport.getArmor(entity)) {
            if (stack.func_77973_b() != item) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getItem(EntityLivingBase entity, Item ... items) {
        for (ItemStack stack : BaublesSupport.getArmor(entity)) {
            for (Item item : items) {
                if (stack.func_77973_b() != item) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isBauble(ItemStack stack) {
        return StackHolder.ACCESSOR.get(stack);
    }

    public static Iterable<ItemStack> getArmor(EntityLivingBase entity) {
        return ArmorHolder.ACCESSOR.get(entity);
    }

    private static final class StackAccessor
    extends FallbackStackAccessor {
        private StackAccessor() {
        }

        @Override
        @Optional.Method(modid="baubles")
        public boolean get(ItemStack stack) {
            return stack.func_77973_b() instanceof IBauble;
        }
    }

    private static final class ArmorAccessor
    extends FallbackArmorAccessor {
        private ArmorAccessor() {
        }

        @Override
        @Optional.Method(modid="baubles")
        public Iterable<ItemStack> get(EntityLivingBase entity) {
            if (!(entity instanceof EntityPlayer)) {
                return entity.func_184193_aE();
            }
            if (BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity)) == null) {
                return entity.func_184193_aE();
            }
            ImmutableList.Builder stacks = ImmutableList.builder();
            IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity));
            for (BaubleType type : BaubleType.values()) {
                for (int slot : type.getValidSlots()) {
                    stacks.add((Object)inv.getStackInSlot(slot));
                }
            }
            return stacks.build();
        }
    }

    private static class FallbackStackAccessor {
        private FallbackStackAccessor() {
        }

        public boolean get(ItemStack stack) {
            return false;
        }
    }

    private static class FallbackArmorAccessor {
        private FallbackArmorAccessor() {
        }

        public Iterable<ItemStack> get(EntityLivingBase entity) {
            return entity.func_184193_aE();
        }
    }

    private static final class ArmorHolder {
        private static final FallbackArmorAccessor ACCESSOR = new ArmorAccessor();

        private ArmorHolder() {
        }
    }

    private static final class StackHolder {
        private static final FallbackStackAccessor ACCESSOR = new StackAccessor();

        private StackHolder() {
        }
    }
}

