/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.capability.world;

import com.teamwizardry.wizardry.api.capability.world.StandardWizardryWorld;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorld;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="wizardry")
public final class WizardryWorldCapability {
    private static final ResourceLocation WIZARDRY_WORLD_ID = new ResourceLocation("wizardry", "wizardry_world");
    @CapabilityInject(value=WizardryWorld.class)
    private static final Capability<WizardryWorld> CAPABILITY = null;

    private WizardryWorldCapability() {
    }

    public static Capability<WizardryWorld> capability() {
        return Objects.requireNonNull(CAPABILITY, "CAPABILITY");
    }

    public static void init() {
        CapabilityManager.INSTANCE.register(WizardryWorld.class, (Capability.IStorage)new WizardryWorldStorage(), StandardWizardryWorld::create);
    }

    public static WizardryWorld get(World world) {
        WizardryWorld cap = (WizardryWorld)world.getCapability(WizardryWorldCapability.capability(), null);
        if (cap == null) {
            throw new IllegalStateException("Missing capability: " + world.func_72912_H().func_76065_j() + "/" + world.field_73011_w.func_186058_p().func_186065_b());
        }
        return cap;
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<World> event) {
        event.addCapability(WIZARDRY_WORLD_ID, (ICapabilityProvider)StandardWizardryWorld.create((World)event.getObject()));
    }

    private static final class WizardryWorldStorage
    implements Capability.IStorage<WizardryWorld> {
        private WizardryWorldStorage() {
        }

        public NBTBase writeNBT(Capability<WizardryWorld> capability, WizardryWorld world, EnumFacing side) {
            return world.serializeNBT();
        }

        public void readNBT(Capability<WizardryWorld> capability, WizardryWorld world, EnumFacing side, NBTBase nbt) {
            if (nbt instanceof NBTTagCompound) {
                world.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
            }
        }
    }
}

