/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.block;

import com.google.common.collect.HashMultimap;
import com.teamwizardry.librarianlib.features.kotlin.ClientUtilMethods;
import com.teamwizardry.wizardry.api.block.IStructure;
import com.teamwizardry.wizardry.api.block.WizardryStructure;
import com.teamwizardry.wizardry.init.ModBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WizardryStructureRenderCompanion {
    private HashMultimap<Integer, Template.BlockInfo> blocks = HashMultimap.create();
    private HashMap<Integer, int[]> vboCaches = new HashMap();
    private boolean builtVBO = false;
    private IBlockAccess access = null;
    private Vec3i offset = null;
    private ResourceLocation loc;
    private WizardryStructure structure;

    public WizardryStructureRenderCompanion(ResourceLocation location) {
        this.loc = location;
    }

    @Nonnull
    public List<Template.BlockInfo> getBlockInfos() {
        if (this.getOrMakeStructure() == null) {
            return new ArrayList<Template.BlockInfo>();
        }
        return this.structure.blockInfos();
    }

    @Nullable
    private WizardryStructure getOrMakeStructure() {
        if (this.structure == null) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(this.loc);
            if (!(block instanceof IStructure) || block.getRegistryName() == null) {
                return null;
            }
            this.structure = new WizardryStructure(block.getRegistryName());
            this.offset = ((IStructure)block).offsetToCenter();
        }
        return this.structure;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(IBlockAccess access, float alpha) {
        if (this.getOrMakeStructure() == null) {
            return;
        }
        if (!this.builtVBO || this.access != access) {
            this.blocks = HashMultimap.create();
            this.vboCaches.clear();
            if (this.structure.sudoGetTemplateBlocks() == null) {
                return;
            }
            for (Template.BlockInfo info : this.structure.sudoGetTemplateBlocks()) {
                if (info.field_186243_b.func_185904_a() == Material.field_151579_a || info.field_186243_b.func_185901_i() == EnumBlockRenderType.INVISIBLE) continue;
                this.blocks.put((Object)info.field_186243_b.func_177230_c().func_180664_k().ordinal(), (Object)info);
            }
            Iterator<Object> iterator = this.blocks.keySet().iterator();
            while (iterator.hasNext()) {
                int layerID = (Integer)iterator.next();
                Tessellator tes = Tessellator.func_178181_a();
                BufferBuilder buffer = tes.func_178180_c();
                BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
                buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                for (Template.BlockInfo info : this.blocks.get((Object)layerID)) {
                    IBlockAccess blockAccess = access != null ? access : this.structure.getBlockAccess();
                    buffer.func_178969_c((double)info.field_186242_a.func_177958_n(), (double)info.field_186242_a.func_177956_o(), (double)info.field_186242_a.func_177952_p());
                    if (info.field_186243_b.func_177230_c() != ModBlocks.MANA_BATTERY) {
                        dispatcher.func_175019_b().func_178267_a(blockAccess, dispatcher.func_184389_a(info.field_186243_b), info.field_186243_b, BlockPos.field_177992_a, buffer, true);
                    } else {
                        try {
                            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("wizardry", "block/mana_crystal"));
                            IBakedModel battery = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
                            dispatcher.func_175019_b().func_178267_a(blockAccess, battery, info.field_186243_b, BlockPos.field_177992_a, buffer, false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    buffer.func_178969_c(0.0, 0.0, 0.0);
                }
                this.vboCaches.put(layerID, ClientUtilMethods.createCacheArrayAndReset((BufferBuilder)buffer));
                this.builtVBO = true;
                this.access = access;
            }
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179088_q();
            GlStateManager.func_179136_a((float)1.0f, (float)-0.05f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179109_b((float)(-this.offset.func_177958_n()), (float)(-this.offset.func_177956_o()), (float)(-this.offset.func_177952_p()));
            Iterator iterator = this.blocks.keySet().iterator();
            while (iterator.hasNext()) {
                int layerID = (Integer)iterator.next();
                Tessellator tes = Tessellator.func_178181_a();
                BufferBuilder buffer = tes.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                buffer.func_178981_a(this.vboCaches.get(layerID));
                for (int i = 0; i < buffer.func_178989_h(); ++i) {
                    int idx = buffer.func_78909_a(i + 1);
                    buffer.putColorRGBA(idx, 255, 255, 255, (int)(alpha * 255.0f));
                }
                tes.func_78381_a();
            }
            GlStateManager.func_179113_r();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
    }
}

