/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.tic.fluids;

import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.material.alloy.IAlloy;
import crazypants.enderio.integration.tic.fluids.MoltenMetal;
import crazypants.enderio.integration.tic.materials.TicMaterials;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;

public class Metal {
    private static final ResourceLocation TEX_STILL = new ResourceLocation("tconstruct:blocks/fluids/molten_metal_flow");
    private static final ResourceLocation TEX_FLOWING = new ResourceLocation("tconstruct:blocks/fluids/molten_metal");

    public static void createFluidMaterial(final @Nonnull IAlloy alloy) {
        Fluid fluid = new Fluid(alloy.getFluidName(), TEX_FLOWING, TEX_STILL){

            public int getColor() {
                return 0xFF000000 | alloy.getColor();
            }
        }.setDensity(9000).setLuminosity(6).setTemperature(alloy.getMeltingPoint() + 273).setViscosity(3000);
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        Material material = new Material(alloy.getBaseName(), alloy.getColor());
        material.addCommonItems(alloy.getOreName());
        TinkerRegistry.integrate((MaterialIntegration)new MaterialIntegration(material, fluid, alloy.getOreName()){

            public void registerFluidBlock(IForgeRegistry<Block> registry) {
            }
        }.toolforge()).preInit();
        if (!TicMaterials.hasIntegration(alloy)) {
            TicMaterials.addIntegration(alloy);
        }
        TicMaterials.getData(alloy).setFluid(fluid);
        TicMaterials.getData(alloy).setMaterial(material);
        TicMaterials.getData(alloy).stats();
    }

    public static void createMaterial(@Nonnull IAlloy alloy) {
        if (!TicMaterials.hasIntegration(alloy)) {
            return;
        }
        TicMaterials.getData(alloy).setMaterial(new Material(alloy.getBaseName(), alloy.getColor()));
        TicMaterials.getData(alloy).getMaterial().addCommonItems(alloy.getOreName());
        TinkerRegistry.integrate((MaterialIntegration)new MaterialIntegration(TicMaterials.getData(alloy).getMaterial(), null, alloy.getOreName()){

            public void registerFluidBlock(IForgeRegistry<Block> registry) {
            }
        }).preInit();
        TicMaterials.getData(alloy).stats();
    }

    public static void createFluidBlock(IForgeRegistry<Block> registry, @Nonnull IAlloy alloy) {
        if (TicMaterials.hasIntegration(alloy)) {
            registry.register((IForgeRegistryEntry)MoltenMetal.create(TicMaterials.getData(alloy).getFluid(), alloy.getColor()));
        }
    }

    public static void createTraits(@Nonnull IAlloy alloy) {
        if (TicMaterials.hasIntegration(alloy)) {
            TicMaterials.getData(alloy).traits();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers(@Nonnull IAlloy alloy) {
        if (TicMaterials.hasIntegration(alloy)) {
            Fluids.registerFluidBlockRendering((Fluid)TicMaterials.getData(alloy).getFluid());
        }
    }
}

