/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2;

import java.io.File;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.placebo.registry.RegistryInformationV2;
import shadows.placebo.util.RecipeHelper;
import shadows.plants2.compat.AAIntegration;
import shadows.plants2.compat.CrafttweakerIntegration;
import shadows.plants2.compat.ForestryIntegration;
import shadows.plants2.data.PlantConfig;
import shadows.plants2.data.PlantConstants;
import shadows.plants2.gen.Decorator;
import shadows.plants2.init.ModRegistry;
import shadows.plants2.network.ParticleMessage;
import shadows.plants2.proxy.IProxy;
import shadows.plants2.util.PlantUtil;

@Mod(modid="plants2", name="Plants", version="2.10.6", dependencies="required-after:placebo@[1.5.1,2.0.0);after:botania@[r1.10-354,);after:forestry;after:inspirations", acceptedMinecraftVersions="[1.12, 1.13)")
public class Plants2 {
    public static final String MODID = "plants2";
    public static final String MODNAME = "Plants";
    public static final String VERSION = "2.10.6";
    public static final String DEPS = "required-after:placebo@[1.5.1,2.0.0);after:botania@[r1.10-354,);after:forestry;after:inspirations";
    @Mod.Instance
    public static Plants2 INSTANCE;
    @SidedProxy(clientSide="shadows.plants2.proxy.ClientProxy", serverSide="shadows.plants2.proxy.ServerProxy")
    public static IProxy PROXY;
    public static Configuration CONFIG;
    public static Configuration BLOCK_CONFIG;
    public static final Logger LOGGER;
    public static final SimpleNetworkWrapper NETWORK;
    private static int disc;
    public static final RegistryInformationV2 INFO;
    public static final RecipeHelper HELPER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        CONFIG = new Configuration(new File(e.getModConfigurationDirectory(), "plants.cfg"));
        BLOCK_CONFIG = new Configuration(new File(e.getModConfigurationDirectory(), "plants_blocks.cfg"));
        CONFIG.load();
        MinecraftForge.EVENT_BUS.register((Object)new ModRegistry());
        PlantConfig.syncConfig(CONFIG);
        ModRegistry.tiles(e);
        PROXY.preInit(e);
        if (CONFIG.hasChanged()) {
            CONFIG.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new Decorator());
        ModRegistry.oreDict(e);
        PROXY.init(e);
        NETWORK.registerMessage(ParticleMessage.ParticleMessageHandler.class, ParticleMessage.class, disc++, Side.CLIENT);
        if (Loader.isModLoaded((String)"crafttweaker")) {
            CrafttweakerIntegration.processCauldronChanges();
        }
        for (ResourceLocation rl : PlantConfig.BIOME_BL) {
            Biome b = (Biome)ForgeRegistries.BIOMES.getValue(rl);
            if (b == null) {
                LOGGER.error("Invalid biome entry detected in the Plants biome blacklist, " + rl);
                continue;
            }
            PlantConfig.COMPUTED_BIOME_BL.add((Object)b);
        }
        if (Loader.isModLoaded((String)"actuallyadditions")) {
            AAIntegration.registerFarmerBehavior();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        ModRegistry.generators(e);
        PROXY.postInit(e);
        LOGGER.info(String.format("Plants is using %d block ids and %d item ids", INFO.getBlockList().size(), INFO.getItemList().size()));
        INFO.purge();
        PlantUtil.mergeToDefaultLate();
        if (Loader.isModLoaded((String)"forestry")) {
            ForestryIntegration.registerFlowersToForestry();
        }
        if (BLOCK_CONFIG.hasChanged()) {
            BLOCK_CONFIG.save();
        }
        if (PlantConfig.crystalForest) {
            BiomeDictionary.addTypes((Biome)ModRegistry.CRYSTAL_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD});
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)MODNAME);
        NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        disc = 0;
        INFO = new RegistryInformationV2(MODID, PlantConstants.TAB);
        HELPER = new RecipeHelper(MODID, MODNAME, (List)INFO.getRecipeList());
    }
}

