/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.client.gui;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import vazkii.arl.network.NetworkHandler;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.base.network.message.MessageMatrixEnchanterOperation;
import vazkii.quark.oddities.client.gui.button.GuiButtonMatrixEnchantingPlus;
import vazkii.quark.oddities.feature.MatrixEnchanting;
import vazkii.quark.oddities.inventory.ContainerMatrixEnchanting;
import vazkii.quark.oddities.inventory.EnchantmentMatrix;
import vazkii.quark.oddities.tile.TileMatrixEnchanter;

public class GuiMatrixEnchanting
extends GuiContainer {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("quark", "textures/misc/matrix_enchanting.png");
    InventoryPlayer playerInv;
    TileMatrixEnchanter enchanter;
    GuiButton plusButton;
    PieceList pieceList;
    EnchantmentMatrix.Piece hoveredPiece;
    int selectedPiece = -1;
    int gridHoverX;
    int gridHoverY;
    List<Integer> listPieces = null;

    public GuiMatrixEnchanting(InventoryPlayer playerInv, TileMatrixEnchanter enchanter) {
        super((Container)new ContainerMatrixEnchanting(playerInv, enchanter));
        this.playerInv = playerInv;
        this.enchanter = enchanter;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.selectedPiece = -1;
        this.plusButton = new GuiButtonMatrixEnchantingPlus(this.field_147003_i + 86, this.field_147009_r + 63);
        this.func_189646_b(this.plusButton);
        this.pieceList = new PieceList(this, 29, 64, this.field_147009_r + 11, this.field_147003_i + 139, 22);
        this.updateButtonStatus();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtonStatus();
        if (this.enchanter.matrix == null) {
            this.selectedPiece = -1;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.enchanter.charge > 0 && MatrixEnchanting.chargePerLapis > 0) {
            int maxHeight = 18;
            int barHeight = (int)((float)this.enchanter.charge / (float)MatrixEnchanting.chargePerLapis * (float)maxHeight);
            this.func_73729_b(i + 7, j + 32 + maxHeight - barHeight, 50, 176 + maxHeight - barHeight, 4, barHeight);
        }
        if (this.enchanter.matrix != null && this.enchanter.matrix.canGeneratePiece(this.enchanter.bookshelfPower, this.enchanter.enchantability)) {
            int x = i + 74;
            int y = j + 58;
            int xpCost = this.enchanter.matrix.getNewPiecePrice();
            int xpMin = this.enchanter.matrix.getMinXpLevel(this.enchanter.bookshelfPower, this.enchanter.enchantability);
            boolean has = this.enchanter.matrix.validateXp((EntityPlayer)this.field_146297_k.field_71439_g, this.enchanter.bookshelfPower, this.enchanter.enchantability);
            this.func_73729_b(x, y, 0, this.field_147000_g, 10, 10);
            String text = String.valueOf(xpCost);
            if (!has && this.field_146297_k.field_71439_g.field_71068_ca < xpMin) {
                this.field_146289_q.func_175063_a("!", (float)(x + 6), (float)(y + 3), 0xFF0000);
                text = I18n.func_74837_a((String)"quarkmisc.matrixMin", (Object[])new Object[]{xpMin});
            }
            this.field_146289_q.func_78276_b(text, (x -= this.field_146289_q.func_78256_a(text) - 5) - 1, y += 3, 0);
            this.field_146289_q.func_78276_b(text, x + 1, y, 0);
            this.field_146289_q.func_78276_b(text, x, y + 1, 0);
            this.field_146289_q.func_78276_b(text, x, y - 1, 0);
            this.field_146289_q.func_78276_b(text, x, y, has ? 0xC8FF8F : 0xFF8F8F);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.enchanter.func_145748_c_().func_150260_c(), 12, 5, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInv.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
        if (this.enchanter.matrix != null) {
            this.listPieces = this.enchanter.matrix.benchedPieces;
            this.renderMatrixGrid(this.enchanter.matrix);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.enchanter.matrix != null) {
            RenderHelper.func_74518_a();
            this.pieceList.drawScreen(mouseX, mouseY, ClientTicker.partialTicks);
        }
        if (this.hoveredPiece != null) {
            LinkedList<String> tooltip = new LinkedList<String>();
            tooltip.add(this.hoveredPiece.enchant.func_77316_c(this.hoveredPiece.level));
            int max = this.hoveredPiece.getMaxXP();
            if (max > 0) {
                tooltip.add(TextFormatting.GRAY + I18n.func_74837_a((String)"quarkmisc.matrixUpgrade", (Object[])new Object[]{this.hoveredPiece.xp, max}));
            }
            if (this.gridHoverX == -1) {
                tooltip.add("");
                tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"quarkmisc.matrixLeftClick"));
                tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"quarkmisc.matrixRightClick"));
            } else if (this.selectedPiece != -1) {
                EnchantmentMatrix.Piece p = this.getPiece(this.selectedPiece);
                if (p.enchant == this.hoveredPiece.enchant && this.hoveredPiece.level < this.hoveredPiece.enchant.func_77325_b()) {
                    tooltip.add("");
                    tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"quarkmisc.matrixMerge"));
                }
            }
            this.func_146283_a(tooltip, mouseX, mouseY);
        } else {
            this.func_191948_b(mouseX, mouseY);
        }
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (this.enchanter.matrix != null) {
            this.pieceList.handleMouseInput(mouseX, mouseY);
        }
        int gridMouseX = mouseX - this.field_147003_i - 86;
        int gridMouseY = mouseY - this.field_147009_r - 11;
        this.gridHoverX = gridMouseX < 0 ? -1 : gridMouseX / 10;
        int n = this.gridHoverY = gridMouseY < 0 ? -1 : gridMouseY / 10;
        if (this.gridHoverX < 0 || this.gridHoverX > 4 || this.gridHoverY < 0 || this.gridHoverY > 4) {
            this.gridHoverX = -1;
            this.gridHoverY = -1;
            this.hoveredPiece = null;
        } else if (this.enchanter.matrix != null) {
            int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
            this.hoveredPiece = this.getPiece(hover);
        }
        super.func_146274_d();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.enchanter.matrix == null) {
            return;
        }
        if (mouseButton == 0 && this.gridHoverX != -1) {
            int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
            if (this.selectedPiece != -1) {
                if (hover == -1) {
                    this.place(this.selectedPiece, this.gridHoverX, this.gridHoverY);
                } else {
                    this.merge(this.selectedPiece, this.gridHoverX, this.gridHoverY);
                }
            } else {
                this.remove(hover);
                if (!GuiMatrixEnchanting.func_146272_n()) {
                    this.selectedPiece = hover;
                }
            }
        } else if (mouseButton == 1 && this.selectedPiece != -1) {
            this.rotate(this.selectedPiece);
        }
    }

    private void renderMatrixGrid(EnchantmentMatrix matrix) {
        EnchantmentMatrix.Piece piece;
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)86.0f, (float)11.0f, (float)0.0f);
        for (int i : matrix.placedPieces) {
            EnchantmentMatrix.Piece piece2 = this.getPiece(i);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(piece2.x * 10), (float)(piece2.y * 10), (float)0.0f);
            this.renderPiece(piece2, 1.0f);
            GlStateManager.func_179121_F();
        }
        if (this.selectedPiece != -1 && this.gridHoverX != -1 && (piece = this.getPiece(this.selectedPiece)) != null && (this.hoveredPiece == null || piece.enchant != this.hoveredPiece.enchant || this.hoveredPiece.level >= this.hoveredPiece.enchant.func_77325_b())) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.gridHoverX * 10), (float)(this.gridHoverY * 10), (float)0.0f);
            float a = 0.2f;
            if (matrix.canPlace(piece, this.gridHoverX, this.gridHoverY)) {
                a = (float)((Math.sin((double)ClientTicker.total * 0.2) + 1.0) * 0.4 + 0.4);
            }
            this.renderPiece(piece, a);
            GlStateManager.func_179121_F();
        }
        if (this.hoveredPiece == null && this.gridHoverX != -1) {
            this.renderHover(this.gridHoverX, this.gridHoverY);
        }
        GlStateManager.func_179121_F();
    }

    private void renderPiece(EnchantmentMatrix.Piece piece, float a) {
        float r = (float)(piece.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(piece.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(piece.color & 0xFF) / 255.0f;
        boolean hovered = this.hoveredPiece == piece;
        for (int[] block : piece.blocks) {
            this.renderBlock(block[0], block[1], piece.type, r, g, b, a, hovered);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderBlock(int x, int y, int type, float r, float g, float b, float a, boolean hovered) {
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        this.func_73729_b(x * 10, y * 10, 11 + type * 10, this.field_147000_g, 10, 10);
        if (hovered) {
            this.renderHover(x, y);
        }
    }

    private void renderHover(int x, int y) {
        GuiMatrixEnchanting.func_73734_a((int)(x * 10), (int)(y * 10), (int)(x * 10 + 10), (int)(y * 10 + 10), (int)0x66FFFFFF);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.plusButton) {
            this.add();
        }
    }

    public void add() {
        this.send(0, 0, 0, 0);
    }

    public void place(int id, int x, int y) {
        this.send(1, id, x, y);
        this.selectedPiece = -1;
        this.click();
    }

    public void remove(int id) {
        this.send(2, id, 0, 0);
    }

    public void rotate(int id) {
        this.send(3, id, 0, 0);
    }

    public void merge(int id, int x, int y) {
        int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
        EnchantmentMatrix.Piece p = this.getPiece(hover);
        EnchantmentMatrix.Piece p1 = this.getPiece(this.selectedPiece);
        if (p != null && p1 != null && p.enchant == p1.enchant && p.level < p.enchant.func_77325_b()) {
            this.send(4, hover, id, 0);
            this.selectedPiece = -1;
            this.click();
        }
    }

    private void send(int operation, int arg0, int arg1, int arg2) {
        MessageMatrixEnchanterOperation message = new MessageMatrixEnchanterOperation(operation, arg0, arg1, arg2);
        NetworkHandler.INSTANCE.sendToServer((IMessage)message);
    }

    private void click() {
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    private void updateButtonStatus() {
        this.plusButton.field_146124_l = this.enchanter.matrix != null && this.enchanter.charge > 0 && this.enchanter.matrix.validateXp((EntityPlayer)this.field_146297_k.field_71439_g, this.enchanter.bookshelfPower, this.enchanter.enchantability) && this.enchanter.matrix.canGeneratePiece(this.enchanter.bookshelfPower, this.enchanter.enchantability);
    }

    private EnchantmentMatrix.Piece getPiece(int id) {
        EnchantmentMatrix matrix = this.enchanter.matrix;
        if (matrix != null) {
            return matrix.pieces.get(id);
        }
        return null;
    }

    public static class PieceList
    extends GuiScrollingList {
        private GuiMatrixEnchanting parent;
        private int mouseX;
        private int mouseY;

        public PieceList(GuiMatrixEnchanting parent, int width, int height, int top, int left, int entryHeight) {
            super(parent.field_146297_k, width, height, top, top + height, left, entryHeight, parent.field_146294_l, parent.field_146295_m);
            this.parent = parent;
        }

        protected int getSize() {
            return this.parent.listPieces == null ? 0 : this.parent.listPieces.size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
            int id = this.parent.listPieces.get(index);
            this.parent.selectedPiece = this.parent.selectedPiece == id ? -1 : id;
        }

        protected boolean isSelected(int index) {
            int id = this.parent.listPieces.get(index);
            return this.parent.selectedPiece == id;
        }

        protected void drawBackground() {
        }

        public void handleMouseInput(int mouseX, int mouseY) throws IOException {
            super.handleMouseInput(mouseX, mouseY);
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            int id = this.parent.listPieces.get(slotIdx);
            EnchantmentMatrix.Piece piece = this.parent.getPiece(id);
            if (piece != null) {
                if (this.mouseX >= this.left && this.mouseX < this.left + this.listWidth - 7 && this.mouseY >= slotTop && this.mouseY <= slotTop + this.slotHeight && this.mouseY < this.bottom) {
                    this.parent.hoveredPiece = piece;
                }
                this.parent.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(this.left + (this.listWidth - 7) / 2), (float)(slotTop + this.slotHeight / 2), (float)0.0f);
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                GlStateManager.func_179109_b((float)-4.0f, (float)-8.0f, (float)0.0f);
                this.parent.renderPiece(piece, 1.0f);
                GlStateManager.func_179121_F();
            }
        }
    }
}

