/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.gui.config;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLLog;
import vazkii.quark.base.client.gui.config.GuiButtonConfigSetting;
import vazkii.quark.base.client.gui.config.GuiConfigLink;
import vazkii.quark.base.module.ModuleLoader;

public class GuiConfigBase
extends GuiScreen {
    String title;
    GuiScreen parent;
    private static List<Property> restartRequiringProperties = new LinkedList<Property>();
    public static boolean mayRequireRestart = false;
    GuiButton backButton;

    public GuiConfigBase(GuiScreen parent) {
        this.parent = parent;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.title = I18n.func_74838_a((String)"quark.config.title");
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, TextFormatting.BOLD + this.title, this.field_146294_l / 2, 15, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.returnToParent();
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (this.backButton != null && button == this.backButton) {
            this.returnToParent();
        }
        if (button instanceof GuiButtonConfigSetting) {
            GuiButtonConfigSetting configButton = (GuiButtonConfigSetting)button;
            configButton.prop.set(!configButton.prop.getBoolean());
            if (configButton.prop.requiresMcRestart()) {
                if (restartRequiringProperties.contains(configButton.prop)) {
                    restartRequiringProperties.remove(configButton.prop);
                } else {
                    restartRequiringProperties.add(configButton.prop);
                }
                mayRequireRestart = !restartRequiringProperties.isEmpty();
            }
            ModuleLoader.loadConfig();
        }
    }

    void returnToParent() {
        this.field_146297_k.func_147108_a(this.parent);
        if (this.field_146297_k.field_71462_r == null) {
            this.field_146297_k.func_71381_h();
        }
    }

    void tryOpenWebsite(String url) {
        GuiConfigLink gui = new GuiConfigLink(this, url);
        this.field_146297_k.func_147108_a((GuiScreen)gui);
    }

    public void func_73878_a(boolean result, int id) {
        if (id == 0) {
            try {
                if (result) {
                    this.openWebLink(new URI("https://quark.vazkii.us"));
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    private void openWebLink(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            FMLLog.warning((String)"Couldn't open link: {}", (Object[])new Object[]{throwable == null ? "<UNKNOWN>" : throwable.getMessage()});
        }
    }
}

