/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.arl.block.BlockModContainer;
import vazkii.quark.automation.tile.TileRainDetector;
import vazkii.quark.base.block.IQuarkBlock;

public class BlockRainDetector
extends BlockModContainer
implements IQuarkBlock {
    protected static final AxisAlignedBB RAIN_DETECTOR_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    private static final PropertyBool POWER = PropertyBool.func_177716_a((String)"power");
    private static final PropertyBool INVERTED = PropertyBool.func_177716_a((String)"inverted");

    public BlockRainDetector() {
        super("rain_detector", Material.field_151576_e, new String[0]);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return RAIN_DETECTOR_AABB;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWER) != false ? 15 : 0;
    }

    public void updatePower(World worldIn, BlockPos pos) {
        if (worldIn.field_73011_w.func_191066_m()) {
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            boolean raining = worldIn.func_72896_J();
            worldIn.func_72929_e(1.0f);
            if (((Boolean)iblockstate.func_177229_b((IProperty)INVERTED)).booleanValue()) {
                boolean bl = raining = !raining;
            }
            if ((Boolean)iblockstate.func_177229_b((IProperty)POWER) != raining) {
                worldIn.func_180501_a(pos, iblockstate.func_177226_a((IProperty)POWER, (Comparable)Boolean.valueOf(raining)), 3);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (playerIn.func_175142_cm()) {
            if (worldIn.field_72995_K) {
                return true;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)INVERTED, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)INVERTED) == false)), 4);
            this.updatePower(worldIn, pos);
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileRainDetector();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWER, INVERTED});
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)POWER) != false ? 1 : 0) + ((Boolean)state.func_177229_b((IProperty)INVERTED) != false ? 2 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWER, (Comparable)Boolean.valueOf((meta & 1) != 0)).func_177226_a((IProperty)INVERTED, (Comparable)Boolean.valueOf((meta & 2) != 0));
    }
}

