/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry.module;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import com.lothrazar.cyclicmagic.registry.module.BaseEventModule;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LootTableModule
extends BaseEventModule
implements IHasConfig {
    private static final String LOOTPOOLNAME = "main";
    private Set<ResourceLocation> chests = new HashSet<ResourceLocation>();
    private boolean enableChestLoot;

    public LootTableModule() {
        this.chests.add(LootTableList.field_186424_f);
        this.chests.add(LootTableList.field_186429_k);
        this.chests.add(LootTableList.field_186430_l);
        this.chests.add(LootTableList.field_186425_g);
        this.chests.add(LootTableList.field_186422_d);
        this.chests.add(LootTableList.field_186428_j);
        this.chests.add(LootTableList.field_186427_i);
        this.chests.add(LootTableList.field_186426_h);
        this.chests.add(LootTableList.field_186423_e);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootPool main = event.getTable().getPool(LOOTPOOLNAME);
        if (main == null) {
            event.getTable().addPool(new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(1.0f, 2.0f), new RandomValueRange(1.0f, 1.0f), LOOTPOOLNAME));
            main = event.getTable().getPool(LOOTPOOLNAME);
            if (main == null) {
                ModCyclic.logger.error("could not insert Loot Pool for table :" + event.getName().toString());
                return;
            }
        }
        if (this.enableChestLoot) {
            this.onLootChestTableLoad(main, event);
        }
    }

    private void onLootChestTableLoad(LootPool main, LootTableLoadEvent event) {
        if (event.getName() == LootTableList.field_186420_b) {
            this.fillBonusChest(main);
        } else if (event.getName() == LootTableList.field_186431_m) {
            this.fillIglooChest(main);
        } else if (event.getName() == LootTableList.field_186421_c) {
            this.fillEndCityChest(main);
        } else if (this.chests.contains(event.getName())) {
            this.fillGenericChest(main);
        }
    }

    private void fillEndCityChest(LootPool main) {
        this.fillPoolFromMap(main, LootTableRegistry.endCityChest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillPoolFromMap(LootPool main, Map<Item, Integer> map) {
        Map<Item, Integer> map2 = map;
        synchronized (map2) {
            for (Map.Entry<Item, Integer> entry : map.entrySet()) {
                this.addLoot(main, entry.getKey(), entry.getValue());
            }
        }
    }

    private void fillGenericChest(LootPool main) {
        this.fillPoolFromMap(main, LootTableRegistry.genericChest);
    }

    private void fillIglooChest(LootPool main) {
        this.fillPoolFromMap(main, LootTableRegistry.iglooChest);
    }

    private void fillBonusChest(LootPool main) {
        this.fillPoolFromMap(main, LootTableRegistry.bonusChest);
    }

    private void addLoot(LootPool main, Item item, int rando) {
        if (item != null) {
            main.addEntry((LootEntry)new LootEntryItem(item, rando, 0, new LootFunction[0], new LootCondition[0], "cyclicmagic:" + item.func_77658_a()));
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enableChestLoot = config.getBoolean("ChestLoot", "cyclicmagic.world generation", true, "If true, then enabled items and blocks from this mod can appear in loot chests");
        LootTableRegistry.lootChanceDefault = config.getInt("ChestLootChance", "cyclicmagic.world generation", 4, 1, 99, "If ChestLoot is true, this is the default chance a cyclic item will show up as treasure.");
    }
}

