/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.registration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.theoneprobe.api.IProbeHitData;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import yuudaari.soulus.common.CreativeTab;
import yuudaari.soulus.common.compat.WailaProviders;
import yuudaari.soulus.common.registration.IRegistration;
import yuudaari.soulus.common.registration.Registration;

public interface IBlockRegistration
extends IRegistration<Block> {
    public static final Map<IBlockRegistration, ItemBlock> BLOCKS_WITH_ITEMS = new HashMap<IBlockRegistration, ItemBlock>();

    public Block getBlock();

    default public boolean hasItem() {
        return BLOCKS_WITH_ITEMS.containsKey(this);
    }

    @Override
    default public Item getItem() {
        return this.getItemBlock();
    }

    default public IBlockRegistration setHasItem() {
        BLOCKS_WITH_ITEMS.put(this, null);
        return this;
    }

    default public ItemBlock getItemBlock() {
        if (!BLOCKS_WITH_ITEMS.containsKey(this)) {
            throw new IllegalArgumentException("This block has no registered item");
        }
        ItemBlock result = BLOCKS_WITH_ITEMS.get(this);
        if (result == null) {
            result = this.createItemBlock();
            BLOCKS_WITH_ITEMS.put(this, result);
        }
        return result;
    }

    default public ItemBlock createItemBlock() {
        return new Registration.ItemBlock(this);
    }

    default public List<ItemBlock> getItemBlocks() {
        return Collections.singletonList(this.getItemBlock());
    }

    @SideOnly(value=Side.CLIENT)
    default public void registerItemModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this.getItemBlock(), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public void getSubBlocks(CreativeTabs var1, NonNullList<ItemStack> var2);

    default public NonNullList<ItemStack> getSubBlocks() {
        NonNullList items = NonNullList.func_191196_a();
        this.getSubBlocks(CreativeTab.INSTANCE, (NonNullList<ItemStack>)items);
        return items;
    }

    default public Class<? extends TileEntity> getTileEntityClass() {
        return null;
    }

    default public void registerWailaProvider(Class<? extends Block> cls) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            WailaProviders.providers.add(cls);
        }
    }

    default public List<String> getWailaTooltip(List<String> currentTooltip, IDataAccessor accessor) {
        return currentTooltip;
    }

    default public ItemStack getWailaStack(IDataAccessor accessor) {
        return null;
    }

    public static class DataAccessorTOP
    implements IDataAccessor {
        private final EntityPlayer PLAYER;
        private final IProbeHitData DATA;

        public DataAccessorTOP(EntityPlayer player, IProbeHitData probeHitData) {
            this.PLAYER = player;
            this.DATA = probeHitData;
        }

        @Override
        public TileEntity getTileEntity() {
            return this.PLAYER.func_130014_f_().func_175625_s(this.DATA.getPos());
        }

        @Override
        public EntityPlayer getPlayer() {
            return this.PLAYER;
        }

        @Override
        public IBlockState getBlockState() {
            return this.PLAYER.func_130014_f_().func_180495_p(this.DATA.getPos());
        }
    }

    public static class DataAccessorWaila
    implements IDataAccessor {
        private final IWailaDataAccessor accessor;

        public DataAccessorWaila(IWailaDataAccessor accessor) {
            this.accessor = accessor;
        }

        @Override
        public TileEntity getTileEntity() {
            return this.accessor.getTileEntity();
        }

        @Override
        public EntityPlayer getPlayer() {
            return this.accessor.getPlayer();
        }

        @Override
        public IBlockState getBlockState() {
            return this.accessor.getBlockState();
        }
    }

    public static interface IDataAccessor {
        public TileEntity getTileEntity();

        public EntityPlayer getPlayer();

        public IBlockState getBlockState();
    }
}

