/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.upgradeable_block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlock;

public abstract class UpgradeableBlockTileEntity
extends TileEntity
implements ITickable {
    public Map<UpgradeableBlock.IUpgrade, Integer> upgrades = new HashMap<UpgradeableBlock.IUpgrade, Integer>();
    public Stack<UpgradeableBlock.IUpgrade> insertionOrder;

    public UpgradeableBlockTileEntity() {
        for (UpgradeableBlock.IUpgrade upgrade : this.getBlock().getUpgrades()) {
            this.upgrades.put(upgrade, 0);
        }
        this.insertionOrder = new Stack();
        this.onUpdateUpgrades(false);
    }

    public abstract UpgradeableBlock<? extends UpgradeableBlockTileEntity> getBlock();

    public void addUpgradeStacksToList(List<ItemStack> list) {
        for (Map.Entry<UpgradeableBlock.IUpgrade, Integer> upgrade : this.upgrades.entrySet()) {
            upgrade.getKey().addItemStackToList(this, list, upgrade.getValue());
        }
    }

    public UpgradeableBlock.IUpgrade getUpgradeForItem(ItemStack stack) {
        for (Map.Entry<UpgradeableBlock.IUpgrade, Integer> upgradeEntry : this.upgrades.entrySet()) {
            UpgradeableBlock.IUpgrade upgrade = upgradeEntry.getKey();
            if (!upgrade.isItemStackForTileEntity(stack, this)) continue;
            return upgrade;
        }
        return null;
    }

    public final void insertUpgrade(ItemStack stack, UpgradeableBlock.IUpgrade upgrade, int quantity) {
        this.insertionOrder.remove(upgrade);
        this.insertionOrder.push(upgrade);
        int currentQuantity = this.upgrades.get(upgrade);
        int maxQuantity = upgrade.getMaxQuantity();
        int insertQuantity = Math.min(quantity, maxQuantity - currentQuantity);
        if (insertQuantity > 0) {
            int newQuantity = currentQuantity + insertQuantity;
            this.upgrades.put(upgrade, newQuantity);
            this.onInsertUpgrade(stack, upgrade, newQuantity);
            stack.func_190918_g(insertQuantity);
            this.onUpdateUpgrades(false);
        }
        this.blockUpdate();
    }

    public void onInsertUpgrade(ItemStack stack, UpgradeableBlock.IUpgrade upgrade, int newQuantity) {
    }

    public final UpgradeableBlock.IUpgrade popLastUpgrade() {
        return this.insertionOrder.size() == 0 ? null : this.insertionOrder.pop();
    }

    public int removeUpgrade(UpgradeableBlock.IUpgrade upgrade) {
        int result = this.upgrades.get(upgrade);
        this.upgrades.put(upgrade, 0);
        this.onUpdateUpgrades(false);
        this.blockUpdate();
        return result;
    }

    public void clear() {
        for (UpgradeableBlock.IUpgrade upgrade : this.getBlock().getUpgrades()) {
            this.upgrades.put(upgrade, 0);
        }
        this.onUpdateUpgrades(false);
        this.blockUpdate();
    }

    public static IInventory getFacingInventory(World world, BlockPos pos, EnumFacing facing) {
        BlockPos facingPos = pos.func_177972_a(facing);
        return TileEntityHopper.func_145893_b((World)world, (double)facingPos.func_177958_n(), (double)facingPos.func_177956_o(), (double)facingPos.func_177952_p());
    }

    public static ItemStack insertItem(ItemStack stack, World world, BlockPos pos, EnumFacing facing) {
        IInventory facingInventory = UpgradeableBlockTileEntity.getFacingInventory(world, pos, facing);
        if (facingInventory == null) {
            return stack;
        }
        return UpgradeableBlockTileEntity.insertItem(stack, facing, facingInventory);
    }

    private static ItemStack insertItem(ItemStack stack, EnumFacing facing, IInventory inventory) {
        ItemStack result = TileEntityHopper.func_174918_a(null, (IInventory)inventory, (ItemStack)stack.func_77946_l(), (EnumFacing)facing.func_176734_d());
        stack.func_190920_e(result.func_190916_E());
        return result;
    }

    public static void dispenseItem(ItemStack stack, World world, BlockPos pos, EnumFacing facing) {
        if (!stack.func_190926_b()) {
            IInventory facingInventory = UpgradeableBlockTileEntity.getFacingInventory(world, pos, facing);
            if (facingInventory != null) {
                UpgradeableBlockTileEntity.insertItem(stack, facing, facingInventory);
                return;
            }
            double d0 = (double)pos.func_177958_n() + 0.5 + (double)facing.func_82601_c() / 1.5;
            double d1 = (double)pos.func_177956_o() + 0.5 + (double)facing.func_96559_d() / 1.5;
            double d2 = (double)pos.func_177952_p() + 0.5 + (double)facing.func_82599_e() / 1.5;
            d1 = facing.func_176740_k() == EnumFacing.Axis.Y ? (d1 -= 0.125) : (d1 -= 0.15625);
            EntityItem itemEntity = new EntityItem(world, d0, d1, d2, stack);
            double d3 = world.field_73012_v.nextDouble() * 0.1 + 0.2;
            itemEntity.field_70159_w = (double)facing.func_82601_c() * d3;
            itemEntity.field_70181_x = (double)facing.func_96559_d() * d3;
            itemEntity.field_70179_y = (double)facing.func_82599_e() * d3;
            double speed = 1.5;
            itemEntity.field_70159_w += world.field_73012_v.nextGaussian() * 0.0075 * speed;
            itemEntity.field_70181_x += world.field_73012_v.nextGaussian() * 0.0075 * speed;
            itemEntity.field_70179_y += world.field_73012_v.nextGaussian() * 0.0075 * speed;
            world.func_72838_d((Entity)itemEntity);
        }
    }

    public void onUpdateUpgrades(boolean readFromNBT) {
    }

    public void onReadFromNBT(NBTTagCompound compound) {
    }

    public void onWriteToNBT(NBTTagCompound compound) {
    }

    public final void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        UpgradeableBlock.IUpgrade[] upgrades = this.getBlock().getUpgrades();
        NBTTagCompound upgradeTag = compound.func_74775_l("upgrades");
        for (UpgradeableBlock.IUpgrade upgrade : upgrades) {
            this.upgrades.put(upgrade, upgradeTag.func_74762_e(upgrade.getName()));
        }
        this.insertionOrder = new Stack();
        NBTTagList value = (NBTTagList)compound.func_74781_a("insertion_order");
        for (NBTBase s : value) {
            if (!(s instanceof NBTTagString)) continue;
            String str = ((NBTTagString)s).func_150285_a_();
            for (UpgradeableBlock.IUpgrade u : upgrades) {
                if (!u.getName().equals(str)) continue;
                this.insertionOrder.add(u);
            }
        }
        this.onUpdateUpgrades(true);
        this.onReadFromNBT(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.onWriteToNBT(compound);
        NBTTagList list = new NBTTagList();
        for (UpgradeableBlock.IUpgrade upgrade : this.insertionOrder) {
            list.func_74742_a((NBTBase)new NBTTagString(upgrade.getName()));
        }
        compound.func_74782_a("insertion_order", (NBTBase)list);
        UpgradeableBlock.IUpgrade[] upgrades = this.getBlock().getUpgrades();
        NBTTagCompound upgradeTag = new NBTTagCompound();
        for (UpgradeableBlock.IUpgrade upgrade : upgrades) {
            upgradeTag.func_74768_a(upgrade.getName(), this.upgrades.get(upgrade).intValue());
        }
        compound.func_74782_a("upgrades", (NBTBase)upgradeTag);
        return compound;
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public final void blockUpdate() {
        if (this.field_145850_b != null) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
            this.func_70296_d();
        }
    }
}

