/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.summoner;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import scala.Tuple2;
import yuudaari.soulus.Soulus;
import yuudaari.soulus.common.advancement.Advancements;
import yuudaari.soulus.common.block.soul_totem.SoulTotemTileEntity;
import yuudaari.soulus.common.block.summoner.Summoner;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlock;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigSummoner;
import yuudaari.soulus.common.config.essence.ConfigEssence;
import yuudaari.soulus.common.config.essence.ConfigEssences;
import yuudaari.soulus.common.item.EssencePerfect;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.util.ModPotionEffect;
import yuudaari.soulus.common.util.Range;

@ConfigInjected(value="soulus")
public class SummonerTileEntity
extends UpgradeableBlockTileEntity
implements ITickable {
    @ConfigInjected.Inject
    public static ConfigSummoner CONFIG;
    @ConfigInjected.Inject
    public static ConfigEssences CONFIG_ESSENCES;
    private boolean hasInit = false;
    private String essenceType;
    private float timeTillSpawn = 0.0f;
    private float lastTimeTillSpawn;
    private float boost = 0.0f;
    private Float soulbookUses = null;
    private boolean malice = true;
    private int spawningRadius;
    private int activatingRange;
    private Range spawnDelay;
    private Range spawnCount;
    private boolean usedPlayer = false;
    private int signalStrength;
    private double timeTillParticle = 0.0;
    public double mobRotation;
    public double prevMobRotation;
    public EntityLiving renderMob;
    private ConfigEssence spawnMobConfig;
    private int spawnMobChanceTotal;
    public String lastRenderedEssenceType;
    private double activationAmount = 0.0;
    private Set<EntityPlayer> players = new HashSet<EntityPlayer>();
    private int timeTillNextMajorUpdate = 0;

    public Summoner getBlock() {
        return BlockRegistry.SUMMONER;
    }

    public boolean hasMalice() {
        return this.malice && (Integer)this.upgrades.get(Summoner.Upgrade.CRYSTAL_DARK) > 0;
    }

    public float getSoulbookUses() {
        if (this.soulbookUses == null && SummonerTileEntity.CONFIG.soulbookUses != null && SummonerTileEntity.CONFIG.soulbookUses > 0) {
            this.soulbookUses = Float.valueOf(SummonerTileEntity.CONFIG.soulbookUses.intValue());
        }
        return this.soulbookUses.floatValue();
    }

    public void setSoulbookUses(Float val) {
        this.soulbookUses = val;
    }

    public void reset() {
        this.renderMob = null;
        this.resetTimer();
    }

    @Override
    public void onInsertUpgrade(ItemStack stack, UpgradeableBlock.IUpgrade upgrade, int newQuantity) {
        if (upgrade == Summoner.Upgrade.CRYSTAL_DARK) {
            this.malice = false;
        }
    }

    private void onUpdateUpgrades() {
        this.onUpdateUpgrades(false);
    }

    @Override
    public void onUpdateUpgrades(boolean readFromNBT) {
        if (this.func_145837_r()) {
            Soulus.removeConfigReloadHandler(this::onUpdateUpgrades);
            return;
        }
        Soulus.onConfigReload(this::onUpdateUpgrades);
        if ((Integer)this.upgrades.get(Summoner.Upgrade.CRYSTAL_DARK) > 0) {
            this.spawnCount = SummonerTileEntity.CONFIG.midnightJewelCount;
            this.spawningRadius = SummonerTileEntity.CONFIG.midnightJewelSpawningRadius;
            this.spawnDelay = SummonerTileEntity.CONFIG.midnightJewelDelay;
            this.activatingRange = SummonerTileEntity.CONFIG.midnightJewelRange;
        } else {
            int countUpgrades = (Integer)this.upgrades.get(Summoner.Upgrade.COUNT);
            this.spawnCount = new Range(SummonerTileEntity.CONFIG.nonUpgradedCount.min + (double)countUpgrades * SummonerTileEntity.CONFIG.upgradeCountEffectiveness.min, SummonerTileEntity.CONFIG.nonUpgradedCount.max + (double)countUpgrades * SummonerTileEntity.CONFIG.upgradeCountEffectiveness.max);
            this.spawningRadius = (int)Math.floor((double)SummonerTileEntity.CONFIG.nonUpgradedSpawningRadius + (double)countUpgrades * SummonerTileEntity.CONFIG.upgradeCountRadiusEffectiveness);
            int delayUpgrades = (Integer)this.upgrades.get(Summoner.Upgrade.DELAY);
            this.spawnDelay = new Range(SummonerTileEntity.CONFIG.nonUpgradedDelay.min / (1.0 + (double)delayUpgrades * SummonerTileEntity.CONFIG.upgradeDelayEffectiveness.min), SummonerTileEntity.CONFIG.nonUpgradedDelay.max / (1.0 + (double)delayUpgrades * SummonerTileEntity.CONFIG.upgradeDelayEffectiveness.max));
            int rangeUpgrades = (Integer)this.upgrades.get(Summoner.Upgrade.RANGE);
            this.activatingRange = SummonerTileEntity.CONFIG.nonUpgradedRange + rangeUpgrades * SummonerTileEntity.CONFIG.upgradeRangeEffectiveness;
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!readFromNBT) {
                this.resetTimer(false);
            }
            this.blockUpdate();
        }
    }

    public String getEssenceType() {
        return this.essenceType;
    }

    public void setEssenceType(String essenceType) {
        this.essenceType = essenceType;
        this.resetEssenceType();
    }

    private void resetEssenceType() {
        this.spawnMobConfig = CONFIG_ESSENCES.get(this.essenceType);
        this.spawnMobChanceTotal = 0;
        if (this.spawnMobConfig != null && this.spawnMobConfig.spawns != null) {
            for (double dropChance : this.spawnMobConfig.spawns.values()) {
                this.spawnMobChanceTotal = (int)((double)this.spawnMobChanceTotal + dropChance);
            }
        }
    }

    public int getSignalStrength() {
        return this.signalStrength;
    }

    public NBTTagCompound getEntityNbt() {
        NBTTagCompound result = new NBTTagCompound();
        result.func_74778_a("id", this.getSpawnMob());
        result.func_74774_a("PersistenceRequired", (byte)1);
        return result;
    }

    private String getSpawnMob() {
        if (this.spawnMobChanceTotal > 0 && this.spawnMobConfig != null) {
            int choice = new Random().nextInt(this.spawnMobChanceTotal);
            for (Map.Entry<String, Double> spawnConfig : this.spawnMobConfig.spawns.entrySet()) {
                if ((choice = (int)((double)choice - spawnConfig.getValue())) >= 0) continue;
                return spawnConfig.getKey();
            }
        }
        return this.essenceType;
    }

    public float getSpawnPercent() {
        return (this.lastTimeTillSpawn - this.timeTillSpawn) / this.lastTimeTillSpawn;
    }

    private void updateActivationAmount() {
        this.activationAmount = 0.0;
        if (!(this.malice && (Integer)this.upgrades.get(Summoner.Upgrade.CRYSTAL_DARK) >= 1 || this.field_145850_b.func_175687_A(this.field_174879_c) == 0)) {
            return;
        }
        if (SummonerTileEntity.CONFIG.soulbookUses != null && SummonerTileEntity.CONFIG.soulbookUses > 0 && this.getSoulbookUses() <= 0.0f) {
            return;
        }
        if (!this.hasMalice()) {
            this.players.clear();
        }
        for (EntityPlayer player : this.field_145850_b.field_73010_i) {
            if (!EntitySelectors.field_180132_d.apply((Object)player)) continue;
            double d0 = player.func_174831_c(this.field_174879_c);
            double nearAmt = d0 / (double)(this.activatingRange * this.activatingRange);
            this.activationAmount += Math.max(0.0, (1.0 - nearAmt * nearAmt) * 2.0);
            if (!(this.activationAmount > 0.0)) continue;
            if (!this.hasMalice()) {
                this.players.add(player);
            }
            this.usedPlayer = true;
        }
        for (TileEntity te : this.field_145850_b.field_147482_g) {
            SoulTotemTileEntity ste;
            EntityPlayer player;
            if (!(te instanceof SoulTotemTileEntity) || !((SoulTotemTileEntity)te).isActive()) continue;
            if (!this.hasMalice() && (player = (ste = (SoulTotemTileEntity)te).getOwner()) != null) {
                this.players.add(player);
            }
            BlockPos tePos = te.func_174877_v();
            double d0 = this.field_174879_c.func_177957_d((double)tePos.func_177958_n() + 0.5, (double)tePos.func_177956_o() + 0.5, (double)tePos.func_177952_p() + 0.5);
            double nearAmt = d0 / (double)(this.activatingRange * this.activatingRange);
            this.activationAmount += Math.max(0.0, (1.0 - nearAmt * nearAmt) * 2.0);
        }
        if ((double)this.boost > 0.01) {
            this.activationAmount *= (double)(1.0f + this.boost);
            this.boost = (float)((double)this.boost * SummonerTileEntity.CONFIG.perfectEssenceBoostDecay);
        }
    }

    public boolean insertPerfectEssence(ItemStack stack, boolean all) {
        String essenceType = this.getEssenceType();
        String[] perfectEssenceTypes = EssencePerfect.getEssenceTypes(stack);
        if (!Arrays.stream(perfectEssenceTypes).anyMatch(essenceType::equalsIgnoreCase)) {
            return false;
        }
        int count = all ? stack.func_190916_E() : 1;
        for (int i = 0; i < count; ++i) {
            this.boost = (float)((double)this.boost + SummonerTileEntity.CONFIG.perfectEssenceBoost * this.spawnDelay.get(this.field_145850_b.field_73012_v));
        }
        this.blockUpdate();
        this.timeTillNextMajorUpdate = 0;
        stack.func_190918_g(count);
        return true;
    }

    public void func_73660_a() {
        if (this.essenceType == null) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)Summoner.HAS_SOULBOOK, (Comparable)Boolean.valueOf(false)));
            return;
        }
        if (!this.hasInit) {
            this.hasInit = true;
            this.onUpdateUpgrades(false);
        }
        if (--this.timeTillNextMajorUpdate < 0) {
            this.timeTillNextMajorUpdate = 20;
            this.updateActivationAmount();
        }
        if (this.field_145850_b.field_72995_K) {
            this.updateRenderer(this.activationAmount);
        } else {
            this.updateSignalStrength(this.activationAmount);
        }
        this.timeTillSpawn = (float)((double)this.timeTillSpawn - this.activationAmount);
        if (this.timeTillSpawn <= 0.0f) {
            this.resetTimer();
            if (!this.field_145850_b.field_72995_K) {
                this.spawn();
            }
        }
    }

    private void updateSignalStrength(double activationAmount) {
        int signalStrength;
        int n = signalStrength = activationAmount <= 0.0 ? 0 : (int)Math.floor(15.0f * this.getSpawnPercent()) + 1;
        if (signalStrength != this.signalStrength) {
            this.signalStrength = signalStrength;
            this.func_70296_d();
        }
    }

    private void resetTimer() {
        this.resetTimer(true);
    }

    private void resetTimer(boolean update) {
        this.lastTimeTillSpawn = this.timeTillSpawn = (float)this.spawnDelay.getInt(this.field_145850_b.field_73012_v);
        this.timeTillNextMajorUpdate = 0;
        if (update) {
            this.blockUpdate();
        }
    }

    @Override
    public void onReadFromNBT(NBTTagCompound compound) {
        this.hasInit = true;
        this.essenceType = compound.func_74779_i("entity_type");
        this.soulbookUses = Float.valueOf(compound.func_74760_g("soulbook_uses"));
        if (this.soulbookUses.floatValue() == -101.0f || SummonerTileEntity.CONFIG.soulbookUses == null || SummonerTileEntity.CONFIG.soulbookUses <= 0) {
            this.soulbookUses = null;
        }
        this.resetEssenceType();
        this.timeTillSpawn = compound.func_74760_g("delay");
        this.lastTimeTillSpawn = compound.func_74760_g("delay_last");
        this.malice = compound.func_74767_n("malice");
        this.usedPlayer = compound.func_74767_n("used_player");
        this.boost = compound.func_74760_g("boost");
        this.onUpdateUpgrades(false);
        this.timeTillNextMajorUpdate = 0;
    }

    @Override
    @Nonnull
    public void onWriteToNBT(NBTTagCompound compound) {
        if (this.essenceType == null) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)Summoner.HAS_SOULBOOK, (Comparable)Boolean.valueOf(false)));
            return;
        }
        compound.func_74778_a("entity_type", this.essenceType);
        compound.func_74776_a("soulbook_uses", this.soulbookUses == null ? -101.0f : this.soulbookUses.floatValue());
        compound.func_74776_a("delay", this.timeTillSpawn);
        compound.func_74776_a("delay_last", this.lastTimeTillSpawn);
        compound.func_74757_a("malice", this.malice);
        compound.func_74757_a("used_player", this.usedPlayer);
        compound.func_74776_a("boost", this.boost);
    }

    private boolean isPlayerInRangeForEffects() {
        return this.field_145850_b.func_175636_b((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0);
    }

    private void updateRenderer(double activationAmount) {
        double diff = this.mobRotation - this.prevMobRotation;
        this.prevMobRotation = this.mobRotation;
        this.mobRotation += activationAmount <= 0.0 ? diff * 0.9 : (double)this.getSpawnPercent() + diff * 0.8;
        if (activationAmount <= 0.0) {
            return;
        }
        if (this.isPlayerInRangeForEffects()) {
            double particleCount = SummonerTileEntity.CONFIG.particleCountActivated * Math.min(1.0, activationAmount * activationAmount) * (0.5 + (double)(this.getSpawnPercent() / 2.0f));
            if (particleCount < 1.0) {
                this.timeTillParticle += 0.01 + particleCount;
                if (this.timeTillParticle < 1.0) {
                    return;
                }
            }
            this.timeTillParticle = 0.0;
            int i = 0;
            while ((double)i < particleCount) {
                double d3 = (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
                double d4 = (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
                double d5 = (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
                this.field_145850_b.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, d3 - (double)this.field_174879_c.func_177958_n() - 0.5, -0.3, d5 - (double)this.field_174879_c.func_177952_p() - 0.5, new int[0]);
                ++i;
            }
        }
    }

    private int spawn() {
        int spawnCount = this.spawnCount.getInt(this.field_145850_b.field_73012_v);
        int spawned = 0;
        block0: for (int i = 0; i < spawnCount; ++i) {
            NBTTagCompound entityNbt = this.getEntityNbt();
            for (int tries = 0; tries < 5; ++tries) {
                LivingSpawnEvent.SpecialSpawn specialSpawn;
                double z;
                double y;
                double x = (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble() * (double)this.spawningRadius * 2.0 + 0.5 - (double)this.spawningRadius;
                EntityLiving entity = (EntityLiving)AnvilChunkLoader.func_186054_a((NBTTagCompound)entityNbt, (World)this.field_145850_b, (double)x, (double)(y = (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble() * (double)this.spawningRadius / 2.0 + 0.5 - (double)(this.spawningRadius / 4)), (double)(z = (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble() * (double)this.spawningRadius * 2.0 + 0.5 - (double)this.spawningRadius), (boolean)false);
                if (entity == null) {
                    return 0;
                }
                AxisAlignedBB boundingBox = new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_186662_g((double)this.spawningRadius);
                if ((double)this.field_145850_b.func_72872_a(entity.getClass(), boundingBox).size() >= Math.pow(this.spawningRadius * 2, 2.0) / 8.0) break block0;
                if (this.field_145850_b.func_184143_b(entity.func_174813_aQ())) continue;
                NBTTagCompound entityData = entity.getEntityData();
                entityData.func_74774_a("soulus:spawn_whitelisted", (byte)2);
                entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
                ModPotionEffect[] potionEffects = SummonerTileEntity.CONFIG.stylePotionEffects.get(this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(Summoner.VARIANT));
                if (potionEffects != null) {
                    for (ModPotionEffect effect : potionEffects) {
                        effect.apply((EntityLivingBase)entity);
                    }
                }
                if (!MinecraftForge.EVENT_BUS.post((Event)(specialSpawn = new LivingSpawnEvent.SpecialSpawn(entity, this.field_145850_b, (float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v, null)))) {
                    entity.func_180482_a(this.field_145850_b.func_175649_E(new BlockPos((Entity)entity)), null);
                }
                AnvilChunkLoader.func_186052_a((Entity)entity, (World)this.field_145850_b);
                if (this.isPlayerInRangeForEffects()) {
                    this.explosionParticles(entity);
                }
                ++spawned;
                for (EntityPlayer player : this.players) {
                    Advancements.SUMMON_CREATURE.trigger(player, new Tuple2((Object)this.essenceType, (Object)this.usedPlayer));
                }
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187941_ho, SoundCategory.NEUTRAL, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.6f);
                continue block0;
            }
        }
        if (SummonerTileEntity.CONFIG.soulbookUses != null && SummonerTileEntity.CONFIG.soulbookUses > 0 && (Integer)this.upgrades.get(Summoner.Upgrade.CRYSTAL_DARK) < 1) {
            this.soulbookUses = Float.valueOf(this.soulbookUses.floatValue() - (float)((double)spawned * SummonerTileEntity.CONFIG.efficiencyUpgradeRange.get((double)((Integer)this.upgrades.get(Summoner.Upgrade.EFFICIENCY)).intValue() / (double)Summoner.Upgrade.EFFICIENCY.getMaxQuantity())));
        }
        this.usedPlayer = false;
        return spawned;
    }

    private void explosionParticles(EntityLiving entity) {
        Random rand = this.field_145850_b.field_73012_v;
        WorldServer worldServer = this.field_145850_b.func_73046_m().func_71218_a(entity.field_71093_bK);
        for (int i = 0; i < SummonerTileEntity.CONFIG.particleCountSpawn; ++i) {
            double d0 = rand.nextGaussian() * 0.02;
            double d1 = rand.nextGaussian() * 0.02;
            double d2 = rand.nextGaussian() * 0.02;
            worldServer.func_175739_a(EnumParticleTypes.DRAGON_BREATH, entity.field_70165_t + (double)(rand.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N - d0 * 10.0, entity.field_70163_u + (double)(rand.nextFloat() * entity.field_70131_O) - d1 * 10.0, entity.field_70161_v + (double)(rand.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N - d2 * 10.0, 1, d0, d1, d2, Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2), new int[0]);
            double d3 = (float)this.field_174879_c.func_177958_n() + rand.nextFloat();
            double d4 = (float)this.field_174879_c.func_177956_o() + rand.nextFloat();
            double d5 = (float)this.field_174879_c.func_177952_p() + rand.nextFloat();
            double d3o = ((double)this.field_174879_c.func_177958_n() - d3 - 0.5) / 20.0;
            double d4o = ((double)this.field_174879_c.func_177956_o() - d4) / 20.0;
            double d5o = ((double)this.field_174879_c.func_177952_p() - d5 - 0.5) / 20.0;
            worldServer.func_175739_a(EnumParticleTypes.DRAGON_BREATH, d3, d4, d5, 1, d3o, d4o, d5o, Math.sqrt(d3o * d3o + d4o * d4o + d5o * d5o) * 2.0, new int[0]);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c() || oldState.func_177229_b((IProperty)Summoner.HAS_SOULBOOK) != newState.func_177229_b((IProperty)Summoner.HAS_SOULBOOK);
    }
}

