/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.composer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import yuudaari.soulus.common.block.composer.ComposerCellTileEntity;
import yuudaari.soulus.common.block.composer.IFillableWithEssence;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlock;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigComposerCell;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.util.Material;
import yuudaari.soulus.common.util.Translation;

@ConfigInjected(value="soulus")
public class ComposerCell
extends UpgradeableBlock<ComposerCellTileEntity> {
    @ConfigInjected.Inject
    public static ConfigComposerCell CONFIG;
    public static final IProperty<CellState> CELL_STATE;

    @Override
    public UpgradeableBlock.IUpgrade[] getUpgrades() {
        return new UpgradeableBlock.IUpgrade[0];
    }

    public ComposerCell() {
        super("composer_cell", new Material(MapColor.field_151665_m).setTransparent());
        this.setHasItem();
        this.func_149711_c(5.0f);
        this.func_149752_b(30.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149649_H();
        this.func_180632_j(this.func_176223_P().func_177226_a(CELL_STATE, (Comparable)((Object)CellState.DISCONNECTED)));
        this.setHasDescription();
    }

    @Override
    public UpgradeableBlock<ComposerCellTileEntity> getInstance() {
        return BlockRegistry.COMPOSER_CELL;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        if (state.func_177229_b(CELL_STATE) == CellState.DISCONNECTED) {
            ComposerCell.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.25, 0.9375));
            ComposerCell.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.25, 0.1875, 0.9375, 0.5625, 0.8125));
            ComposerCell.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.5625, 0.0, 1.0, 1.0, 1.0));
        } else {
            ComposerCell.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185890_d((IBlockAccess)worldIn, pos));
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        ComposerCellTileEntity te = (ComposerCellTileEntity)world.func_175625_s(pos);
        ItemStack stack = te.getStoredItem();
        if (stack == null || te.storedQuantity <= 0) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof IFillableWithEssence && te.storedQuantity == 1) {
            return 1 + (int)Math.floor(14.0f * ((IFillableWithEssence)item).getFillPercentage(stack));
        }
        return 1 + (int)Math.floor(14.0f * ((float)te.storedQuantity / (float)ComposerCell.CONFIG.maxQuantity));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CELL_STATE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(CELL_STATE, (Comparable)((Object)CellState.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((CellState)((Object)state.func_177229_b(CELL_STATE))).getMeta();
    }

    @Override
    public boolean hasTileEntity(IBlockState blockState) {
        return true;
    }

    @Override
    public Class<? extends UpgradeableBlockTileEntity> getTileEntityClass() {
        return ComposerCellTileEntity.class;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        ComposerCellTileEntity te = (ComposerCellTileEntity)world.func_175625_s(pos);
        if (te != null) {
            te.shouldCheckSignal = true;
        }
    }

    @Override
    public boolean canActivateWithStack(ItemStack stack, World world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean canActivateTileEntity(ComposerCellTileEntity te) {
        return te.storedQuantity < ComposerCell.CONFIG.maxQuantity;
    }

    @Override
    public boolean onActivateInsert(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        ComposerCellTileEntity te = (ComposerCellTileEntity)world.func_175625_s(pos);
        if (player.func_70093_af() && !ComposerCell.CONFIG.allowSneakRightClickStackInsertion) {
            return false;
        }
        return te.tryInsert(stack, player.func_70093_af() ? stack.func_190916_E() : 1);
    }

    @Override
    public boolean onActivateEmptyHand(World world, BlockPos pos, EntityPlayer player) {
        ComposerCellTileEntity te = (ComposerCellTileEntity)world.func_175625_s(pos);
        if (te.storedItem == null) {
            return false;
        }
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>();
        this.addItemStackToList(te.storedItem, toReturn, te.storedQuantity);
        ComposerCell.returnItemsToPlayer(world, toReturn, player);
        te.storedItem = null;
        te.storedQuantity = 0;
        te.onChangeItem();
        te.blockUpdate();
        return true;
    }

    @Override
    public boolean onActivateEmptyHandSneaking(World world, BlockPos pos, EntityPlayer player) {
        return this.onActivateEmptyHand(world, pos, player);
    }

    public void addItemStackToList(ItemStack item, List<ItemStack> list, int quantity) {
        int maxStackSize = item.func_77976_d();
        while (quantity > 0) {
            int stackSize = Math.min(maxStackSize, quantity);
            ItemStack stack = item.func_77946_l();
            stack.func_190920_e(stackSize);
            list.add(stack);
            quantity -= maxStackSize;
        }
    }

    @Override
    public void addOtherDropStacksToList(List<ItemStack> list, World world, BlockPos pos, IBlockState state) {
        ComposerCellTileEntity te = (ComposerCellTileEntity)world.func_175625_s(pos);
        if (te.storedItem == null) {
            return;
        }
        this.addItemStackToList(te.storedItem, list, te.storedQuantity);
    }

    @Override
    protected void onWailaTooltipHeader(List<String> currentTooltip, IBlockState blockState, ComposerCellTileEntity te, EntityPlayer player) {
        if (te.storedQuantity == 0) {
            currentTooltip.add(Translation.localize("waila.soulus:composer_cell.no_items", new Object[0]));
            return;
        }
        currentTooltip.add(new Translation("waila.soulus:composer_cell.contained_item", new Object[0]).addArgs(te.storedQuantity, ComposerCell.CONFIG.maxQuantity, te.storedItem.func_82833_r()).get(new Object[0]));
        ItemStack storedItem = te.getStoredItem();
        if (!player.func_70093_af() && storedItem != null && storedItem.func_77973_b() instanceof IHasComposerCellInfo) {
            ((IHasComposerCellInfo)storedItem.func_77973_b()).addComposerCellInfo(currentTooltip, storedItem, te.storedQuantity);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected List<String> onWailaTooltipMore(IBlockState blockState, ComposerCellTileEntity te, EntityPlayer player) {
        ItemStack storedItem = te.getStoredItem();
        if (storedItem != null) {
            return storedItem.func_82840_a(player, (ITooltipFlag)ITooltipFlag.TooltipFlags.ADVANCED);
        }
        return null;
    }

    static {
        CELL_STATE = PropertyEnum.func_177709_a((String)"cell_state", CellState.class);
    }

    public static interface IHasComposerCellInfo {
        public void addComposerCellInfo(List<String> var1, ItemStack var2, int var3);
    }

    public static enum CellState implements IStringSerializable
    {
        DISCONNECTED("disconnected"),
        CONNECTED_CENTER("connected_center"),
        CONNECTED_EDGE("connected_edge");

        public String name;

        private CellState(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static CellState fromMeta(int meta) {
            return CellState.values()[meta];
        }

        public int getMeta() {
            for (int i = 0; i < CellState.values().length; ++i) {
                if (!CellState.values()[i].equals((Object)this)) continue;
                return i;
            }
            throw new RuntimeException("Can't find own index");
        }
    }
}

