/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.composer;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import yuudaari.soulus.common.block.composer.ComposerCell;
import yuudaari.soulus.common.block.composer.ComposerCellTileEntity;
import yuudaari.soulus.common.block.composer.ComposerTileEntity;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlock;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigComposer;
import yuudaari.soulus.common.item.OrbMurky;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.util.Material;
import yuudaari.soulus.common.util.StructureMap;
import yuudaari.soulus.common.util.Translation;

@ConfigInjected(value="soulus")
public class Composer
extends UpgradeableBlock<ComposerTileEntity> {
    @ConfigInjected.Inject
    public static ConfigComposer CONFIG;
    public static final PropertyDirection FACING;
    public static final PropertyBool CONNECTED;
    public StructureMap structure = new StructureMap();

    @Override
    public UpgradeableBlock.IUpgrade[] getUpgrades() {
        return Upgrade.values();
    }

    public Composer() {
        super("composer", new Material(MapColor.field_151661_c).setTransparent());
        StructureMap.BlockValidator bars = StructureMap.BlockValidator.byBlock(new Block[]{BlockRegistry.BARS_ENDERSTEEL});
        StructureMap.BlockValidator cell = (pos, world, checkPos, state) -> {
            if (state.func_177230_c() != BlockRegistry.COMPOSER_CELL) {
                return false;
            }
            ComposerCellTileEntity te = (ComposerCellTileEntity)world.func_175625_s(checkPos);
            boolean result = te == null || te.composerLocation == null && te.changeComposerCooldown < 0 || pos.equals((Object)te.composerLocation);
            return result;
        };
        StructureMap.BlockValidator obsidian = StructureMap.BlockValidator.byBlock(Blocks.field_150343_Z);
        StructureMap.BlockValidator endersteel = StructureMap.BlockValidator.byBlock(BlockRegistry.BLOCK_ENDERSTEEL);
        this.structure.addBlock(-2, 0, -5, obsidian);
        this.structure.addRowX(-1, 0, -5, 3, bars);
        this.structure.addBlock(2, 0, -5, obsidian);
        this.structure.addBlock(-2, 0, -4, bars);
        this.structure.addRowX(-1, 0, -4, 3, cell);
        this.structure.addBlock(2, 0, -4, bars);
        this.structure.addBlock(-2, 0, -3, bars);
        this.structure.addRowX(-1, 0, -3, 3, cell);
        this.structure.addBlock(2, 0, -3, bars);
        this.structure.addBlock(-2, 0, -2, bars);
        this.structure.addRowX(-1, 0, -2, 3, cell);
        this.structure.addBlock(2, 0, -2, bars);
        this.structure.addBlock(-2, 0, -1, obsidian);
        this.structure.addRowX(-1, 0, -1, 3, bars);
        this.structure.addBlock(2, 0, -1, obsidian);
        this.structure.addBlock(-2, 1, -5, obsidian);
        this.structure.addBlock(-1, 1, -5, bars);
        this.structure.addBlock(1, 1, -5, bars);
        this.structure.addBlock(2, 1, -5, obsidian);
        this.structure.addBlock(-2, 1, -4, bars);
        this.structure.addBlock(2, 1, -4, bars);
        this.structure.addBlock(-2, 1, -2, bars);
        this.structure.addBlock(2, 1, -2, bars);
        this.structure.addBlock(-2, 1, -1, obsidian);
        this.structure.addBlock(-1, 1, -1, bars);
        this.structure.addBlock(1, 1, -1, bars);
        this.structure.addBlock(2, 1, -1, obsidian);
        this.structure.addBlock(-2, 2, -5, endersteel);
        this.structure.addBlock(2, 2, -5, endersteel);
        this.structure.addBlock(-2, 2, -1, endersteel);
        this.structure.addBlock(2, 2, -1, endersteel);
        this.setHasItem();
        this.func_149711_c(5.0f);
        this.func_149752_b(30.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149649_H();
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(false)));
        this.setHasDescription();
    }

    @Override
    public UpgradeableBlock<ComposerTileEntity> getInstance() {
        return BlockRegistry.COMPOSER;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)CONNECTED)).booleanValue()) {
            return false;
        }
        return super.rotateBlock(world, pos, axis);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        face = this.rotateFace((EnumFacing)state.func_177229_b((IProperty)FACING), face);
        return Arrays.asList(EnumFacing.field_176754_o).contains(face) ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public EnumFacing rotateFace(EnumFacing rotateFace, EnumFacing face) {
        if (rotateFace == EnumFacing.SOUTH) {
            return face.func_176734_d();
        }
        if (rotateFace == EnumFacing.EAST) {
            return face == EnumFacing.UP || face == EnumFacing.DOWN ? face : face.func_176746_e();
        }
        if (rotateFace == EnumFacing.WEST) {
            return face == EnumFacing.UP || face == EnumFacing.DOWN ? face : face.func_176735_f();
        }
        if (rotateFace == EnumFacing.UP) {
            return face.func_176732_a(EnumFacing.Axis.X);
        }
        if (rotateFace == EnumFacing.DOWN) {
            return face.func_176732_a(EnumFacing.Axis.X).func_176734_d();
        }
        return face;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        ComposerTileEntity te = (ComposerTileEntity)world.func_175625_s(pos);
        if (te == null) {
            return;
        }
        if (placer instanceof EntityPlayer) {
            te.setOwner((EntityPlayer)placer);
        }
    }

    @Override
    public void onBlockDestroy(World world, BlockPos pos, int fortune, EntityPlayer player) {
        super.onBlockDestroy(world, pos, fortune, player);
        IBlockState state = world.func_180495_p(pos);
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED)).booleanValue()) {
            this.structure.loopBlocks(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), (pos2, validator) -> {
                IBlockState currentState = world.func_180495_p(pos2);
                if (currentState.func_177230_c() == BlockRegistry.COMPOSER_CELL) {
                    world.func_180501_a(pos2, currentState.func_177226_a(ComposerCell.CELL_STATE, (Comparable)((Object)ComposerCell.CellState.DISCONNECTED)), 3);
                    ComposerCellTileEntity ccte = (ComposerCellTileEntity)world.func_175625_s(pos2);
                    ccte.composerLocation = null;
                    ccte.blockUpdate();
                }
                return null;
            });
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        ComposerTileEntity te = (ComposerTileEntity)world.func_175625_s(pos);
        return te.getSignalStrength();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, CONNECTED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf((meta & 1) != 0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta / 2)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() * 2 + ((Boolean)state.func_177229_b((IProperty)CONNECTED) != false ? 1 : 0);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing defaultDirection = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer);
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)defaultDirection);
        EnumFacing direction = this.validateStructure(world, pos, defaultDirection);
        if (direction != null && state.func_177229_b((IProperty)FACING) != direction) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)direction);
        }
        return state;
    }

    public EnumFacing validateStructure(World world, BlockPos pos, EnumFacing currentDirection) {
        boolean checkCurrentDirection;
        boolean bl = checkCurrentDirection = currentDirection != EnumFacing.DOWN && currentDirection != EnumFacing.UP;
        if (checkCurrentDirection && this.structure.isValid(world, pos, currentDirection)) {
            return currentDirection;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (checkCurrentDirection && facing == currentDirection || !this.structure.isValid(world, pos, facing)) continue;
            return facing;
        }
        return null;
    }

    @Override
    public boolean hasTileEntity(IBlockState blockState) {
        return true;
    }

    @Override
    public Class<? extends UpgradeableBlockTileEntity> getTileEntityClass() {
        return ComposerTileEntity.class;
    }

    @Override
    protected void onWailaTooltipHeader(List<String> tooltip, IBlockState blockState, ComposerTileEntity te, EntityPlayer player) {
        if (te.hasValidRecipe()) {
            tooltip.add(new Translation("waila.soulus:composer.craft_percentage", new Object[0]).get((int)Math.floor(te.getCompositionPercent() * 100.0f)));
            tooltip.add(new Translation("waila.soulus:composer.activation", new Object[0]).get((int)Math.floor(te.getActivationAmount())));
            if (te.hasValidRecipe() && te.remainingMobs.size() > 0) {
                tooltip.add(Translation.localize("waila.soulus:composer.required_creatures", new Object[0]));
                te.remainingMobs.entrySet().stream().map(requiredMob -> new Translation("waila.soulus:composer.required_creature", new Object[0]).get(Translation.localizeEntity((String)requiredMob.getKey()), requiredMob.getValue())).forEach(tooltip::add);
            }
        } else {
            tooltip.add(Translation.localize("waila.soulus:composer.no_recipe", new Object[0]));
        }
    }

    static {
        FACING = PropertyDirection.func_177714_a((String)"facing");
        CONNECTED = PropertyBool.func_177716_a((String)"connected");
    }

    public static enum Upgrade implements UpgradeableBlock.IUpgrade
    {
        RANGE(0, "range", ItemRegistry.ORB_MURKY.getItemStack()),
        DELAY(1, "delay", ItemRegistry.GEAR_OSCILLATING.getItemStack()),
        EFFICIENCY(2, "efficiency", ItemRegistry.GEAR_NIOBIUM.getItemStack());

        private final int index;
        private final String name;
        private final ItemStack stack;
        private Integer maxQuantity;

        private Upgrade(int index, String name, ItemStack item) {
            this.index = index;
            this.name = name;
            this.stack = item;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getMaxQuantity() {
            if (this.maxQuantity == null) {
                return 16;
            }
            return this.maxQuantity;
        }

        @Override
        public void setMaxQuantity(int quantity) {
            this.maxQuantity = quantity;
        }

        @Override
        public boolean isItemStack(ItemStack stack) {
            if (stack.func_77973_b() != this.stack.func_77973_b()) {
                return false;
            }
            if (this.name == "range") {
                return OrbMurky.isFilled(stack);
            }
            return true;
        }

        @Override
        public ItemStack getItemStack(int quantity) {
            ItemStack stack = new ItemStack(this.stack.func_77973_b(), quantity);
            if (this.name == "range") {
                OrbMurky.setFilled(stack);
            }
            return stack;
        }
    }
}

