/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.advancement;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import scala.Tuple3;
import yuudaari.soulus.common.advancement.BasicTrigger;
import yuudaari.soulus.common.advancement.MatchableCriterionInstance;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlock;

public class UpgradeTrigger
extends BasicTrigger<Instance, Tuple3<UpgradeableBlock<?>, UpgradeableBlock.IUpgrade, Boolean>> {
    private static final ResourceLocation ID = new ResourceLocation("soulus", "upgrade");

    public ResourceLocation func_192163_a() {
        return ID;
    }

    @Override
    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        String upgrade;
        Block block = null;
        if (!json.has("block")) {
            throw new JsonSyntaxException("Upgrade trigger requires block type");
        }
        ResourceLocation id = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"block"));
        if (!Block.field_149771_c.func_148741_d((Object)id)) {
            throw new JsonSyntaxException("Unknown block type '" + id + "'");
        }
        block = (Block)Block.field_149771_c.func_82594_a((Object)id);
        if (!(block instanceof UpgradeableBlock)) {
            throw new JsonSyntaxException("Invalid block type '" + id + "', must be an UpgradeableBlock");
        }
        UpgradeableBlock ublock = (UpgradeableBlock)block;
        boolean filled = false;
        if (json.has("upgrade")) {
            boolean isValidUpgrade;
            upgrade = JsonUtils.func_151200_h((JsonObject)json, (String)"upgrade");
            boolean bl = isValidUpgrade = upgrade.equals("*") || Arrays.asList(ublock.getUpgrades()).stream().anyMatch(u -> u.getName().equalsIgnoreCase(upgrade));
            if (!isValidUpgrade) {
                throw new JsonSyntaxException("Invalid upgrade type '" + upgrade + "'");
            }
            if (json.has("filled")) {
                filled = JsonUtils.func_151212_i((JsonObject)json, (String)"filled");
            }
        } else {
            upgrade = "*";
        }
        return new Instance(ublock, upgrade, filled);
    }

    public static class Instance
    extends MatchableCriterionInstance<Tuple3<UpgradeableBlock<?>, UpgradeableBlock.IUpgrade, Boolean>> {
        private final UpgradeableBlock<?> block;
        private final String upgrade;
        private final boolean filled;

        public Instance(UpgradeableBlock<?> block, String upgrade, boolean filled) {
            super(ID);
            this.block = block;
            this.upgrade = upgrade;
            this.filled = filled;
        }

        @Override
        public boolean matches(EntityPlayerMP player, Tuple3<UpgradeableBlock<?>, UpgradeableBlock.IUpgrade, Boolean> upgradeInfo) {
            return !(!((UpgradeableBlock)upgradeInfo._1()).equals(this.block) || !this.upgrade.equals("*") && !((UpgradeableBlock.IUpgrade)upgradeInfo._2()).getName().equalsIgnoreCase(this.upgrade) || this.filled && (Boolean)upgradeInfo._3() == false);
        }
    }
}

