/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.client.exporter.exports;

import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import yuudaari.soulus.common.registration.Registration;
import yuudaari.soulus.common.util.Translation;
import yuudaari.soulus.common.util.serializer.CollectionSerializer;
import yuudaari.soulus.common.util.serializer.Serializable;
import yuudaari.soulus.common.util.serializer.Serialized;

@Serializable
public class ItemExport {
    @Serialized
    public final String registryName;
    @Serialized
    public final boolean isBlock;
    @Serialized
    public final String description;
    @Serialized(value=StackListSerializer.class)
    public final List<StackExport> stacks;

    public ItemExport(Item item, List<StackExport> stacks) {
        this.registryName = item.getRegistryName().toString();
        this.isBlock = item instanceof ItemBlock;
        this.stacks = stacks;
        String registryName = null;
        if (item instanceof Registration.Item) {
            registryName = ((Registration.Item)item).getDescriptionRegistryName();
        }
        this.description = Translation.localize("jei.description." + (registryName == null ? this.registryName : registryName), new Object[0]);
    }

    public static class StackListSerializer
    extends CollectionSerializer<StackExport> {
        @Override
        public Class<StackExport> getValueClass() {
            return StackExport.class;
        }
    }

    @Serializable
    public static class StackExport {
        @Serialized
        public final String image;
        @Serialized
        public final String displayName;
        @Serialized
        public final String nbt;
        @Serialized
        public final int data;

        public StackExport(String image, ItemStack stack) {
            this.image = image;
            this.displayName = stack.func_82833_r();
            this.data = stack.func_77960_j();
            this.nbt = stack.func_77942_o() ? stack.func_77978_p().toString() : "";
        }
    }
}

