/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.cache;

import java.util.Random;

public class SpatialNoise {
    private final long seed1;
    protected final long seed2;

    public SpatialNoise() {
        long theSeed;
        this.seed1 = theSeed = System.nanoTime();
        this.seed2 = new Random(this.seed1).nextLong();
    }

    public SpatialNoise(long theSeed) {
        this.seed1 = theSeed;
        this.seed2 = new Random(this.seed1).nextLong();
    }

    public SpatialNoise(long theSeed, long altSeed) {
        this.seed1 = theSeed;
        this.seed2 = altSeed;
    }

    public int hashCode() {
        return (int)this.seed1;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpatialNoise other = (SpatialNoise)obj;
        return this.seed1 == other.seed1;
    }

    protected long getSeed() {
        return this.seed1;
    }

    public boolean booleanFor(int x, int z, int t) {
        return (this.longFor(x, z, t) & 1L) == 1L;
    }

    public float floatFor(int x, int z, int t) {
        return (float)(this.longFor(x, z, t) & Integer.MAX_VALUE) / 9.223372E18f;
    }

    public double doubleFor(int x, int z, int t) {
        return (double)(this.longFor(x, z, t) & Long.MAX_VALUE) / 9.223372036854776E18;
    }

    public int intFor(int x, int z, int t) {
        return (int)(this.longFor(x, z, t) & Integer.MAX_VALUE);
    }

    public long longFor(int x, int z, int t) {
        long out = this.seed1 + 15485077L * (long)t + 12338621L * (long)x + 14416417L * (long)z;
        long alt = this.seed2 + 179424743L * (long)t + 179426003L * (long)x + 179425819L * (long)z;
        alt ^= SpatialNoise.rotateLeft(alt, x % 29 + 13);
        alt ^= SpatialNoise.rotateRight(alt, z % 31 + 7);
        alt ^= SpatialNoise.rotateLeft(alt, t % 23 + 19);
        out ^= SpatialNoise.rotateLeft(out, (x & Integer.MAX_VALUE) % 13 + 5);
        out ^= SpatialNoise.rotateRight(out, (z & Integer.MAX_VALUE) % 11 + 28);
        out ^= SpatialNoise.rotateLeft(out, (t & 0x7FFFFFF) % 17 + 45);
        return out ^ alt;
    }

    private static long rotateLeft(long in, int dist) {
        return in << dist | in >>> 64 - dist;
    }

    private static long rotateRight(long in, int dist) {
        return in >>> dist | in << 64 - dist;
    }

    public Random getRandom(int x, int z, int t) {
        return new Random(this.longFor(x, z, t));
    }

    public RandomAt getRandomAt(int x, int z, int t) {
        return new RandomAt(this, x, z, t);
    }

    public static int absModulus(int in, int bound) {
        if (in < 0) {
            return -(in % bound);
        }
        return in % bound;
    }

    public static class RandomAt
    extends SpatialNoise {
        private long nextSeed;
        private final int x1;
        private final int x2;
        private final int z1;
        private final int z2;
        private final int t1;
        private final int t2;
        private final long addative1;
        private final long addative2;

        public RandomAt(long seed1, long seed2, int x, int z, int t) {
            super(seed1, seed2);
            this.nextSeed = super.getSeed();
            this.addative1 = 15485077L * (long)t + 12338621L * (long)x + 14416417L * (long)z + 32452841L;
            this.addative2 = seed2 + 179424743L * (long)t + 179426003L * (long)x + 179425819L * (long)z;
            this.x1 = (x & Integer.MAX_VALUE) % 29 + 13;
            this.z1 = (z & Integer.MAX_VALUE) % 31 + 7;
            this.t1 = (t & Integer.MAX_VALUE) % 23 + 19;
            this.x2 = x % 13 + 5;
            this.z2 = z % 11 + 28;
            this.t2 = t % 17 + 45;
        }

        public RandomAt(SpatialNoise from, int x, int z, int t) {
            super(from.seed1, from.seed2);
            this.nextSeed = from.getSeed();
            this.addative1 = 15485077L * (long)t + 12338621L * (long)x + 14416417L * (long)z + 32452841L;
            this.addative2 = this.seed2 + 179424743L * (long)t + 179426003L * (long)x + 179425819L * (long)z;
            this.x1 = (x & 0xFFFFFFF) % 29 + 13;
            this.z1 = (z & 0xFFFFFFF) % 31 + 7;
            this.t1 = (t & 0xFFFFFFF) % 23 + 19;
            this.x2 = x % 13 + 5;
            this.z2 = z % 11 + 28;
            this.t2 = t % 17 + 45;
        }

        public long nextLong() {
            this.nextSeed += this.addative1;
            long alt = this.seed2 + this.addative2;
            alt ^= SpatialNoise.rotateLeft(this.seed2, this.x2);
            alt ^= SpatialNoise.rotateRight(alt, this.z2);
            alt ^= SpatialNoise.rotateLeft(alt, this.t2);
            this.nextSeed ^= SpatialNoise.rotateLeft(this.nextSeed, this.x1);
            this.nextSeed ^= SpatialNoise.rotateLeft(this.nextSeed, this.z1);
            this.nextSeed ^= SpatialNoise.rotateRight(this.nextSeed, this.t1);
            this.nextSeed += alt;
            return this.nextSeed;
        }

        public int nextInt() {
            return (int)this.nextLong();
        }

        public int nextInt(int bound) {
            return ((int)this.nextLong() & Integer.MAX_VALUE) % bound;
        }

        public boolean nextBoolean() {
            return (this.nextLong() & 1L) == 1L;
        }

        public float nextFloat() {
            return (float)(this.nextLong() & Long.MAX_VALUE) / 9.223372E18f;
        }

        public double nextDouble() {
            return (double)(this.nextLong() & Long.MAX_VALUE) / 9.223372036854776E18;
        }
    }
}

