/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.container;

import com.creativemd.creativecore.common.event.CreativeCoreEventBus;
import com.creativemd.creativecore.common.gui.ContainerControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.mc.GuiContainerSub;
import com.creativemd.creativecore.common.gui.premade.SubGuiDialog;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.packet.gui.GuiLayerPacket;
import com.creativemd.creativecore.common.packet.gui.GuiUpdatePacket;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class SubGui
extends GuiParent {
    public SubContainer container;
    public GuiContainerSub gui;
    private CreativeCoreEventBus eventBus = new CreativeCoreEventBus(true);

    public SubGui() {
        this(176, 166);
    }

    public SubGui(int width, int height) {
        this("gui", width, height);
    }

    public SubGui(String name, int width, int height) {
        super(name, 0, 0, width, height);
        this.eventBus.RegisterEventListener(this);
    }

    public boolean isTopLayer() {
        return this.gui.isTopLayer(this);
    }

    public int getLayerID() {
        return this.gui.getLayers().indexOf(this);
    }

    public void openNewLayer(NBTTagCompound nbt) {
        this.openNewLayer(nbt, false);
    }

    public void openNewLayer(NBTTagCompound nbt, boolean isPacket) {
        this.gui.addLayer(this.createLayer((World)SubGui.mc.field_71441_e, (EntityPlayer)SubGui.mc.field_71439_g, nbt));
        if (!isPacket) {
            PacketHandler.sendPacketToServer(new GuiLayerPacket(nbt, this.getLayerID(), false));
        }
    }

    public void closeLayer(NBTTagCompound nbt) {
        this.closeLayer(nbt, false);
    }

    public void closeLayer(NBTTagCompound nbt, boolean isPacket) {
        this.onClosed();
        if (!isPacket) {
            PacketHandler.sendPacketToServer(new GuiLayerPacket(nbt, this.getLayerID(), true));
        }
        this.gui.removeLayer(this);
        if (this.gui.hasTopLayer()) {
            this.gui.getTopLayer().onLayerClosed(this, nbt);
        }
    }

    public void onLayerClosed(SubGui gui, NBTTagCompound nbt) {
        if (nbt.func_74767_n("dialog")) {
            String[] buttons = new String[nbt.func_74762_e("count")];
            for (int i = 0; i < buttons.length; ++i) {
                buttons[i] = nbt.func_74779_i("b" + i);
            }
            this.onDialogClosed(nbt.func_74779_i("text"), buttons, nbt.func_74779_i("clicked"));
        }
    }

    public void closeGui() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("exit", true);
        this.closeLayer(nbt);
        if (this.gui.getLayers().size() == 0) {
            SubGui.mc.field_71439_g.func_71053_j();
        }
    }

    public SubGui createLayer(World world, EntityPlayer player, NBTTagCompound nbt) {
        SubGui layer = this.createLayerFromPacket(world, player, nbt);
        layer.container = this.container.createLayerFromPacket(world, player, nbt);
        layer.gui = this.gui;
        layer.onOpened();
        return layer;
    }

    public SubGui createLayerFromPacket(World world, EntityPlayer player, NBTTagCompound nbt) {
        if (nbt.func_74767_n("dialog")) {
            String[] buttons = new String[nbt.func_74762_e("count")];
            for (int i = 0; i < buttons.length; ++i) {
                buttons[i] = nbt.func_74779_i("b" + i);
            }
            return new SubGuiDialog(nbt.func_74779_i("text").split("\n"), buttons);
        }
        return null;
    }

    public void openYesNoDialog(String text) {
        this.openButtonDialogDialog(text, "Yes", "No");
    }

    public void openButtonDialogDialog(String text, String ... buttons) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("dialog", true);
        nbt.func_74778_a("text", text);
        nbt.func_74768_a("count", buttons.length);
        for (int i = 0; i < buttons.length; ++i) {
            nbt.func_74778_a("b" + i, buttons[i]);
        }
        this.openNewLayer(nbt);
    }

    public void openSaveDialog(String text) {
        this.openButtonDialogDialog(text, "Yes", "No", "Cancel");
    }

    public void onDialogClosed(String text, String[] buttons, String clicked) {
    }

    @Override
    public boolean isInteractable() {
        return super.isInteractable() && this.isTopLayer();
    }

    public boolean closeGuiUsingEscape() {
        return true;
    }

    @Override
    public boolean onKeyPressed(char character, int key) {
        if (key == 1) {
            if (this.closeGuiUsingEscape()) {
                this.closeGui();
            }
            return true;
        }
        if (super.onKeyPressed(character, key)) {
            return true;
        }
        if (key == SubGui.mc.field_71474_y.field_151445_Q.func_151463_i()) {
            this.closeGui();
            return true;
        }
        return false;
    }

    @Override
    public int getPixelOffsetX() {
        return this.gui.getGuiLeft() + this.getContentOffset();
    }

    @Override
    public int getPixelOffsetY() {
        return this.gui.getGuiTop() + this.getContentOffset();
    }

    public void receiveContainerPacket(NBTTagCompound nbt) {
    }

    public void sendPacketToServer(NBTTagCompound nbt) {
        PacketHandler.sendPacketToServer(new GuiUpdatePacket(nbt, false, this.getLayerID()));
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.container.player;
    }

    public abstract void createControls();

    @Override
    protected void renderBackground(GuiRenderHelper helper, Style style) {
        style.getBorder(this).renderStyle(helper, this.width, this.height);
        GlStateManager.func_179109_b((float)this.borderWidth, (float)this.borderWidth, (float)0.0f);
        style.getFace(this).renderStyle(helper, this.width - this.borderWidth * 2, this.height - this.borderWidth * 2);
    }

    @Override
    public boolean isMouseOver() {
        if (this.parent != null) {
            return super.isMouseOver();
        }
        return this.isTopLayer();
    }

    public boolean hasGrayBackground() {
        return true;
    }

    @Override
    public void onTick() {
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.eventBus.removeAllEventListeners();
    }

    public void addContainerControls() {
        for (int i = 0; i < this.container.controls.size(); ++i) {
            ((ContainerControl)this.container.controls.get(i)).onOpened();
            this.controls.add(((ContainerControl)this.container.controls.get(i)).getGuiControl());
        }
    }

    @Override
    public void onOpened() {
        this.createControls();
        for (int i = 0; i < this.controls.size(); ++i) {
            ((GuiControl)this.controls.get((int)i)).parent = this;
            ((GuiControl)this.controls.get(i)).onOpened();
        }
        if (this.container != null) {
            this.addContainerControls();
        }
        this.refreshControls();
    }

    @Override
    public boolean raiseEvent(ControlEvent event) {
        return !this.eventBus.raiseEvent(event);
    }

    @Override
    public void addListener(Object listener) {
        this.eventBus.RegisterEventListener(listener);
    }

    @Override
    public void removeListener(Object listener) {
        this.eventBus.removeEventListener(listener);
    }
}

