/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.container;

import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.Rect;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.IControlParent;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiFocusControl;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiToolTipEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiParent
extends GuiControl
implements IControlParent {
    public ArrayList<GuiControl> controls = new ArrayList();
    protected int lastRenderedHeight = 0;

    public GuiParent(String name, int x, int y, int width, int height) {
        super(name, x, y, width, height);
    }

    @Override
    public List getControls() {
        return this.controls;
    }

    @Override
    public void refreshControls() {
        for (int i = 0; i < this.controls.size(); ++i) {
            this.updateControl(this.controls.get(i), i);
        }
    }

    public void updateControl(GuiControl control, int id) {
        control.parent = this;
        control.setID(id);
    }

    public void addControl(GuiControl control) {
        this.updateControl(control, this.controls.size());
        this.controls.add(control);
    }

    public boolean removeControl(GuiControl control) {
        int index = this.controls.indexOf(control);
        if (index != -1) {
            this.controls.remove(index);
            for (int i = index; i < this.controls.size(); ++i) {
                this.updateControl(control, i);
            }
            return true;
        }
        return false;
    }

    public SubGui getOrigin() {
        if (this.parent instanceof SubGui) {
            return (SubGui)this.parent;
        }
        if (this.parent != null) {
            return ((GuiParent)this.parent).getOrigin();
        }
        return null;
    }

    public float getScaleFactor() {
        return 1.0f;
    }

    protected double getOffsetY() {
        return 0.0;
    }

    protected double getOffsetX() {
        return 0.0;
    }

    @Override
    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
    }

    @Override
    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height, Rect relativeMaximumRect) {
        GlStateManager.func_179086_m((int)256);
        float scale = this.getScaleFactor();
        double xOffset = this.getOffsetX();
        double yOffset = this.getOffsetY();
        Rect newRect = relativeMaximumRect.mergeRects(this.getRect());
        this.lastRenderedHeight = 0;
        for (int i = this.controls.size() - 1; i >= 0; --i) {
            GuiControl control = this.controls.get(i);
            if (control.visible && control.isVisibleInsideRect((int)(-xOffset), (int)(-yOffset), width, height, scale)) {
                if (control.canOverlap()) {
                    GL11.glDisable((int)2960);
                } else {
                    GL11.glEnable((int)2960);
                    this.prepareContentStencil(helper, relativeMaximumRect);
                    GL11.glStencilOp((int)7680, (int)7680, (int)7680);
                    GL11.glStencilFunc((int)514, (int)1, (int)1);
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)xOffset, (double)yOffset, (double)0.0);
                control.renderControl(helper, scale, newRect.getOffsetRect((int)xOffset, (int)yOffset));
                GlStateManager.func_179121_F();
                if (!control.canOverlap()) {
                    GL11.glDisable((int)2960);
                }
            }
            this.lastRenderedHeight = (int)Math.max((float)this.lastRenderedHeight, (float)(control.posY + control.height) * scale);
        }
        GL11.glEnable((int)2960);
        this.prepareContentStencil(helper, relativeMaximumRect);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glStencilFunc((int)514, (int)1, (int)1);
        this.renderContent(helper, style, width, height);
        GL11.glDisable((int)2960);
    }

    @Override
    public CoreControl get(String name) {
        for (int i = 0; i < this.controls.size(); ++i) {
            CoreControl tempcontrol;
            GuiControl control = this.controls.get(i);
            if (control.is(name)) {
                return control;
            }
            if (!(control instanceof IControlParent) || (tempcontrol = ((IControlParent)((Object)control)).get(name)) == null) continue;
            return tempcontrol;
        }
        return null;
    }

    @Override
    public boolean has(String name) {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!control.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMouseOver() {
        if (this.parent != null) {
            return super.isMouseOver();
        }
        return true;
    }

    @Override
    public Vec3d getMousePos() {
        if (this.parent != null) {
            return this.getParent().getMousePos().func_72441_c((double)(-this.getContentOffset()) - this.getOffsetX() - (double)this.posX, (double)(-this.getContentOffset()) - this.getOffsetY() - (double)this.posY, 0.0);
        }
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        int x = Mouse.getX() * i / GuiParent.mc.field_71443_c;
        int y = j - Mouse.getY() * j / GuiParent.mc.field_71440_d - 1;
        int movex = (i - this.width) / 2;
        int movey = (j - this.height) / 2;
        return new Vec3d((double)((x -= movex) - this.getContentOffset()) - this.getOffsetX(), (double)((y -= movey) - this.getContentOffset()) - this.getOffsetY(), 0.0);
    }

    public boolean isAnyControlFocused() {
        return this.getFocusedControl() != null;
    }

    public GuiControl getFocusedControl() {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!(control instanceof GuiFocusControl) || !((GuiFocusControl)control).focused) continue;
            return control;
        }
        if (this.getParent() != null) {
            return this.getParent().getFocusedControl();
        }
        return null;
    }

    @Override
    public void onOpened() {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            control.parent = this;
            control.onOpened();
        }
        this.refreshControls();
    }

    @Override
    public void onClosed() {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            control.onClosed();
        }
    }

    @Override
    public void onTick() {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            control.onTick();
        }
    }

    @Override
    public void onLoseFocus() {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            control.onLoseFocus();
        }
    }

    @Override
    public boolean mouseScrolled(int x, int y, int scrolled) {
        Vec3d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            Vec3d pos = control.rotateMouseVec(mouse);
            if (!control.isInteractable() || !control.isMouseOver((int)pos.field_72450_a, (int)pos.field_72448_b) || !control.mouseScrolled((int)pos.field_72450_a, (int)pos.field_72448_b, scrolled)) continue;
            return true;
        }
        return false;
    }

    protected void clickControl(GuiControl control, int x, int y, int button) {
        this.raiseEvent(new GuiControlClickEvent(control, x, y, button));
    }

    @Override
    public boolean mousePressed(int x, int y, int button) {
        boolean result = false;
        Vec3d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            Vec3d pos = control.rotateMouseVec(mouse);
            if (!result && control.isInteractable() && control.isMouseOver((int)pos.field_72450_a, (int)pos.field_72448_b) && control.mousePressed((int)pos.field_72450_a, (int)pos.field_72448_b, button)) {
                this.clickControl(control, x, y, button);
                result = true;
                continue;
            }
            control.onLoseFocus();
        }
        return result;
    }

    @Override
    public void mouseMove(int x, int y, int button) {
        Vec3d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            Vec3d pos = control.rotateMouseVec(mouse);
            if (!control.isInteractable()) continue;
            control.mouseMove((int)pos.field_72450_a, (int)pos.field_72448_b, button);
        }
    }

    @Override
    public void mouseDragged(int x, int y, int button, long time) {
        Vec3d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            Vec3d pos = control.rotateMouseVec(mouse);
            if (!control.isInteractable()) continue;
            control.mouseDragged((int)pos.field_72450_a, (int)pos.field_72448_b, button, time);
        }
    }

    @Override
    public void mouseReleased(int x, int y, int button) {
        Vec3d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            Vec3d pos = control.rotateMouseVec(mouse);
            if (!control.isInteractable()) continue;
            control.mouseReleased((int)pos.field_72450_a, (int)pos.field_72448_b, button);
        }
    }

    @Override
    public boolean onKeyPressed(char character, int key) {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!control.isInteractable() || !control.onKeyPressed(character, key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GuiToolTipEvent getToolTipEvent() {
        GuiToolTipEvent event = super.getToolTipEvent();
        if (event != null) {
            return event;
        }
        Vec3d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            Vec3d pos = control.rotateMouseVec(mouse);
            if (!control.isInteractable() || !control.isMouseOver((int)pos.field_72450_a, (int)pos.field_72448_b) || (event = control.getToolTipEvent()) == null) continue;
            return event;
        }
        return null;
    }
}

