/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.animation;

import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.common.structure.type.LittleAdvancedDoor;
import com.creativemd.littletiles.common.utils.animation.Animation;
import com.creativemd.littletiles.common.utils.animation.AnimationState;

public class TimestampAnimation
extends Animation {
    public PairList<Integer, Double> offX;
    public PairList<Integer, Double> offY;
    public PairList<Integer, Double> offZ;
    public PairList<Integer, Double> rotX;
    public PairList<Integer, Double> rotY;
    public PairList<Integer, Double> rotZ;

    public TimestampAnimation(long duration, PairList<Integer, Double> offX, PairList<Integer, Double> offY, PairList<Integer, Double> offZ, PairList<Integer, Double> rotX, PairList<Integer, Double> rotY, PairList<Integer, Double> rotZ) {
        super(duration);
        this.offX = offX;
        this.offY = offY;
        this.offZ = offZ;
        this.rotX = rotX;
        this.rotY = rotY;
        this.rotZ = rotZ;
    }

    public TimestampAnimation(int[] array) {
        super((long)array[0] << 32 | (long)array[1] & 0xFFFFFFFFL);
        int index = 2;
        for (int step = 0; step < 6; ++step) {
            int size = array[index];
            ++index;
            if (size != 0) {
                PairList<Integer, Double> list = LittleAdvancedDoor.loadPairListDouble(array, index, size);
                switch (step) {
                    case 0: {
                        this.offX = list;
                        break;
                    }
                    case 1: {
                        this.offY = list;
                        break;
                    }
                    case 2: {
                        this.offZ = list;
                        break;
                    }
                    case 3: {
                        this.rotX = list;
                        break;
                    }
                    case 4: {
                        this.rotY = list;
                        break;
                    }
                    case 5: {
                        this.rotZ = list;
                    }
                }
            }
            index += size;
        }
    }

    @Override
    public void tick(AnimationState currentState) {
        if (currentState.offset != null) {
            if (this.offX != null) {
                currentState.offset.x = TimestampAnimation.getValueAt(this.offX, this.tick);
            }
            if (this.offY != null) {
                currentState.offset.y = TimestampAnimation.getValueAt(this.offY, this.tick);
            }
            if (this.offZ != null) {
                currentState.offset.z = TimestampAnimation.getValueAt(this.offZ, this.tick);
            }
        }
        if (currentState.rotation != null) {
            if (this.rotX != null) {
                currentState.rotation.x = TimestampAnimation.getValueAt(this.rotX, this.tick);
            }
            if (this.rotY != null) {
                currentState.rotation.y = TimestampAnimation.getValueAt(this.rotY, this.tick);
            }
            if (this.rotZ != null) {
                currentState.rotation.z = TimestampAnimation.getValueAt(this.rotZ, this.tick);
            }
        }
    }

    @Override
    public void end(AnimationState currentState) {
        this.tick(currentState);
    }

    public static double getValueAt(PairList<Integer, Double> list, long tick) {
        int higher = list.size();
        for (int i = 0; i < list.size(); ++i) {
            int otherTick = (Integer)((Pair)list.get((int)i)).key;
            if ((long)otherTick == tick) {
                return (Double)((Pair)list.get((int)i)).value;
            }
            if ((long)otherTick <= tick) continue;
            higher = i;
            break;
        }
        if (higher == 0 || higher == list.size()) {
            return (Double)((Pair)list.get((int)(higher == 0 ? 0 : list.size() - 1))).value;
        }
        Pair before = (Pair)list.get(higher - 1);
        Pair after = (Pair)list.get(higher);
        double percentage = (double)(tick - (long)((Integer)before.key).intValue()) / (double)((Integer)after.key - (Integer)before.key);
        return ((Double)after.value - (Double)before.value) * percentage + (Double)before.value;
    }

    public int[] getArray() {
        int i;
        int[] offXArray = LittleAdvancedDoor.savePairListDouble(this.offX);
        int[] offYArray = LittleAdvancedDoor.savePairListDouble(this.offY);
        int[] offZArray = LittleAdvancedDoor.savePairListDouble(this.offZ);
        int[] rotXArray = LittleAdvancedDoor.savePairListDouble(this.rotX);
        int[] rotYArray = LittleAdvancedDoor.savePairListDouble(this.rotY);
        int[] rotZArray = LittleAdvancedDoor.savePairListDouble(this.rotZ);
        int[] array = new int[8 + (offXArray != null ? offXArray.length : 0) + (offYArray != null ? offYArray.length : 0) + (offZArray != null ? offZArray.length : 0) + (rotXArray != null ? rotXArray.length : 0) + (rotYArray != null ? rotYArray.length : 0) + (rotZArray != null ? rotZArray.length : 0)];
        array[0] = (int)(this.duration >> 32);
        array[1] = (int)this.duration;
        int index = 2;
        if (offXArray != null) {
            array[index] = offXArray.length;
            for (i = 0; i < offXArray.length; ++i) {
                array[index + 1 + i] = offXArray[i];
            }
            index += offXArray.length;
        } else {
            array[index] = 0;
        }
        ++index;
        if (offYArray != null) {
            array[index] = offYArray.length;
            for (i = 0; i < offYArray.length; ++i) {
                array[index + 1 + i] = offYArray[i];
            }
            index += offYArray.length;
        } else {
            array[index] = 0;
        }
        ++index;
        if (offZArray != null) {
            array[index] = offZArray.length;
            for (i = 0; i < offZArray.length; ++i) {
                array[index + 1 + i] = offZArray[i];
            }
            index += offZArray.length;
        } else {
            array[index] = 0;
        }
        ++index;
        if (rotXArray != null) {
            array[index] = rotXArray.length;
            for (i = 0; i < rotXArray.length; ++i) {
                array[index + 1 + i] = rotXArray[i];
            }
            index += rotXArray.length;
        } else {
            array[index] = 0;
        }
        ++index;
        if (rotYArray != null) {
            array[index] = rotYArray.length;
            for (i = 0; i < rotYArray.length; ++i) {
                array[index + 1 + i] = rotYArray[i];
            }
            index += rotYArray.length;
        } else {
            array[index] = 0;
        }
        ++index;
        if (rotZArray != null) {
            array[index] = rotZArray.length;
            for (i = 0; i < rotZArray.length; ++i) {
                array[index + 1 + i] = rotZArray[i];
            }
            index += rotZArray.length;
        } else {
            array[index] = 0;
        }
        return array;
    }
}

