/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.animation;

import com.creativemd.littletiles.common.utils.animation.transformation.OffsetTransformation;
import com.creativemd.littletiles.common.utils.animation.transformation.RotationTransformation;
import net.minecraft.nbt.NBTTagCompound;

public class AnimationState {
    public final String name;
    public final RotationTransformation rotation;
    public final OffsetTransformation offset;

    public AnimationState(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("name");
        this.rotation = nbt.func_74764_b("rotX") ? new RotationTransformation(nbt.func_74769_h("rotX"), nbt.func_74769_h("rotY"), nbt.func_74769_h("rotZ")) : null;
        this.offset = nbt.func_74764_b("offX") ? new OffsetTransformation(nbt.func_74769_h("offX"), nbt.func_74769_h("offY"), nbt.func_74769_h("offZ")) : null;
    }

    public AnimationState(String name, RotationTransformation rotation, OffsetTransformation offset) {
        this.name = name;
        this.rotation = rotation;
        this.offset = offset;
    }

    public boolean isAligned() {
        return !(this.rotation != null && !this.rotation.isAligned() || this.offset != null && !this.offset.isAligned());
    }

    public AnimationState copy() {
        return new AnimationState(this.name, (RotationTransformation)(this.rotation != null ? this.rotation.copy() : null), (OffsetTransformation)(this.offset != null ? this.offset.copy() : null));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("name", this.name);
        if (this.rotation != null) {
            nbt.func_74780_a("rotX", this.rotation.x);
            nbt.func_74780_a("rotY", this.rotation.y);
            nbt.func_74780_a("rotZ", this.rotation.z);
        }
        if (this.offset != null) {
            nbt.func_74780_a("offX", this.offset.x);
            nbt.func_74780_a("offY", this.offset.y);
            nbt.func_74780_a("offZ", this.offset.z);
        }
        return nbt;
    }
}

