/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.controls.gui.timeline.GuiTimeline;
import com.creativemd.creativecore.common.gui.controls.gui.timeline.KeyControl;
import com.creativemd.creativecore.common.gui.controls.gui.timeline.TimelineChannel;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiToolTipEvent;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.gui.controls.GuiLTDistance;
import com.creativemd.littletiles.common.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.gui.dialogs.SubGuiDialogAxis;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.LTStructureAnnotation;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.structure.type.LittleDoorBase;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.utils.animation.Animation;
import com.creativemd.littletiles.common.utils.animation.AnimationState;
import com.creativemd.littletiles.common.utils.animation.AnimationTimeline;
import com.creativemd.littletiles.common.utils.animation.TimestampAnimation;
import com.creativemd.littletiles.common.utils.animation.transformation.OffsetTransformation;
import com.creativemd.littletiles.common.utils.animation.transformation.RotationTransformation;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleAdvancedDoor
extends LittleDoorBase {
    @LTStructureAnnotation(color=-65536)
    public StructureRelative axisCenter;
    public PairList<Integer, Double> rotX;
    public PairList<Integer, Double> rotY;
    public PairList<Integer, Double> rotZ;
    public LittleGridContext offGrid;
    public PairList<Integer, Integer> offX;
    public PairList<Integer, Integer> offY;
    public PairList<Integer, Integer> offZ;

    public static PairList<Integer, Double> loadPairListDouble(int[] array) {
        PairList list = new PairList();
        for (int i = 0; i < array.length; i += 3) {
            list.add((Object)array[i], (Object)Double.longBitsToDouble((long)array[i + 1] << 32 | (long)array[i + 2] & 0xFFFFFFFFL));
        }
        return list;
    }

    public static PairList<Integer, Integer> loadPairListInteger(int[] array) {
        PairList list = new PairList();
        for (int i = 0; i < array.length; i += 2) {
            list.add((Object)array[i], (Object)array[i + 1]);
        }
        return list;
    }

    public static PairList<Integer, Double> loadPairListDouble(int[] array, int from, int length) {
        PairList list = new PairList();
        for (int i = from; i < from + length; i += 3) {
            list.add((Object)array[i], (Object)Double.longBitsToDouble((long)array[i + 1] << 32 | (long)array[i + 2] & 0xFFFFFFFFL));
        }
        return list;
    }

    public static int[] savePairListDouble(PairList<Integer, Double> list) {
        if (list == null) {
            return null;
        }
        int[] array = new int[list.size() * 3];
        for (int i = 0; i < list.size(); ++i) {
            Pair pair = (Pair)list.get(i);
            array[i * 3] = (Integer)pair.key;
            long value = Double.doubleToLongBits((Double)pair.value);
            array[i * 3 + 1] = (int)(value >> 32);
            array[i * 3 + 2] = (int)value;
        }
        return array;
    }

    public static int[] savePairListInteger(PairList<Integer, Integer> list) {
        if (list == null) {
            return null;
        }
        int[] array = new int[list.size() * 2];
        for (int i = 0; i < list.size(); ++i) {
            Pair pair = (Pair)list.get(i);
            array[i * 2] = (Integer)pair.key;
            array[i * 2 + 1] = (Integer)pair.value;
        }
        return array;
    }

    public PairList<Integer, Double> interpolateToDouble(PairList<Integer, Integer> list) {
        if (list == null) {
            return null;
        }
        PairList converted = new PairList();
        for (Pair pair : list) {
            converted.add(pair.key, (Object)(this.offGrid.gridMCLength * (double)((Integer)pair.value).intValue()));
        }
        return converted;
    }

    public PairList<Integer, Double> invert(PairList<Integer, Double> list) {
        if (list == null) {
            return null;
        }
        PairList inverted = new PairList();
        for (int i = list.size() - 1; i >= 0; --i) {
            Pair pair = (Pair)list.get(i);
            inverted.add((Object)(this.duration - (Integer)pair.key), pair.value);
        }
        return inverted;
    }

    public LittleAdvancedDoor(LittleStructureType type) {
        super(type);
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        if (this.rotX != null) {
            nbt.func_74783_a("rotX", LittleAdvancedDoor.savePairListDouble(this.rotX));
        }
        if (this.rotY != null) {
            nbt.func_74783_a("rotY", LittleAdvancedDoor.savePairListDouble(this.rotY));
        }
        if (this.rotZ != null) {
            nbt.func_74783_a("rotZ", LittleAdvancedDoor.savePairListDouble(this.rotZ));
        }
        if (this.offGrid != null) {
            nbt.func_74768_a("offGrid", this.offGrid.size);
            if (this.offX != null) {
                nbt.func_74783_a("offX", LittleAdvancedDoor.savePairListInteger(this.offX));
            }
            if (this.offY != null) {
                nbt.func_74783_a("offY", LittleAdvancedDoor.savePairListInteger(this.offY));
            }
            if (this.offZ != null) {
                nbt.func_74783_a("offZ", LittleAdvancedDoor.savePairListInteger(this.offZ));
            }
        }
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        if (nbt.func_74764_b("rotX")) {
            this.rotX = LittleAdvancedDoor.loadPairListDouble(nbt.func_74759_k("rotX"));
        }
        if (nbt.func_74764_b("rotY")) {
            this.rotY = LittleAdvancedDoor.loadPairListDouble(nbt.func_74759_k("rotY"));
        }
        if (nbt.func_74764_b("rotZ")) {
            this.rotZ = LittleAdvancedDoor.loadPairListDouble(nbt.func_74759_k("rotZ"));
        }
        if (nbt.func_74764_b("offGrid")) {
            this.offGrid = LittleGridContext.get(nbt.func_74762_e("offGrid"));
            if (nbt.func_74764_b("offX")) {
                this.offX = LittleAdvancedDoor.loadPairListInteger(nbt.func_74759_k("offX"));
            }
            if (nbt.func_74764_b("offY")) {
                this.offY = LittleAdvancedDoor.loadPairListInteger(nbt.func_74759_k("offY"));
            }
            if (nbt.func_74764_b("offZ")) {
                this.offZ = LittleAdvancedDoor.loadPairListInteger(nbt.func_74759_k("offZ"));
            }
        }
    }

    @Override
    public boolean tryToPlacePreviews(World world, EntityPlayer player, UUID uuid, StructureAbsolute absolute) {
        RotationTransformation rotation;
        LittleAbsolutePreviewsStructure previews = this.getAbsolutePreviews(this.getMainTile().te.func_174877_v());
        LittleAdvancedDoor newDoor = (LittleAdvancedDoor)previews.getStructure();
        if (newDoor.axisCenter.getContext().size > previews.context.size) {
            previews.convertTo(newDoor.axisCenter.getContext());
        } else if (newDoor.axisCenter.getContext().size < previews.context.size) {
            newDoor.axisCenter.convertTo(previews.context);
        }
        RotationTransformation rotationTransformation = this.rotX != null || this.rotY != null || this.rotZ != null ? new RotationTransformation(this.rotX != null ? (Double)this.rotX.getLast().value : 0.0, this.rotY != null ? (Double)this.rotY.getLast().value : 0.0, this.rotZ != null ? (Double)this.rotZ.getLast().value : 0.0) : (rotation = null);
        OffsetTransformation offset = this.offX != null || this.offY != null || this.offZ != null ? new OffsetTransformation(this.offX != null ? (double)((Integer)this.offX.getLast().value).intValue() * this.offGrid.gridMCLength : 0.0, this.offY != null ? (double)((Integer)this.offY.getLast().value).intValue() * this.offGrid.gridMCLength : 0.0, this.offZ != null ? (double)((Integer)this.offZ.getLast().value).intValue() * this.offGrid.gridMCLength : 0.0) : null;
        PairList open = new PairList();
        open.add((Object)0L, (Object)new TimestampAnimation(this.duration, this.interpolateToDouble(this.offX), this.interpolateToDouble(this.offY), this.interpolateToDouble(this.offZ), this.rotX, this.rotY, this.rotZ));
        PairList close = new PairList();
        close.add((Object)0L, (Object)new TimestampAnimation(this.duration, this.invert(this.interpolateToDouble(this.offX)), this.invert(this.interpolateToDouble(this.offY)), this.invert(this.interpolateToDouble(this.offZ)), this.invert(this.rotX), this.invert(this.rotY), this.invert(this.rotZ)));
        DoorController controller = new DoorController(new AnimationState("closed", null, null), new AnimationState("opened", rotation, offset), false, this.duration, new AnimationTimeline(this.duration, (PairList<Long, Animation>)open), new AnimationTimeline(this.duration, (PairList<Long, Animation>)close));
        return this.place(world, player, previews, controller, uuid, absolute);
    }

    @Override
    public StructureAbsolute getAbsoluteAxis() {
        if (this.axisCenter == null) {
            return new StructureAbsolute(this.getMainTile().te.func_174877_v(), this.getMainTile().box, this.getMainTile().getContext());
        }
        return new StructureAbsolute(this.lastMainTileVec != null ? this.lastMainTileVec : this.getMainTile().getAbsolutePos(), this.axisCenter);
    }

    public static class LittleAdvancedDoorParser
    extends LittleStructureGuiParser {
        public LittleGridContext context;
        @SideOnly(value=Side.CLIENT)
        private KeyControl selected;

        public LittleAdvancedDoorParser(GuiParent parent) {
            super(parent);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(ItemStack stack, LittleStructure structure) {
            LittleAdvancedDoor door = structure instanceof LittleAdvancedDoor ? (LittleAdvancedDoor)structure : null;
            ArrayList<TimelineChannel> channels = new ArrayList<TimelineChannel>();
            channels.add(new TimelineChannel.TimelineChannelDouble("rot X").addKeyFixed(0, (Object)0.0).addKeys(door != null ? door.rotX : null));
            channels.add(new TimelineChannel.TimelineChannelDouble("rot Y").addKeyFixed(0, (Object)0.0).addKeys(door != null ? door.rotY : null));
            channels.add(new TimelineChannel.TimelineChannelDouble("rot Z").addKeyFixed(0, (Object)0.0).addKeys(door != null ? door.rotZ : null));
            channels.add(new TimelineChannel.TimelineChannelInteger("off X").addKeyFixed(0, (Object)0).addKeys(door != null ? door.offX : null));
            channels.add(new TimelineChannel.TimelineChannelInteger("off Y").addKeyFixed(0, (Object)0).addKeys(door != null ? door.offY : null));
            channels.add(new TimelineChannel.TimelineChannelInteger("off Z").addKeyFixed(0, (Object)0).addKeys(door != null ? door.offZ : null));
            this.parent.controls.add(new GuiTimeline("timeline", 0, 0, 190, 67, door != null ? door.duration : 50, channels).setSidebarWidth(30));
            this.parent.controls.add(new GuiLabel("tick", "0", 150, 75));
            this.context = door != null ? (door.offGrid != null ? door.offGrid : LittleGridContext.get()) : LittleGridContext.get();
            this.parent.controls.add((GuiControl)new GuiTextfield("keyValue", "", 0, 75, 40, 10).setFloatOnly().setEnabled(false));
            this.parent.controls.add(new GuiLTDistance("keyDistance", 0, 75, this.context, 0).setVisible(false));
            this.parent.controls.add(new GuiLabel("Position:", 90, 90));
            this.parent.controls.add((GuiControl)new GuiTextfield("keyPosition", "", 149, 90, 40, 10).setNumbersOnly().setEnabled(false));
            this.parent.controls.add(new SubGuiDialogAxis.GuiAxisButton("axis", "open axis", 0, 100, 50, 10, LittleGridContext.get(stack.func_77978_p()), structure instanceof LittleAdvancedDoor ? (LittleAdvancedDoor)structure : null));
            this.parent.controls.add(new GuiLabel("Duration:", 90, 112));
            this.parent.controls.add(new GuiTextfield("duration_s", structure instanceof LittleAdvancedDoor ? "" + ((LittleDoorBase)structure).duration : "50", 149, 112, 40, 10).setNumbersOnly());
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onKeySelected(GuiTimeline.KeySelectedEvent event) {
            GuiTextfield textfield = (GuiTextfield)this.parent.get("keyValue");
            GuiLTDistance distance = (GuiLTDistance)this.parent.get("keyDistance");
            this.selected = (KeyControl)event.source;
            if (((KeyControl)event.source).value instanceof Double) {
                distance.setVisible(false);
                textfield.setEnabled(true);
                textfield.setVisible(true);
                textfield.text = "" + this.selected.value;
            } else {
                distance.setEnabled(true);
                distance.setVisible(true);
                textfield.setVisible(false);
                distance.setDistance(this.context, (Integer)this.selected.value);
            }
            GuiTextfield position = (GuiTextfield)this.parent.get("keyPosition");
            position.setEnabled(true);
            position.text = "" + this.selected.tick;
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onTextfieldChanges(GuiControlChangedEvent event) {
            if (event.source.is(new String[]{"keyDistance"})) {
                int scale;
                if (!this.selected.modifiable) {
                    return;
                }
                GuiLTDistance distance = (GuiLTDistance)event.source;
                LittleGridContext newContext = distance.getDistanceContext();
                if (newContext.size > this.context.size) {
                    scale = newContext.size / this.context.size;
                    GuiTimeline timeline = (GuiTimeline)this.parent.get("timeline");
                    for (TimelineChannel channel : timeline.channels) {
                        if (!(channel instanceof TimelineChannel.TimelineChannelInteger)) continue;
                        for (Object control : channel.controls) {
                            KeyControl keyControl = (KeyControl)control;
                            Integer.valueOf((Integer)keyControl.value * scale);
                            keyControl.value = keyControl.value;
                        }
                    }
                    this.context = newContext;
                }
                scale = this.context.size / newContext.size;
                this.selected.value = distance.getDistance();
            } else if (event.source.is(new String[]{"keyValue"})) {
                if (!this.selected.modifiable) {
                    return;
                }
                try {
                    this.selected.value = Double.parseDouble(((GuiTextfield)event.source).text);
                }
                catch (NumberFormatException distance) {}
            } else if (event.source.is(new String[]{"keyPosition"})) {
                if (!this.selected.modifiable) {
                    return;
                }
                try {
                    GuiTimeline timeline = (GuiTimeline)this.parent.get("timeline");
                    int tick = this.selected.tick;
                    this.selected.tick = Integer.parseInt(((GuiTextfield)event.source).text);
                    if (tick != this.selected.tick) {
                        timeline.adjustKeysPositionX();
                    }
                }
                catch (NumberFormatException timeline) {}
            } else if (event.source.is(new String[]{"duration_s"})) {
                try {
                    GuiTimeline timeline = (GuiTimeline)this.parent.get("timeline");
                    timeline.setDuration(Integer.parseInt(((GuiTextfield)event.source).text));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onKeyDeselected(GuiTimeline.KeyDeselectedEvent event) {
            this.selected = null;
            GuiTextfield textfield = (GuiTextfield)this.parent.get("keyValue");
            textfield.setEnabled(false);
            textfield.text = "";
            textfield.setCursorPositionZero();
            textfield = (GuiTextfield)this.parent.get("keyPosition");
            textfield.setEnabled(false);
            textfield.text = "";
            textfield.setCursorPositionZero();
            GuiLTDistance distance = (GuiLTDistance)this.parent.get("keyDistance");
            distance.setEnabled(false);
            distance.resetTextfield();
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void toolTip(GuiToolTipEvent event) {
            if (event.source.is(new String[]{"timeline"})) {
                ((GuiLabel)this.parent.get((String)"tick")).caption = (String)event.tooltip.get(0);
                event.CancelEvent();
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleStructure parseStructure(ItemStack stack) {
            LittleAdvancedDoor door = this.createStructure(LittleAdvancedDoor.class);
            GuiTileViewer viewer = ((SubGuiDialogAxis.GuiAxisButton)this.parent.get((String)"axis")).viewer;
            door.axisCenter = new StructureRelative(viewer.getBox(), viewer.getAxisContext());
            GuiTimeline timeline = (GuiTimeline)this.parent.get("timeline");
            door.duration = timeline.getDuration();
            door.rotX = ((TimelineChannel)timeline.channels.get(0)).getPairs();
            door.rotY = ((TimelineChannel)timeline.channels.get(1)).getPairs();
            door.rotZ = ((TimelineChannel)timeline.channels.get(2)).getPairs();
            door.offX = ((TimelineChannel)timeline.channels.get(3)).getPairs();
            door.offY = ((TimelineChannel)timeline.channels.get(4)).getPairs();
            door.offZ = ((TimelineChannel)timeline.channels.get(5)).getPairs();
            door.offGrid = this.context;
            return door;
        }
    }
}

