/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.items.ItemColorTube;
import com.creativemd.littletiles.common.items.ItemLittleChisel;
import com.creativemd.littletiles.common.items.ItemLittleGrabber;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.LittleTileBlockColored;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleBlockPacket
extends CreativeCorePacket {
    public BlockPos blockPos;
    public Vec3d pos;
    public Vec3d look;
    public BlockPacketAction action;
    public NBTTagCompound nbt;

    public LittleBlockPacket() {
    }

    public LittleBlockPacket(BlockPos blockPos, EntityPlayer player, BlockPacketAction action) {
        this(blockPos, player, action, new NBTTagCompound());
    }

    public LittleBlockPacket(BlockPos blockPos, EntityPlayer player, BlockPacketAction action, NBTTagCompound nbt) {
        this.blockPos = blockPos;
        this.action = action;
        this.pos = player.func_174824_e(TickUtils.getPartialTickTime());
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(TickUtils.getPartialTickTime());
        this.look = this.pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        this.nbt = nbt;
    }

    public void writeBytes(ByteBuf buf) {
        LittleBlockPacket.writePos((ByteBuf)buf, (BlockPos)this.blockPos);
        LittleBlockPacket.writeVec3d((Vec3d)this.pos, (ByteBuf)buf);
        LittleBlockPacket.writeVec3d((Vec3d)this.look, (ByteBuf)buf);
        buf.writeInt(this.action.ordinal());
        LittleBlockPacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public void readBytes(ByteBuf buf) {
        this.blockPos = LittleBlockPacket.readPos((ByteBuf)buf);
        this.pos = LittleBlockPacket.readVec3d((ByteBuf)buf);
        this.look = LittleBlockPacket.readVec3d((ByteBuf)buf);
        this.action = BlockPacketAction.values()[buf.readInt()];
        this.nbt = LittleBlockPacket.readNBT((ByteBuf)buf);
    }

    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
    }

    public void executeServer(EntityPlayer player) {
        TileEntity tileEntity = player.field_70170_p.func_175625_s(this.blockPos);
        World world = player.field_70170_p;
        if (tileEntity instanceof TileEntityLittleTiles) {
            TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
            LittleTile tile = te.getFocusedTile(this.pos, this.look);
            if (!LittleAction.isAllowedToInteract(player, this.blockPos, this.action.rightClick, EnumFacing.EAST)) {
                LittleAction.sendBlockResetToClient((EntityPlayerMP)player, this.blockPos, te);
                return;
            }
            if (tile != null) {
                ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
                RayTraceResult moving = te.rayTrace(this.pos, this.look);
                this.action.action(world, te, tile, stack, player, moving, this.blockPos, this.nbt);
                if (!player.field_70170_p.field_72995_K) {
                    EntityPlayerMP playerMP = (EntityPlayerMP)player;
                    Slot slot = playerMP.field_71070_bA.func_75147_a((IInventory)playerMP.field_71071_by, playerMP.field_71071_by.field_70461_c);
                    playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(playerMP.field_71070_bA.field_75152_c, slot.field_75222_d, playerMP.field_71071_by.func_70448_g()));
                }
            }
        }
    }

    public static enum BlockPacketAction {
        COLOR_TUBE(true){

            @Override
            public void action(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, NBTTagCompound nbt) {
                if (tile.getClass() == LittleTileBlock.class || tile instanceof LittleTileBlockColored) {
                    int color = -1;
                    if (tile instanceof LittleTileBlockColored) {
                        color = ((LittleTileBlockColored)tile).color;
                    }
                    ItemColorTube.setColor(player.func_184614_ca(), color);
                }
            }
        }
        ,
        CHISEL(false){

            @Override
            public void action(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, NBTTagCompound nbt) {
                LittleTilePreview preview = tile.getPreviewTile();
                preview.box = new LittleTileBox(LittleGridContext.get().minPos, LittleGridContext.get().minPos, LittleGridContext.get().minPos, LittleGridContext.get().size, LittleGridContext.get().size, LittleGridContext.get().size);
                ItemLittleChisel.setPreview(stack, preview);
            }
        }
        ,
        GRABBER(false){

            @Override
            public void action(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, NBTTagCompound nbt) {
                ItemLittleGrabber.getMode(stack).littleBlockAction(world, te, tile, stack, pos, nbt);
            }
        }
        ,
        WRENCH(true){

            @Override
            public void action(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, NBTTagCompound nbt) {
                player.func_146105_b((ITextComponent)new TextComponentString("grid:" + te.getContext()), true);
                te.combineTiles();
                te.convertBlockToVanilla();
            }
        };

        public final boolean rightClick;

        private BlockPacketAction(boolean rightClick) {
            this.rightClick = rightClick;
        }

        public abstract void action(World var1, TileEntityLittleTiles var2, LittleTile var3, ItemStack var4, EntityPlayer var5, RayTraceResult var6, BlockPos var7, NBTTagCompound var8);
    }
}

