/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.entity;

import com.creativemd.creativecore.client.rendering.model.BufferBuilderUtils;
import com.creativemd.littletiles.client.render.BlockLayerRenderBuffer;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;

public class LittleRenderChunk {
    public final BlockPos pos;
    protected final VertexBuffer[] vertexBuffers = new VertexBuffer[BlockRenderLayer.values().length];
    protected BufferBuilder[] tempBuffers = new BufferBuilder[BlockRenderLayer.values().length];
    protected List<BufferBuilder>[] queuedBuffers = new List[BlockRenderLayer.values().length];
    protected boolean[] bufferChanged = new boolean[BlockRenderLayer.values().length];
    public int transparencySortedIndex = 0;

    public LittleRenderChunk(BlockPos pos) {
        this.pos = pos;
    }

    public void addRenderData(TileEntityLittleTiles te) {
        BlockLayerRenderBuffer layers = te.getBuffer();
        if (layers != null) {
            for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                BlockRenderLayer layer = BlockRenderLayer.values()[i];
                BufferBuilder tempBuffer = layers.getBufferByLayer(layer);
                if (tempBuffer == null) continue;
                if (this.queuedBuffers[i] == null) {
                    this.queuedBuffers[i] = new ArrayList<BufferBuilder>();
                }
                this.queuedBuffers[i].add(tempBuffer);
            }
        }
    }

    public void resortTransparency(int index, float x, float y, float z) {
        if (index == this.transparencySortedIndex) {
            return;
        }
        this.transparencySortedIndex = index;
        int translucentIndex = BlockRenderLayer.TRANSLUCENT.ordinal();
        BufferBuilder builder = this.tempBuffers[translucentIndex];
        if (builder != null) {
            builder.func_181674_a(x, y, z);
            if (this.vertexBuffers[translucentIndex] != null) {
                this.vertexBuffers[translucentIndex].func_177362_c();
            }
            this.vertexBuffers[translucentIndex] = new VertexBuffer(DefaultVertexFormats.field_176600_a);
            this.vertexBuffers[translucentIndex].func_181722_a(this.tempBuffers[translucentIndex].func_178966_f());
        }
    }

    protected void processQueue() {
        for (int i = 0; i < this.queuedBuffers.length; ++i) {
            if (this.queuedBuffers[i] == null) continue;
            int expand = 0;
            for (BufferBuilder teBuffer : this.queuedBuffers[i]) {
                expand += teBuffer.func_178989_h();
            }
            BufferBuilder tempBuffer = this.tempBuffers[i];
            if (tempBuffer == null) {
                tempBuffer = new BufferBuilder(DefaultVertexFormats.field_176600_a.func_181719_f() * expand * 4);
                tempBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                tempBuffer.func_178969_c((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p());
                this.tempBuffers[i] = tempBuffer;
            } else {
                BufferBuilderUtils.growBuffer((BufferBuilder)tempBuffer, (int)(tempBuffer.func_178973_g().func_181719_f() * expand * 4));
            }
            for (BufferBuilder teBuffer : this.queuedBuffers[i]) {
                BufferBuilderUtils.addBuffer((BufferBuilder)tempBuffer, (BufferBuilder)teBuffer);
            }
            this.queuedBuffers[i] = null;
            this.bufferChanged[i] = true;
        }
    }

    public void uploadBuffer() {
        this.processQueue();
        for (int i = 0; i < this.bufferChanged.length; ++i) {
            if (!this.bufferChanged[i]) continue;
            if (this.vertexBuffers[i] != null) {
                this.vertexBuffers[i].func_177362_c();
            }
            this.vertexBuffers[i] = new VertexBuffer(DefaultVertexFormats.field_176600_a);
            this.vertexBuffers[i].func_181722_a(this.tempBuffers[i].func_178966_f());
            this.bufferChanged[i] = false;
        }
    }

    public VertexBuffer getLayerBuffer(BlockRenderLayer layer) {
        return this.vertexBuffers[layer.ordinal()];
    }

    public void markCompleted() {
        for (int j = 0; j < this.tempBuffers.length; ++j) {
            if (BlockRenderLayer.values()[j] == BlockRenderLayer.TRANSLUCENT) continue;
            this.tempBuffers[j] = null;
        }
    }

    public void unload() {
        for (int i = 0; i < this.vertexBuffers.length; ++i) {
            if (this.vertexBuffers[i] == null) continue;
            this.vertexBuffers[i].func_177362_c();
        }
    }
}

