/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.creativecore.client.rendering.model.BufferBuilderUtils;
import com.creativemd.littletiles.client.render.BlockLayerRenderBuffer;
import com.creativemd.littletiles.client.render.LightChangeEventListener;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class LittleChunkDispatcher
extends ChunkRenderDispatcher {
    public static AtomicInteger currentRenderIndex = new AtomicInteger(0);
    private static Method setLayerUseMethod = ReflectionHelper.findMethod(CompiledChunk.class, (String)"setLayerUsed", (String)"func_178486_a", (Class[])new Class[]{BlockRenderLayer.class});
    private static Field setTileEntities = ReflectionHelper.findField(RenderChunk.class, (String[])new String[]{"setTileEntities", "field_181056_j"});
    private static Field littleTiles = ReflectionHelper.findField(RenderChunk.class, (String[])new String[]{"littleTiles"});
    private static Field dynamicLightUpdate = ReflectionHelper.findField(RenderChunk.class, (String[])new String[]{"dynamicLightUpdate"});
    private static Minecraft mc = Minecraft.func_71410_x();
    public static Field added = ReflectionHelper.findField(BufferBuilder.class, (String[])new String[]{"littleTilesAdded"});
    public static BufferBuilder.State emptyState = LittleChunkDispatcher.loadEmptyState();

    public static void onReloadRenderers(RenderGlobal renderGlobal) {
        if (LittleChunkDispatcher.mc.field_71438_f == renderGlobal) {
            currentRenderIndex.incrementAndGet();
            LittleChunkDispatcher.mc.field_71441_e.func_72954_a((IWorldEventListener)new LightChangeEventListener());
        }
    }

    public static void onOptifineMarksChunkRenderUpdateForDynamicLights(RenderChunk chunk) {
        try {
            dynamicLightUpdate.setBoolean(chunk, true);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static void addTileEntity(List<TileEntityLittleTiles> tiles, TileEntity te) {
        if (te instanceof TileEntityLittleTiles) {
            tiles.add((TileEntityLittleTiles)te);
        }
    }

    public static void onDoneRendering(RenderChunk chunk, List<TileEntityLittleTiles> tiles) {
        try {
            littleTiles.set(chunk, tiles);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static List<TileEntityLittleTiles> getLittleTE(RenderChunk chunk) {
        try {
            return (List)littleTiles.get(chunk);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ListenableFuture<Object> func_188245_a(BlockRenderLayer layer, BufferBuilder buffer, RenderChunk chunk, CompiledChunk compiled, double p_188245_5_) {
        try {
            if (added.getBoolean(buffer)) {
                return super.func_188245_a(layer, buffer, chunk, compiled, p_188245_5_);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e2) {
            e2.printStackTrace();
        }
        if (buffer.func_178973_g() != null && (layer != BlockRenderLayer.TRANSLUCENT || compiled.func_178487_c() != emptyState && !(compiled.func_178487_c() instanceof LittleVertexBufferState))) {
            BufferBuilder teBuffer;
            BlockLayerRenderBuffer blockLayerBuffer;
            List<TileEntityLittleTiles> tiles = LittleChunkDispatcher.getLittleTE(chunk);
            if (tiles == null || tiles.isEmpty()) {
                try {
                    added.setBoolean(buffer, true);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
                return super.func_188245_a(layer, buffer, chunk, compiled, p_188245_5_);
            }
            int expanded = 0;
            boolean dynamicUpdate = false;
            try {
                if (layer == BlockRenderLayer.SOLID) {
                    dynamicUpdate = dynamicLightUpdate.getBoolean(chunk);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e2) {
                e2.printStackTrace();
            }
            if (!tiles.isEmpty()) {
                for (TileEntityLittleTiles te : tiles) {
                    if (layer == BlockRenderLayer.SOLID) {
                        if (dynamicUpdate) {
                            te.hasLightChanged = true;
                        }
                        te.updateQuadCache(chunk);
                    }
                    if ((blockLayerBuffer = te.getBuffer()) == null || (teBuffer = blockLayerBuffer.getBufferByLayer(layer)) == null) continue;
                    expanded += teBuffer.func_178989_h();
                }
            }
            try {
                if (layer == BlockRenderLayer.SOLID) {
                    dynamicLightUpdate.setBoolean(chunk, false);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e2) {
                e2.printStackTrace();
            }
            if (expanded > 0) {
                if (compiled.func_178491_b(layer)) {
                    try {
                        if (compiled != CompiledChunk.field_178502_a) {
                            setLayerUseMethod.invoke((Object)compiled, layer);
                        }
                        if (chunk.func_178571_g() != CompiledChunk.field_178502_a) {
                            setLayerUseMethod.invoke((Object)chunk.func_178571_g(), layer);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
                        e1.printStackTrace();
                    }
                }
                BufferBuilderUtils.growBuffer((BufferBuilder)buffer, (int)(buffer.func_178973_g().func_181719_f() * expanded * 4));
                for (TileEntityLittleTiles te : tiles) {
                    blockLayerBuffer = te.getBuffer();
                    if (blockLayerBuffer == null || (teBuffer = blockLayerBuffer.getBufferByLayer(layer)) == null) continue;
                    BufferBuilderUtils.addBuffer((BufferBuilder)buffer, (BufferBuilder)teBuffer);
                }
                if (layer == BlockRenderLayer.TRANSLUCENT && buffer.func_178973_g() != null) {
                    Entity entity = mc.func_175606_aa();
                    float x = (float)entity.field_70165_t;
                    float y = (float)entity.field_70163_u + entity.func_70047_e();
                    float z = (float)entity.field_70161_v;
                    buffer.func_181674_a(x, y, z);
                    compiled.func_178494_a((BufferBuilder.State)new LittleVertexBufferState(buffer, buffer.func_181672_a()));
                }
                buffer.func_178966_f().position(0);
                buffer.func_178966_f().limit(buffer.func_178973_g().func_181719_f() * buffer.func_178989_h() * 4);
                try {
                    added.setBoolean(buffer, true);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
        return super.func_188245_a(layer, buffer, chunk, compiled, p_188245_5_);
    }

    private static BufferBuilder.State loadEmptyState() {
        BufferBuilder buffer = new BufferBuilder(0);
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        BufferBuilder.State state = buffer.func_181672_a();
        buffer.func_178977_d();
        return state;
    }

    public static void resortTransparency(RenderChunk chunk, float x, float y, float z, ChunkCompileTaskGenerator generator) {
        CompiledChunk compiledchunk = generator.func_178544_c();
        if (compiledchunk.func_178487_c() != null && !compiledchunk.func_178491_b(BlockRenderLayer.TRANSLUCENT)) {
            BufferBuilder worldRendererIn = generator.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT);
            BlockPos pos = chunk.func_178568_j();
            worldRendererIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            worldRendererIn.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
            generator.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT).func_178993_a(compiledchunk.func_178487_c());
            worldRendererIn.func_181674_a(x, y, z);
            compiledchunk.func_178494_a((BufferBuilder.State)new LittleVertexBufferState(worldRendererIn, worldRendererIn.func_181672_a()));
            worldRendererIn.func_178977_d();
        } else {
            compiledchunk.func_178494_a(emptyState);
        }
    }

    public static class LittleVertexBufferState
    extends BufferBuilder.State {
        public LittleVertexBufferState(BufferBuilder buffer, BufferBuilder.State state) {
            BufferBuilder bufferBuilder = buffer;
            bufferBuilder.getClass();
            super(bufferBuilder, state.func_179013_a(), state.func_179016_d());
        }
    }
}

