/*
 * Decompiled with CFR 0.152.
 */
package com.dmonsters.blocks;

import com.dmonsters.main.MainMod;
import com.dmonsters.main.ModBlocks;
import com.dmonsters.network.PacketClientFXUpdate;
import com.dmonsters.network.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SoulEye
extends Block {
    public static final PropertyEnum MODE = PropertyEnum.func_177709_a((String)"mode", EnumMode.class);

    public SoulEye() {
        super(Material.field_151573_f);
        this.func_149663_c("dmonsters.souleye");
        this.setRegistryName("souleye");
        this.setCreativeTab(MainMod.MOD_CREATIVETAB);
        this.func_149711_c(3.0f);
        this.func_149752_b(3.0f);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MODE, (Comparable)((Object)EnumMode.SLEEP)));
    }

    public SoulEye setCreativeTab(CreativeTabs tab) {
        super.func_149647_a(tab);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int meta = ((EnumMode)((Object)stateIn.func_177229_b((IProperty)MODE))).getID();
        EnumMode mode = EnumMode.getStateFromMeta(meta);
        if (mode != EnumMode.AWAKE) {
            return;
        }
        for (int x = -4; x < 4; ++x) {
            for (int z = -4; z < 4; ++z) {
                for (int i = 0; i < 1; ++i) {
                    double motionX = rand.nextGaussian() * 0.001;
                    double motionY = Math.abs(rand.nextGaussian() * 0.02);
                    double motionZ = rand.nextGaussian() * 0.001;
                    float randX = rand.nextFloat();
                    float randY = rand.nextFloat();
                    float randZ = rand.nextFloat();
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)(pos.func_177958_n() + x) + 0.5f + randX), (double)((float)pos.func_177956_o() + randY), (double)((float)(pos.func_177952_p() + z) + 0.5f + randZ), motionX, motionY, motionZ, new int[0]);
                }
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!(state.func_177230_c() instanceof SoulEye)) {
            return;
        }
        float lightLevel = worldIn.func_175699_k(pos);
        int meta = ((EnumMode)((Object)state.func_177229_b((IProperty)MODE))).getID();
        EnumMode mode = EnumMode.getStateFromMeta(meta);
        if (lightLevel <= 12.0f) {
            if (mode == EnumMode.SLEEP) {
                worldIn.func_175656_a(pos, ModBlocks.souleye.func_176203_a(1));
            } else if (mode == EnumMode.AWAKING) {
                worldIn.func_175656_a(pos, ModBlocks.souleye.func_176203_a(2));
            } else if (mode == EnumMode.AWAKE) {
                this.killLivingNearby(worldIn, pos, 4);
            }
        } else if (mode == EnumMode.AWAKING) {
            worldIn.func_175656_a(pos, ModBlocks.souleye.func_176203_a(0));
        } else if (mode == EnumMode.AWAKE) {
            worldIn.func_175656_a(pos, ModBlocks.souleye.func_176203_a(1));
        }
    }

    private void killLivingNearby(World worldIn, BlockPos pos, int range) {
        if (!worldIn.field_72995_K) {
            BlockPos AABB_01 = new BlockPos(pos.func_177958_n() - range, pos.func_177956_o(), pos.func_177952_p() - range);
            BlockPos AABB_02 = new BlockPos(pos.func_177958_n() + range, pos.func_177956_o() + range, pos.func_177952_p() + range);
            AxisAlignedBB AABB = new AxisAlignedBB(AABB_01, AABB_02);
            List entities = worldIn.func_72872_a(EntityLiving.class, AABB);
            for (int i = 0; i < entities.size(); ++i) {
                Entity entity = (Entity)entities.get(i);
                this.spawnItem(entity);
                entity.func_70106_y();
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketClientFXUpdate(entity.func_180425_c(), PacketClientFXUpdate.Type.SOULEYE));
            }
        }
    }

    private void spawnItem(Entity entity) {
        Random rnd = new Random();
        float rndFloat = rnd.nextFloat();
        if (rndFloat > 0.5f) {
            return;
        }
        List<Item> itemsList = this.createDropTable();
        Item item = this.getItemToSpawn(itemsList);
        entity.func_145779_a(item, 1);
    }

    private List<Item> createDropTable() {
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(Items.field_151166_bC);
        items.add(Items.field_151074_bl);
        items.add(Items.field_151016_H);
        items.add(Items.field_151137_ax);
        items.add(Items.field_151042_j);
        items.add(Items.field_151128_bU);
        return items;
    }

    private Item getItemToSpawn(List<Item> items) {
        int itemsNumber = items.size();
        Random rnd = new Random();
        int randomItem = rnd.nextInt(itemsNumber);
        return items.get(randomItem);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MODE, (Comparable)((Object)EnumMode.getStateFromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMode)((Object)state.func_177229_b((IProperty)MODE))).getID();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MODE});
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public static enum EnumMode implements IStringSerializable
    {
        SLEEP(0, "sleep"),
        AWAKING(1, "awaking"),
        AWAKE(2, "awake");

        private int ID;
        private String name;

        private EnumMode(int ID, String name) {
            this.ID = ID;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getID() {
            return this.ID;
        }

        public static EnumMode getStateFromMeta(int meta) {
            EnumMode mode = SLEEP;
            switch (meta) {
                case 0: {
                    mode = SLEEP;
                    break;
                }
                case 1: {
                    mode = AWAKING;
                    break;
                }
                case 2: {
                    mode = AWAKE;
                }
            }
            return mode;
        }
    }
}

