/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkEffectHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktSyncPerkActivity
implements IMessage,
IMessageHandler<PktSyncPerkActivity, IMessage> {
    private AbstractPerk perk;
    private boolean unlock;
    private NBTTagCompound newData;
    private NBTTagCompound oldData;
    private Type type = null;

    public PktSyncPerkActivity() {
    }

    public PktSyncPerkActivity(AbstractPerk perk, boolean unlock) {
        this.perk = perk;
        this.unlock = unlock;
    }

    public PktSyncPerkActivity(Type type) {
        this.type = type;
    }

    public PktSyncPerkActivity(AbstractPerk perk, NBTTagCompound oldData, NBTTagCompound newData) {
        this.type = Type.DATACHANGE;
        this.perk = perk;
        this.oldData = oldData;
        this.newData = newData;
    }

    public void fromBytes(ByteBuf buf) {
        this.unlock = buf.readBoolean();
        int tt = buf.readInt();
        this.type = tt == -1 ? null : Type.values()[MathHelper.func_76125_a((int)tt, (int)0, (int)(Type.values().length - 1))];
        if (buf.readBoolean()) {
            this.perk = PerkTree.PERK_TREE.getPerk(new ResourceLocation(ByteBufUtils.readString(buf)));
        }
        if (buf.readBoolean()) {
            this.newData = ByteBufUtils.readNBTTag(buf);
        }
        if (buf.readBoolean()) {
            this.oldData = ByteBufUtils.readNBTTag(buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.unlock);
        if (this.type == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.type.ordinal());
        }
        buf.writeBoolean(this.perk != null);
        if (this.perk != null) {
            ByteBufUtils.writeString(buf, this.perk.getRegistryName().toString());
        }
        buf.writeBoolean(this.newData != null);
        if (this.newData != null) {
            ByteBufUtils.writeNBTTag(buf, this.newData);
        }
        buf.writeBoolean(this.oldData != null);
        if (this.oldData != null) {
            ByteBufUtils.writeNBTTag(buf, this.oldData);
        }
    }

    public IMessage onMessage(PktSyncPerkActivity message, MessageContext ctx) {
        this.handleClientPerkUpdate(message);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleClientPerkUpdate(PktSyncPerkActivity pkt) {
        AstralSorcery.proxy.scheduleClientside(() -> {
            if (Minecraft.func_71410_x().field_71439_g != null) {
                if (pkt.type != null) {
                    switch (pkt.type) {
                        case CLEARALL: {
                            PerkEffectHelper.EVENT_INSTANCE.clearAllPerksClient((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                            break;
                        }
                        case UNLOCKALL: {
                            PerkEffectHelper.EVENT_INSTANCE.reapplyAllPerksClient((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                            break;
                        }
                        case DATACHANGE: {
                            PerkEffectHelper.EVENT_INSTANCE.notifyPerkDataChangeClient((EntityPlayer)Minecraft.func_71410_x().field_71439_g, pkt.perk, pkt.oldData, pkt.newData);
                            break;
                        }
                    }
                } else if (pkt.perk != null) {
                    PerkEffectHelper.EVENT_INSTANCE.notifyPerkChange((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT, pkt.perk, !pkt.unlock);
                }
            }
        });
    }

    public static enum Type {
        CLEARALL,
        UNLOCKALL,
        DATACHANGE;

    }
}

