/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.client;

import hellfirepvp.astralsorcery.client.util.UISextantCache;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.tool.sextant.SextantFinder;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.ClientReplyPacket;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktRequestSextantTarget
implements IMessageHandler<PktRequestSextantTarget, IMessage>,
IMessage,
ClientReplyPacket {
    private String regNameExpected = null;
    private BlockPos resultPos = null;
    private Integer resultDim = null;

    public PktRequestSextantTarget() {
    }

    public PktRequestSextantTarget(SextantFinder.TargetObject object) {
        this.regNameExpected = object.getRegistryName();
    }

    public PktRequestSextantTarget(SextantFinder.TargetObject to, @Nullable BlockPos result, Integer dimension) {
        this.regNameExpected = to.getRegistryName();
        this.resultPos = result;
        this.resultDim = dimension;
    }

    public void fromBytes(ByteBuf buf) {
        this.regNameExpected = ByteBufUtils.readString(buf);
        if (buf.readBoolean()) {
            this.resultPos = ByteBufUtils.readPos(buf);
        }
        if (buf.readBoolean()) {
            this.resultDim = buf.readInt();
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeString(buf, this.regNameExpected);
        buf.writeBoolean(this.resultPos != null);
        if (this.resultPos != null) {
            ByteBufUtils.writePos(buf, this.resultPos);
        }
        buf.writeBoolean(this.resultDim != null);
        if (this.resultDim != null) {
            buf.writeInt(this.resultDim.intValue());
        }
    }

    public IMessage onMessage(PktRequestSextantTarget pkt, MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
                SextantFinder.TargetObject to = SextantFinder.getByName(pkt.regNameExpected);
                if (to == null) {
                    return;
                }
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (!MiscUtils.isPlayerFakeMP(player)) {
                    Tuple<EnumHand, ItemStack> heldStack = MiscUtils.getMainOrOffHand((EntityLivingBase)player, ItemsAS.sextant, st -> to.isSelectable((ItemStack)st, ResearchManager.getProgress((EntityPlayer)player, Side.SERVER)));
                    if (heldStack == null) {
                        return;
                    }
                    Thread tr = new Thread(() -> {
                        BlockPos result = to.searchFor((WorldServer)player.field_70170_p, player.func_180425_c());
                        PktRequestSextantTarget target = new PktRequestSextantTarget(to, result, player.field_70170_p.field_73011_w.getDimension());
                        PacketChannel.CHANNEL.sendTo((IMessage)target, player);
                    });
                    tr.setName("SextantTargetFinder ThreadId=" + tr.getId());
                    tr.start();
                }
            });
        } else {
            this.handlePacketClient(pkt);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handlePacketClient(PktRequestSextantTarget pkt) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71441_e == null) {
                return;
            }
            SextantFinder.TargetObject to = SextantFinder.getByName(pkt.regNameExpected);
            if (to == null) {
                return;
            }
            UISextantCache.addTarget(to, pkt.resultPos, pkt.resultDim);
        });
    }
}

