/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles;

import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.api.IEnergyStorage;
import hellfirepvp.modularmachinery.common.block.prop.EnergyHatchSize;
import hellfirepvp.modularmachinery.common.integration.IntegrationIC2EventHandlerHelper;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.TileEnergyHatch;
import hellfirepvp.modularmachinery.common.util.IEnergyHandler;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

@Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")
public class TileEnergyOutputHatch
extends TileEnergyHatch
implements IEnergySource {
    public TileEnergyOutputHatch() {
    }

    public TileEnergyOutputHatch(EnergyHatchSize size) {
        super(size);
    }

    public void func_73660_a() {
        int transferCap = Math.min(this.size.transferLimit, this.convertDownEnergy(this.energy));
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int transferred;
            if (Loader.isModLoaded((String)"redstoneflux")) {
                transferred = this.attemptFERFTransfer(face, transferCap);
                transferCap -= transferred;
                this.energy -= (long)transferred;
            } else {
                transferred = this.attemptFETransfer(face, transferCap);
                transferCap -= transferred;
                this.energy -= (long)transferred;
            }
            if (transferCap <= 0) break;
        }
    }

    private int attemptFETransfer(EnumFacing face, int maxTransferLeft) {
        net.minecraftforge.energy.IEnergyStorage ce;
        BlockPos at = this.func_174877_v().func_177972_a(face);
        EnumFacing accessingSide = face.func_176734_d();
        int receivedEnergy = 0;
        TileEntity te = this.field_145850_b.func_175625_s(at);
        if (te != null && !(te instanceof TileEnergyHatch) && te.hasCapability(CapabilityEnergy.ENERGY, accessingSide) && (ce = (net.minecraftforge.energy.IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, accessingSide)) != null && ce.canReceive()) {
            try {
                receivedEnergy = ce.receiveEnergy(maxTransferLeft, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return receivedEnergy;
    }

    @Optional.Method(modid="redstoneflux")
    private int attemptFERFTransfer(EnumFacing face, int maxTransferLeft) {
        BlockPos at = this.func_174877_v().func_177972_a(face);
        EnumFacing accessingSide = face.func_176734_d();
        int receivedEnergy = 0;
        TileEntity te = this.field_145850_b.func_175625_s(at);
        if (te != null && !(te instanceof TileEnergyHatch)) {
            net.minecraftforge.energy.IEnergyStorage ce;
            if (te instanceof IEnergyReceiver && ((IEnergyReceiver)te).canConnectEnergy(accessingSide)) {
                try {
                    receivedEnergy = ((IEnergyReceiver)te).receiveEnergy(accessingSide, maxTransferLeft, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (receivedEnergy <= 0 && te instanceof IEnergyStorage) {
                try {
                    receivedEnergy = ((IEnergyStorage)te).receiveEnergy(maxTransferLeft, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (receivedEnergy <= 0 && te.hasCapability(CapabilityEnergy.ENERGY, accessingSide) && (ce = (net.minecraftforge.energy.IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, accessingSide)) != null && ce.canReceive()) {
                try {
                    receivedEnergy = ce.receiveEnergy(maxTransferLeft, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return receivedEnergy;
    }

    @Optional.Method(modid="ic2")
    public void onLoad() {
        super.onLoad();
        IntegrationIC2EventHandlerHelper.fireLoadEvent(this.field_145850_b, (IEnergyTile)this);
    }

    @Optional.Method(modid="ic2")
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return Math.min((long)this.size.getEnergyTransmission(), (long)this.getCurrentEnergy() / 4L);
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        this.energy = MiscUtils.clamp(this.energy - MathHelper.func_76124_d((double)amount) * 4L, 0L, this.size.maxEnergy);
        this.markForUpdate();
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return this.size.energyTier;
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    @Override
    @Nullable
    public MachineComponent provideComponent() {
        return new MachineComponent.EnergyHatch(MachineComponent.IOType.OUTPUT){

            @Override
            public IEnergyHandler getContainerProvider() {
                return TileEnergyOutputHatch.this;
            }
        };
    }
}

