/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.events;

import com.codetaylor.mc.dropt.modules.dropt.ModuleDropt;
import com.codetaylor.mc.dropt.modules.dropt.ModuleDroptConfig;
import com.codetaylor.mc.dropt.modules.dropt.rule.RuleLocator;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.Rule;
import com.codetaylor.mc.dropt.modules.dropt.rule.drop.DropModifier;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.ExperienceCache;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.HeldItemCache;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class EventHandler {
    private RuleLocator ruleLocator;
    private DropModifier dropModifier;
    private DebugFileWrapper debugFileWrapper;
    private HeldItemCache heldItemCache;
    private ExperienceCache experienceCache;
    private Set<BlockPos> explosionCache;

    public EventHandler(RuleLocator ruleLocator, DropModifier dropModifier, HeldItemCache heldItemCache, ExperienceCache experienceCache, Set<BlockPos> explosionCache) {
        this.ruleLocator = ruleLocator;
        this.dropModifier = dropModifier;
        this.heldItemCache = heldItemCache;
        this.experienceCache = experienceCache;
        this.explosionCache = explosionCache;
    }

    @SubscribeEvent
    public void onTickEvent(TickEvent event) {
        if (event.side == Side.SERVER) {
            ModuleDropt.CONSOLE_LOG.update();
        }
    }

    @SubscribeEvent
    public void onExplosionEvent(ExplosionEvent.Detonate event) {
        this.explosionCache.addAll(event.getAffectedBlocks());
    }

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.explosionCache.clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (player instanceof FakePlayer) {
            return;
        }
        ItemStack heldItemMainhand = player.func_184614_ca();
        if (heldItemMainhand.func_190926_b()) {
            this.heldItemCache.put(player.func_70005_c_(), ItemStack.field_190927_a);
        } else {
            this.heldItemCache.put(player.func_70005_c_(), heldItemMainhand.func_77946_l());
        }
        this.experienceCache.put(player.func_70005_c_(), event.getExpToDrop());
        event.setExpToDrop(0);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
        IBlockState blockState = event.getState();
        Block block = blockState.func_177230_c();
        int meta = block.func_176201_c(blockState);
        ResourceLocation registryName = block.getRegistryName();
        World world = event.getWorld();
        BlockPos blockPos = event.getPos();
        if (registryName != null) {
            ModuleDropt.CONSOLE_LOG.increment(registryName, meta);
        }
        Rule matchedRule = this.ruleLocator.locate(world, event.getHarvester(), blockPos, blockState, event.getDrops(), this.heldItemCache, this.explosionCache.contains(blockPos));
        int experience = 0;
        if (event.getHarvester() != null) {
            experience = this.experienceCache.get(event.getHarvester().func_70005_c_());
        }
        if (matchedRule != null) {
            long start = System.currentTimeMillis();
            if (matchedRule.debug) {
                this.initializeDebugFileWrapper();
            }
            this.dropModifier.modifyDrops(world, blockPos, matchedRule, event.getDrops(), this.isSilkTouching(event, this.heldItemCache), event.getFortuneLevel(), experience, this.debugFileWrapper, matchedRule.debug);
            if (ModuleDroptConfig.ENABLE_PROFILE_LOG_OUTPUT) {
                this.initializeDebugFileWrapper();
                this.debugFileWrapper.info(String.format("Modified drops in %d ms", System.currentTimeMillis() - start));
            }
        } else {
            while (experience > 0) {
                int xpDrop = EntityXPOrb.func_70527_a((int)experience);
                experience -= xpDrop;
                world.func_72838_d((Entity)new EntityXPOrb(world, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p(), xpDrop));
            }
        }
        this.closeDebugFileWrapper();
    }

    private boolean isSilkTouching(BlockEvent.HarvestDropsEvent event, HeldItemCache heldItemCache) {
        if (event.isSilkTouching()) {
            return true;
        }
        EntityPlayer harvester = event.getHarvester();
        if (harvester == null) {
            return false;
        }
        ItemStack itemStack = heldItemCache.get(harvester.func_70005_c_());
        if (itemStack.func_190926_b()) {
            return false;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        return enchantments.containsKey(Enchantments.field_185306_r);
    }

    private void initializeDebugFileWrapper() {
        if (this.debugFileWrapper == null) {
            this.debugFileWrapper = new DebugFileWrapper(ModuleDropt.LOG_FILE_WRITER_PROVIDER.createLogFileWriter());
        }
    }

    private void closeDebugFileWrapper() {
        if (this.debugFileWrapper != null) {
            this.debugFileWrapper.close();
            this.debugFileWrapper = null;
        }
    }
}

