/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.command;

import com.buuz135.togetherforever.api.IPlayerInformation;
import com.buuz135.togetherforever.api.ITogetherTeam;
import com.buuz135.togetherforever.api.TogetherForeverAPI;
import com.buuz135.togetherforever.api.command.SubCommandAction;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class TeamKickCommand
extends SubCommandAction {
    public TeamKickCommand() {
        super("kick");
    }

    @Override
    public boolean execute(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length > 1) {
            try {
                EntityPlayerMP commandSender = CommandBase.func_71521_c((ICommandSender)sender);
                ITogetherTeam teamSender = TogetherForeverAPI.getInstance().getPlayerTeam(commandSender.func_110124_au());
                if (teamSender == null) {
                    commandSender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You don't have a team!"));
                    return false;
                }
                if (!teamSender.getOwner().equals(commandSender.func_110124_au())) {
                    commandSender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You can't do that! You are not the owner of the team!"));
                    return false;
                }
                for (IPlayerInformation playerInformation : teamSender.getPlayers()) {
                    if (!playerInformation.getName().equalsIgnoreCase(args[1])) continue;
                    TogetherForeverAPI.getInstance().removePlayerFromTeam(teamSender, playerInformation);
                    if (playerInformation.getPlayer() != null) {
                        playerInformation.getPlayer().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You have been removed from " + teamSender.getTeamName() + "'s team."));
                    }
                    commandSender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You successfully removed " + args[1] + " from your team"));
                    return true;
                }
                commandSender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "That player is not in your team!"));
            }
            catch (PlayerNotFoundException e) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(e.getLocalizedMessage(), e.func_74844_a()));
            }
        }
        return false;
    }

    @Override
    public String getUsage() {
        return "<player_name>";
    }

    @Override
    public String getInfo() {
        return "Kicks a player of your team. Only teams owners can do it.";
    }
}

