/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.command;

import com.buuz135.togetherforever.api.IPlayerInformation;
import com.buuz135.togetherforever.api.ITogetherTeam;
import com.buuz135.togetherforever.api.TogetherForeverAPI;
import com.buuz135.togetherforever.api.command.SubCommandAction;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class TeamInfoCommand
extends SubCommandAction {
    public TeamInfoCommand() {
        super("info");
    }

    @Override
    public boolean execute(MinecraftServer server, ICommandSender sender, String[] args) {
        try {
            EntityPlayerMP senderMP = CommandBase.func_71521_c((ICommandSender)sender);
            ITogetherTeam togetherTeam = TogetherForeverAPI.getInstance().getPlayerTeam(senderMP.func_110124_au());
            if (togetherTeam == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You don't have a team!"));
                return false;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(togetherTeam.getTeamName() + " team information:"));
            for (IPlayerInformation playerInformation : togetherTeam.getPlayers()) {
                sender.func_145747_a((ITextComponent)new TextComponentString(this.getFormattedName(playerInformation, playerInformation.getPlayer() != null, playerInformation.getUUID().equals(togetherTeam.getOwner()), senderMP.func_110124_au().equals(playerInformation.getUUID()))));
            }
            return true;
        }
        catch (PlayerNotFoundException e) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(e.getLocalizedMessage(), e.func_74844_a()));
            return false;
        }
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getInfo() {
        return "Gets the players of your team";
    }

    private String getFormattedName(IPlayerInformation playerInformation, boolean online, boolean owner, boolean yourself) {
        StringBuilder builder = new StringBuilder(" - ");
        if (yourself) {
            builder.append(TextFormatting.GOLD).append('[');
        }
        builder.append(online ? TextFormatting.GREEN : TextFormatting.RED).append(playerInformation.getName());
        if (yourself) {
            builder.append(TextFormatting.GOLD).append(']');
        }
        if (owner) {
            builder.append(TextFormatting.DARK_RED).append('*');
        }
        return builder.toString();
    }
}

