/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.action;

import com.buuz135.togetherforever.action.recovery.GameStageOfflineRecovery;
import com.buuz135.togetherforever.api.IPlayerInformation;
import com.buuz135.togetherforever.api.ITogetherTeam;
import com.buuz135.togetherforever.api.action.EventSyncAction;
import com.buuz135.togetherforever.api.annotation.SyncAction;
import com.buuz135.togetherforever.config.TogetherForeverConfig;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.event.GameStageEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@SyncAction(id="gamestage_event_sync", dependencies={"gamestages"})
public class GameStagesEventSyncAction
extends EventSyncAction<GameStageEvent.Add, GameStageOfflineRecovery> {
    private ListMultimap<EntityPlayerMP, String> stageUnlocks = ArrayListMultimap.create();

    public GameStagesEventSyncAction() {
        super(GameStageEvent.Add.class, GameStageOfflineRecovery.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public NBTTagCompound transformEventToNBT(GameStageEvent.Add event) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("Stage", event.getStageName());
        return compound;
    }

    public static void unlockPlayerStage(EntityPlayerMP playerMP, String stage) {
        MinecraftServer server;
        if (!GameStageHelper.hasStage((EntityPlayer)playerMP, (String)stage) && (server = playerMP.func_184102_h()) != null) {
            GameStageHelper.addStage((EntityPlayer)playerMP, (String)stage);
        }
    }

    @Override
    public List<IPlayerInformation> triggerSync(GameStageEvent.Add object, ITogetherTeam togetherTeam) {
        ArrayList<IPlayerInformation> playerInformations = new ArrayList<IPlayerInformation>();
        if (!TogetherForeverConfig.gamestagesSync) {
            return playerInformations;
        }
        for (IPlayerInformation information : togetherTeam.getPlayers()) {
            EntityPlayerMP playerMP = information.getPlayer();
            if (playerMP == null) {
                playerInformations.add(information);
                continue;
            }
            if (GameStageHelper.hasStage((EntityPlayer)playerMP, (String)object.getStageName()) || this.stageUnlocks.containsEntry((Object)playerMP, (Object)object.getStageName())) continue;
            this.stageUnlocks.put((Object)playerMP, (Object)object.getStageName());
        }
        return playerInformations;
    }

    @Override
    public void syncJoinPlayer(IPlayerInformation toBeSynced, IPlayerInformation teamMember) {
        if (teamMember.getPlayer() != null && toBeSynced.getPlayer() != null) {
            for (String s : GameStageHelper.getPlayerData((EntityPlayer)teamMember.getPlayer()).getStages()) {
                GameStagesEventSyncAction.unlockPlayerStage(toBeSynced.getPlayer(), s);
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        for (Map.Entry entityPlayerMPStringEntry : this.stageUnlocks.entries()) {
            GameStagesEventSyncAction.unlockPlayerStage((EntityPlayerMP)entityPlayerMPStringEntry.getKey(), (String)entityPlayerMPStringEntry.getValue());
        }
        this.stageUnlocks.clear();
    }
}

