/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.worldgen;

import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.wood.BlockGregLog;
import gregtech.common.blocks.wood.BlockGregSapling;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenRubberTree
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_175624_G() == WorldType.field_77138_c || !world.field_73011_w.func_76569_d()) {
            return;
        }
        BlockPos randomPos = new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8);
        Biome biome = world.func_180494_b(randomPos);
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) {
            return;
        }
        int rubberTreeChance = 6;
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET)) {
            rubberTreeChance /= 2;
        }
        if (rubberTreeChance >= 0 && world.field_73011_w.func_76569_d() && random.nextInt(rubberTreeChance) == 0) {
            randomPos = world.func_175672_r(randomPos).func_177977_b();
            IBlockState solidBlockState = world.func_180495_p(randomPos);
            BlockGregSapling sapling = MetaBlocks.SAPLING;
            if (solidBlockState.func_177230_c().canSustainPlant(solidBlockState, (IBlockAccess)world, randomPos, EnumFacing.UP, (IPlantable)sapling)) {
                BlockPos abovePos = randomPos.func_177984_a();
                IBlockState saplingState = sapling.func_176223_P().func_177226_a(BlockGregSapling.VARIANT, (Comparable)((Object)BlockGregLog.LogVariant.RUBBER_WOOD));
                world.func_175656_a(abovePos, saplingState);
                sapling.generateTree(world, abovePos, saplingState, random);
            }
        }
    }
}

