/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.multipart;

import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.common.multipart.FluidPipeMultiPart;
import gregtech.common.multipart.GTMultipartFactory;
import gregtech.common.pipelike.fluidpipe.FluidPipeProperties;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipeActive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;

public class FluidPipeActiveMultiPart
extends FluidPipeMultiPart
implements ITickable {
    private boolean isActivePart;

    FluidPipeActiveMultiPart() {
    }

    public FluidPipeActiveMultiPart(IPipeTile<FluidPipeType, FluidPipeProperties> sourceTile) {
        super(sourceTile);
    }

    public boolean isActivePart() {
        return this.isActivePart;
    }

    @Override
    public void transferDataFrom(IPipeTile<FluidPipeType, FluidPipeProperties> sourceTile) {
        super.transferDataFrom(sourceTile);
        if (sourceTile instanceof TileEntityFluidPipeActive) {
            this.setActivePart(((TileEntityFluidPipeActive)sourceTile).isActive());
        } else if (sourceTile instanceof FluidPipeActiveMultiPart) {
            this.setActivePart(((FluidPipeActiveMultiPart)sourceTile).isActivePart());
        }
    }

    public void setActivePart(boolean activePart) {
        this.isActivePart = activePart;
    }

    @Override
    public ResourceLocation getType() {
        return GTMultipartFactory.FLUID_PIPE_ACTIVE_PART_KEY;
    }

    public void func_73660_a() {
        this.getCoverableImplementation().update();
        if (this.isActivePart) {
            TileEntityFluidPipeActive.pushFluidsFromTank(this);
        }
    }

    @Override
    public boolean supportsTicking() {
        return true;
    }

    @Override
    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74757_a("ActiveNode", this.isActivePart);
    }

    @Override
    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.isActivePart = tag.func_74767_n("ActiveNode");
    }
}

