/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.toolitem.ToolMetaItem;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.loaders.oreprocessing.ToolRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class ToolPartsBoxBehavior
implements IItemBehaviour {
    @Override
    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        List<ItemStack> components = ToolMetaItem.getToolComponents(itemStack);
        ArrayList<ItemStack> actualComponents = new ArrayList<ItemStack>();
        Random random = new Random();
        for (ItemStack componentStack : components) {
            int restoreChance = ToolPartsBoxBehavior.getItemRestoreChance(componentStack);
            if (random.nextInt(100) < 100 - restoreChance) continue;
            actualComponents.add(componentStack);
        }
        int emptyPlayerSlots = 0;
        NonNullList allStacks = player.field_71071_by.field_70462_a;
        for (ItemStack inventoryStack : allStacks) {
            if (!inventoryStack.func_190926_b()) continue;
            ++emptyPlayerSlots;
        }
        if (actualComponents.size() > emptyPlayerSlots) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStack);
        }
        for (ItemStack componentStack : actualComponents) {
            player.field_71071_by.func_70441_a(componentStack);
        }
        itemStack.func_190918_g(1);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
    }

    private static int getItemRestoreChance(ItemStack itemStack) {
        MetaItem metaItem;
        Object metaValueItem;
        if (itemStack.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) {
            return 100;
        }
        if (itemStack.func_77973_b() instanceof MetaItem && ArrayUtils.contains((Object[])ToolRecipeHandler.motorItems, metaValueItem = (metaItem = (MetaItem)itemStack.func_77973_b()).getItem(itemStack))) {
            return 100;
        }
        OrePrefix orePrefix = OreDictUnifier.getPrefix(itemStack);
        if (orePrefix != null) {
            String orePrefixName = orePrefix.name();
            if (orePrefix == OrePrefix.circuit) {
                return 100;
            }
            if (orePrefixName.startsWith("wireGt") || orePrefixName.startsWith("cableGt")) {
                return 92;
            }
            if (orePrefixName.startsWith("toolHead")) {
                return 9;
            }
        }
        return 37;
    }
}

