/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.impl.ItemHandlerDelegate;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.PhantomSlotWidget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TextFieldWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverItemFilter;
import gregtech.common.covers.CoverOreDictionaryFilter;
import gregtech.common.items.MetaItems;
import java.util.Arrays;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class CoverConveyor
extends CoverBehavior
implements CoverWithUI,
ITickable {
    public final int tier;
    public final int maxItemTransferRate;
    protected int transferRate;
    protected ConveyorMode conveyorMode;
    protected final ItemStackHandler filterTypeInventory;
    protected FilterType filterMode;
    protected String oreDictionaryFilter;
    protected ItemStackHandler itemFilterSlots;
    protected boolean ignoreDamage = true;
    protected boolean ignoreNBTData = true;
    protected int itemsLeftToTransferLastSecond;
    private CoverableItemHandlerWrapper itemHandlerWrapper;

    public CoverConveyor(ICoverable coverable, EnumFacing attachedSide, int tier, int itemsPerSecond) {
        super(coverable, attachedSide);
        this.tier = tier;
        this.itemsLeftToTransferLastSecond = this.transferRate = (this.maxItemTransferRate = itemsPerSecond);
        this.conveyorMode = ConveyorMode.EXPORT;
        this.filterTypeInventory = new FilterItemStackHandler();
        this.filterMode = FilterType.NONE;
        this.oreDictionaryFilter = "";
        this.itemFilterSlots = new ItemStackHandler(9){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    protected void setTransferRate(int transferRate) {
        this.transferRate = transferRate;
        this.coverHolder.markDirty();
    }

    protected void adjustTransferRate(int amount) {
        this.setTransferRate(MathHelper.func_76125_a((int)(this.transferRate + amount), (int)1, (int)this.maxItemTransferRate));
    }

    protected void setConveyorMode(ConveyorMode conveyorMode) {
        this.conveyorMode = conveyorMode;
        this.coverHolder.markDirty();
    }

    protected void setIgnoreDamage(boolean ignoreDamage) {
        this.ignoreDamage = ignoreDamage;
        this.coverHolder.markDirty();
    }

    protected void setIgnoreNBTData(boolean ignoreNBTData) {
        this.ignoreNBTData = ignoreNBTData;
        this.coverHolder.markDirty();
    }

    protected void setOreDictionaryFilter(String filter) {
        this.oreDictionaryFilter = filter;
        this.coverHolder.markDirty();
    }

    public void func_73660_a() {
        this.doTransferAny();
    }

    protected void doTransferAny() {
        long timer = this.coverHolder.getTimer();
        if (timer % 5L == 0L && this.itemsLeftToTransferLastSecond > 0) {
            int[] itemsTransfer = this.doTransferItems(this.itemsLeftToTransferLastSecond, null, false);
            int totalTransferred = 0;
            for (int value : itemsTransfer) {
                totalTransferred += value;
            }
            this.itemsLeftToTransferLastSecond -= totalTransferred;
        }
        if (timer % 20L == 0L) {
            this.itemsLeftToTransferLastSecond = this.transferRate;
        }
    }

    protected int[] doTransferItems(int maxTransferAmount, int[] transferLimit, boolean simulate) {
        TileEntity tileEntity = this.coverHolder.getWorld().func_175625_s(this.coverHolder.getPos().func_177972_a(this.attachedSide));
        IItemHandler itemHandler = tileEntity == null ? null : (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.attachedSide.func_176734_d());
        IItemHandler myItemHandler = (IItemHandler)this.coverHolder.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.attachedSide);
        if (itemHandler == null || myItemHandler == null) {
            return new int[this.filterMode.maxMatchSlots];
        }
        return this.doTransferItemsInternal(itemHandler, myItemHandler, maxTransferAmount, transferLimit, simulate);
    }

    protected int[] doTransferItemsInternal(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount, int[] transferLimit, boolean simulate) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.moveInventoryItems(itemHandler, myItemHandler, simulate, transferLimit, maxTransferAmount);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.moveInventoryItems(myItemHandler, itemHandler, simulate, transferLimit, maxTransferAmount);
        }
        return new int[this.filterMode.maxMatchSlots];
    }

    protected int[] doCountDestinationInventoryItems(IItemHandler itemHandler, IItemHandler myItemHandler) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.countInventoryItems(myItemHandler);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.countInventoryItems(itemHandler);
        }
        return new int[this.filterMode.maxMatchSlots];
    }

    protected int[] moveInventoryItems(IItemHandler sourceInventory, IItemHandler targetInventory, boolean simulate, int[] transferLimit, int maxTransferAmount) {
        int itemsLeftToTransfer = maxTransferAmount;
        int[] itemTypesLeftToTransfer = transferLimit == null ? null : Arrays.copyOf(transferLimit, transferLimit.length);
        int[] itemsTransfer = new int[this.filterMode.maxMatchSlots];
        for (int srcIndex = 0; srcIndex < sourceInventory.getSlots(); ++srcIndex) {
            int transferSlotIndex;
            ItemStack sourceStack = sourceInventory.extractItem(srcIndex, itemsLeftToTransfer, true);
            if (sourceStack.func_190926_b() || (transferSlotIndex = this.filterMode.matcher.apply(this, sourceStack).intValue()) == -1) continue;
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)sourceStack, (boolean)true);
            int amountToInsert = sourceStack.func_190916_E() - remainder.func_190916_E();
            if (itemTypesLeftToTransfer != null) {
                amountToInsert = Math.min(amountToInsert, itemTypesLeftToTransfer[transferSlotIndex]);
            }
            if (amountToInsert <= 0 || (sourceStack = sourceInventory.extractItem(srcIndex, amountToInsert, simulate)).func_190926_b()) continue;
            if (!simulate) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)sourceStack, (boolean)false);
            }
            itemsLeftToTransfer -= sourceStack.func_190916_E();
            int n = transferSlotIndex;
            itemsTransfer[n] = itemsTransfer[n] + sourceStack.func_190916_E();
            if (itemTypesLeftToTransfer != null) {
                int n2 = transferSlotIndex;
                itemTypesLeftToTransfer[n2] = itemTypesLeftToTransfer[n2] - sourceStack.func_190916_E();
            }
            if (itemsLeftToTransfer == 0) break;
        }
        return itemsTransfer;
    }

    protected int[] countInventoryItems(IItemHandler inventory) {
        int[] itemsCount = new int[this.filterMode.maxMatchSlots];
        for (int srcIndex = 0; srcIndex < inventory.getSlots(); ++srcIndex) {
            int transferSlotIndex;
            ItemStack itemStack = inventory.getStackInSlot(srcIndex);
            if (itemStack.func_190926_b() || (transferSlotIndex = this.filterMode.matcher.apply(this, itemStack).intValue()) == -1) continue;
            int n = transferSlotIndex;
            itemsCount[n] = itemsCount[n] + itemStack.func_190916_E();
        }
        return itemsCount;
    }

    @Override
    public boolean canAttach() {
        return this.coverHolder.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.attachedSide) != null;
    }

    @Override
    public void onRemoved() {
        NonNullList drops = NonNullList.func_191196_a();
        MetaTileEntity.clearInventory((NonNullList<ItemStack>)drops, (IItemHandlerModifiable)this.filterTypeInventory);
        for (ItemStack itemStack : drops) {
            Block.func_180635_a((World)this.coverHolder.getWorld(), (BlockPos)this.coverHolder.getPos(), (ItemStack)itemStack);
        }
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox) {
        Textures.CONVEYOR_OVERLAY.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    protected void onFilterModeUpdated() {
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!this.coverHolder.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            IItemHandler delegate = (IItemHandler)defaultValue;
            if (this.itemHandlerWrapper == null || this.itemHandlerWrapper.delegate != delegate) {
                this.itemHandlerWrapper = new CoverableItemHandlerWrapper(delegate);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandlerWrapper);
        }
        return defaultValue;
    }

    protected String getUITitle() {
        return "cover.conveyor.title";
    }

    protected WidgetGroup buildPrimaryUIGroup() {
        WidgetGroup primaryGroup = new WidgetGroup();
        primaryGroup.addWidget(new LabelWidget(10, 5, this.getUITitle(), GTValues.VN[this.tier]));
        primaryGroup.addWidget(new ClickButtonWidget(10, 20, 20, 20, "-10", data -> this.adjustTransferRate(data.isShiftClick ? -100 : -10)));
        primaryGroup.addWidget(new ClickButtonWidget(146, 20, 20, 20, "+10", data -> this.adjustTransferRate(data.isShiftClick ? 100 : 10)));
        primaryGroup.addWidget(new ClickButtonWidget(30, 20, 20, 20, "-1", data -> this.adjustTransferRate(data.isShiftClick ? -5 : -1)));
        primaryGroup.addWidget(new ClickButtonWidget(126, 20, 20, 20, "+1", data -> this.adjustTransferRate(data.isShiftClick ? 5 : 1)));
        primaryGroup.addWidget(new ImageWidget(50, 20, 76, 20, GuiTextures.DISPLAY));
        primaryGroup.addWidget(new SimpleTextWidget(88, 30, "cover.conveyor.transfer_rate", 0xFFFFFF, () -> Integer.toString(this.transferRate)));
        primaryGroup.addWidget(new CycleButtonWidget(10, 45, 75, 20, GTUtility.mapToString(ConveyorMode.values(), it -> it.localeName), () -> this.conveyorMode.ordinal(), newMode -> this.setConveyorMode(ConveyorMode.values()[newMode])));
        primaryGroup.addWidget(new LabelWidget(10, 70, "cover.conveyor.item_filter.title", new Object[0]));
        primaryGroup.addWidget(new SlotWidget((IItemHandlerModifiable)this.filterTypeInventory, 0, 10, 85).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.FILTER_SLOT_OVERLAY));
        return primaryGroup;
    }

    protected ModularUI buildUI(ModularUI.Builder builder, EntityPlayer player) {
        return builder.build(this, player);
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup primaryGroup = this.buildPrimaryUIGroup();
        ServerWidgetGroup itemFilterGroup = new ServerWidgetGroup(() -> this.filterMode == FilterType.ITEM_FILTER);
        for (int i = 0; i < 9; ++i) {
            itemFilterGroup.addWidget(new PhantomSlotWidget((IItemHandlerModifiable)this.itemFilterSlots, i, 10 + 18 * (i % 3), 106 + 18 * (i / 3)).setBackgroundTexture(GuiTextures.SLOT));
        }
        itemFilterGroup.addWidget(new ToggleButtonWidget(74, 105, 20, 20, GuiTextures.BUTTON_FILTER_DAMAGE, () -> this.ignoreDamage, this::setIgnoreDamage));
        itemFilterGroup.addWidget(new ToggleButtonWidget(99, 105, 20, 20, GuiTextures.BUTTON_FILTER_NBT, () -> this.ignoreNBTData, this::setIgnoreNBTData));
        ServerWidgetGroup oreDictFilterGroup = new ServerWidgetGroup(() -> this.filterMode == FilterType.ORE_DICTIONARY_FILTER);
        oreDictFilterGroup.addWidget(new LabelWidget(10, 106, "cover.ore_dictionary_filter.title1", new Object[0]));
        oreDictFilterGroup.addWidget(new LabelWidget(10, 116, "cover.ore_dictionary_filter.title2", new Object[0]));
        oreDictFilterGroup.addWidget(new TextFieldWidget(10, 126, 100, 12, true, () -> this.oreDictionaryFilter, this::setOreDictionaryFilter).setMaxStringLength(64).setValidator(str -> CoverOreDictionaryFilter.ORE_DICTIONARY_FILTER.matcher((CharSequence)str).matches()));
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND_EXTENDED, 176, 198).widget(primaryGroup).widget(itemFilterGroup).widget(oreDictFilterGroup).bindPlayerHotbar(player.field_71071_by, GuiTextures.SLOT, 8, 170);
        return this.buildUI(builder, player);
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferRate", this.transferRate);
        tagCompound.func_74768_a("ConveyorMode", this.conveyorMode.ordinal());
        tagCompound.func_74782_a("FilterInventory", (NBTBase)this.filterTypeInventory.serializeNBT());
        tagCompound.func_74782_a("ItemFilter", (NBTBase)this.itemFilterSlots.serializeNBT());
        tagCompound.func_74778_a("OreDictionaryFilter", this.oreDictionaryFilter);
        tagCompound.func_74757_a("IgnoreDamage", this.ignoreDamage);
        tagCompound.func_74757_a("IgnoreNBT", this.ignoreNBTData);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.transferRate = tagCompound.func_74762_e("TransferRate");
        this.conveyorMode = ConveyorMode.values()[tagCompound.func_74762_e("ConveyorMode")];
        this.filterTypeInventory.deserializeNBT(tagCompound.func_74775_l("FilterInventory"));
        this.itemFilterSlots.deserializeNBT(tagCompound.func_74775_l("ItemFilter"));
        this.oreDictionaryFilter = tagCompound.func_74779_i("OreDictionaryFilter");
        this.ignoreDamage = tagCompound.func_74767_n("IgnoreDamage");
        this.ignoreNBTData = tagCompound.func_74767_n("IgnoreNBT");
    }

    private class CoverableItemHandlerWrapper
    extends ItemHandlerDelegate {
        public CoverableItemHandlerWrapper(IItemHandler delegate) {
            super(delegate);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (CoverConveyor.this.conveyorMode == ConveyorMode.EXPORT) {
                return stack;
            }
            if (CoverConveyor.this.filterMode.matcher.apply(CoverConveyor.this, stack) == -1) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (CoverConveyor.this.conveyorMode == ConveyorMode.IMPORT) {
                return ItemStack.field_190927_a;
            }
            ItemStack resultStack = super.extractItem(slot, amount, true);
            if (CoverConveyor.this.filterMode.matcher.apply(CoverConveyor.this, resultStack) == -1) {
                return ItemStack.field_190927_a;
            }
            if (!simulate) {
                super.extractItem(slot, amount, false);
            }
            return resultStack;
        }
    }

    private class FilterItemStackHandler
    extends ItemStackHandler {
        public FilterItemStackHandler() {
            super(1);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!MetaItems.ITEM_FILTER.isItemEqual(stack) && !MetaItems.ORE_DICTIONARY_FILTER.isItemEqual(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onLoad() {
            this.onContentsChanged(0);
        }

        protected void onContentsChanged(int slot) {
            ItemStack itemStack = this.getStackInSlot(slot);
            CoverConveyor.this.filterMode = this.getFilterMode(itemStack);
            CoverConveyor.this.onFilterModeUpdated();
        }

        private FilterType getFilterMode(ItemStack itemStack) {
            if (itemStack.func_190926_b()) {
                return FilterType.NONE;
            }
            if (MetaItems.ITEM_FILTER.isItemEqual(itemStack)) {
                return FilterType.ITEM_FILTER;
            }
            if (MetaItems.ORE_DICTIONARY_FILTER.isItemEqual(itemStack)) {
                return FilterType.ORE_DICTIONARY_FILTER;
            }
            return FilterType.NONE;
        }
    }

    public static enum FilterType {
        NONE(1, (it, stack) -> 0),
        ITEM_FILTER(9, (it, stack) -> CoverItemFilter.itemFilterMatch((IItemHandler)it.itemFilterSlots, it.ignoreDamage, it.ignoreNBTData, stack)),
        ORE_DICTIONARY_FILTER(1, (it, stack) -> CoverOreDictionaryFilter.oreDictionaryFilterMatch(it.oreDictionaryFilter, stack));

        public final BiFunction<CoverConveyor, ItemStack, Integer> matcher;
        public final int maxMatchSlots;

        private FilterType(int maxMatchSlots, BiFunction<CoverConveyor, ItemStack, Integer> matcher) {
            this.maxMatchSlots = maxMatchSlots;
            this.matcher = matcher;
        }
    }

    public static enum ConveyorMode {
        IMPORT("cover.conveyor.mode.import"),
        EXPORT("cover.conveyor.mode.export");

        public final String localeName;

        private ConveyorMode(String localeName) {
            this.localeName = localeName;
        }
    }
}

