/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.crafttweaker.CTRecipeBuilder;
import gregtech.api.recipes.recipes.PrimitiveBlastFurnaceRecipe;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.api.util.ValidationResult;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.recipe.PBFRecipeBuilder")
@ZenRegister
public class PBFRecipeBuilder {
    private CountableIngredient input;
    private ItemStack output;
    private int duration = -1;
    private int fuelAmount = -1;

    private PBFRecipeBuilder() {
    }

    @ZenMethod
    public static PBFRecipeBuilder start() {
        return new PBFRecipeBuilder();
    }

    public PBFRecipeBuilder input(Ingredient input, int amount) {
        this.input = new CountableIngredient(input, amount);
        return this;
    }

    public PBFRecipeBuilder input(ItemStack itemStack) {
        this.input = CountableIngredient.from(itemStack);
        return this;
    }

    public PBFRecipeBuilder input(OrePrefix orePrefix, Material material) {
        this.input = CountableIngredient.from(orePrefix, material);
        return this;
    }

    public PBFRecipeBuilder input(OrePrefix orePrefix, Material material, int amount) {
        this.input = CountableIngredient.from(orePrefix, material, amount);
        return this;
    }

    @ZenMethod
    public PBFRecipeBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    @ZenMethod
    public PBFRecipeBuilder fuelAmount(int fuelAmount) {
        this.fuelAmount = fuelAmount;
        return this;
    }

    public PBFRecipeBuilder output(ItemStack output) {
        this.output = output;
        return this;
    }

    public ValidationResult<PrimitiveBlastFurnaceRecipe> build() {
        return ValidationResult.newResult(this.validate(), new PrimitiveBlastFurnaceRecipe(this.input, this.output, this.duration, this.fuelAmount));
    }

    protected EnumValidationResult validate() {
        EnumValidationResult result = EnumValidationResult.VALID;
        if (this.input == null) {
            GTLog.logger.error("Input Ingredient cannot be null", (Throwable)new IllegalArgumentException());
            result = EnumValidationResult.INVALID;
        }
        if (this.output == null || this.output.func_190926_b()) {
            GTLog.logger.error("Output ItemStack cannot be null or empty", (Throwable)new IllegalArgumentException());
            result = EnumValidationResult.INVALID;
        }
        if (this.fuelAmount <= 0) {
            GTLog.logger.error("FuelAmount cannot be less or equal to 0", (Throwable)new IllegalArgumentException());
            result = EnumValidationResult.INVALID;
        }
        if (this.duration <= 0) {
            GTLog.logger.error("Duration cannot be less or equal to 0", (Throwable)new IllegalArgumentException());
            result = EnumValidationResult.INVALID;
        }
        return result;
    }

    @ZenMethod
    public void buildAndRegister() {
        ValidationResult<PrimitiveBlastFurnaceRecipe> result = this.build();
        if (result.getType() == EnumValidationResult.VALID) {
            PrimitiveBlastFurnaceRecipe recipe = result.getResult();
            RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.add(recipe);
        }
    }

    @ZenMethod
    @Optional.Method(modid="crafttweaker")
    public PBFRecipeBuilder input(IIngredient ingredient) {
        return this.input(new CTRecipeBuilder.CraftTweakerIngredientWrapper(ingredient), ingredient.getAmount());
    }

    @ZenMethod
    @Optional.Method(modid="crafttweaker")
    public PBFRecipeBuilder output(IItemStack itemStack) {
        return this.output(CraftTweakerMC.getItemStack((IItemStack)itemStack));
    }
}

