/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.block;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.block.BuiltInRenderBlock;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.ICoverable;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.unification.stack.SimpleItemStack;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public abstract class BlockPipe<PipeType extends Enum<PipeType>, NodeDataType, WorldPipeNetType extends WorldPipeNet<NodeDataType, ? extends PipeNet<NodeDataType>>>
extends BuiltInRenderBlock
implements ITileEntityProvider {
    protected ThreadLocal<IPipeTile<PipeType, NodeDataType>> tileEntities = new ThreadLocal();

    public BlockPipe() {
        super(Material.field_151573_f);
        this.func_149663_c("pipe");
        this.func_149647_a(GregTechAPI.TAB_GREGTECH);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(3.0f);
        this.func_149713_g(1);
        this.func_149649_H();
    }

    public abstract Class<PipeType> getPipeTypeClass();

    public abstract WorldPipeNetType getWorldPipeNet(World var1);

    public abstract int getActiveNodeConnections(IBlockAccess var1, BlockPos var2);

    public abstract TileEntityPipeBase<PipeType, NodeDataType> createNewTileEntity(boolean var1);

    public NodeDataType createProperties(IPipeTile<PipeType, NodeDataType> pipeTile) {
        PipeType pipeType = pipeTile.getPipeType();
        gregtech.api.unification.material.type.Material material = pipeTile.getPipeMaterial();
        if (pipeType == null || material == null) {
            return this.getFallbackType();
        }
        return this.createProperties(pipeTile.getPipeType(), pipeTile.getPipeMaterial());
    }

    public NodeDataType createItemProperties(ItemStack itemStack) {
        PipeType pipeType = this.getItemPipeType(itemStack);
        gregtech.api.unification.material.type.Material material = this.getItemMaterial(itemStack);
        if (pipeType == null || material == null) {
            return this.getFallbackType();
        }
        return this.createProperties(pipeType, material);
    }

    protected abstract NodeDataType createProperties(PipeType var1, gregtech.api.unification.material.type.Material var2);

    protected abstract NodeDataType getFallbackType();

    public ItemStack getDropItem(IPipeTile<PipeType, NodeDataType> pipeTile) {
        return this.getItem(pipeTile.getPipeType(), pipeTile.getPipeMaterial());
    }

    public ItemStack getItem(PipeType pipeType, gregtech.api.unification.material.type.Material material) {
        if (pipeType == null || material == null) {
            return ItemStack.field_190927_a;
        }
        int materialId = gregtech.api.unification.material.type.Material.MATERIAL_REGISTRY.getIDForObject(material);
        return new ItemStack((Block)this, 1, ((Enum)pipeType).ordinal() * 1000 + materialId);
    }

    public PipeType getItemPipeType(ItemStack itemStack) {
        return (PipeType)((Enum[])this.getPipeTypeClass().getEnumConstants())[itemStack.func_77960_j() / 1000];
    }

    public gregtech.api.unification.material.type.Material getItemMaterial(ItemStack itemStack) {
        return gregtech.api.unification.material.type.Material.MATERIAL_REGISTRY.getObjectById(itemStack.func_77960_j() % 1000);
    }

    public void setTileEntityData(IPipeTile<PipeType, NodeDataType> pipeTile, ItemStack itemStack) {
        pipeTile.setPipeType(this.getItemPipeType(itemStack));
        pipeTile.setPipeMaterial(this.getItemMaterial(itemStack));
    }

    public abstract void func_149666_a(CreativeTabs var1, NonNullList<ItemStack> var2);

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile != null && !((TileEntityPipeBase)pipeTile).isBeingConverted()) {
            pipeTile.getCoverableImplementation().dropAllCovers();
        }
        super.func_180663_b(worldIn, pos, state);
        ((WorldPipeNet)((Object)this.getWorldPipeNet(worldIn))).removeNode(pos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, 1);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile != null) {
            int activeConnections = this.getActiveNodeConnections((IBlockAccess)worldIn, pos);
            boolean isActiveNode = (activeConnections &= ~pipeTile.getBlockedConnections()) > 0;
            ((WorldPipeNet)((Object)this.getWorldPipeNet(worldIn))).addNode(pos, this.createProperties(pipeTile), 0, pipeTile.getBlockedConnections(), isActiveNode);
            this.onActiveModeChange(worldIn, pos, isActiveNode, true);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile != null) {
            this.setTileEntityData(pipeTile, stack);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.updateActiveNodeStatus(worldIn, pos);
    }

    public void updateActiveNodeStatus(World worldIn, BlockPos pos) {
        Object pipeNet = ((WorldPipeNet)((Object)this.getWorldPipeNet(worldIn))).getNetFromPos(pos);
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeNet != null && pipeTile != null) {
            int activeConnections = this.getActiveNodeConnections((IBlockAccess)worldIn, pos);
            boolean isActiveNodeNow = (activeConnections &= ~pipeTile.getBlockedConnections()) > 0;
            boolean modeChanged = ((PipeNet)pipeNet).markNodeAsActive(pos, isActiveNodeNow);
            if (modeChanged) {
                this.onActiveModeChange(worldIn, pos, isActiveNodeNow, false);
            }
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return this.createNewTileEntity(false);
    }

    protected void onActiveModeChange(World world, BlockPos pos, boolean isActiveNow, boolean isInitialChange) {
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)world, pos);
        if (pipeTile == null) {
            return ItemStack.field_190927_a;
        }
        if (target instanceof CuboidRayTraceResult) {
            CuboidRayTraceResult result = (CuboidRayTraceResult)target;
            if (result.cuboid6.data == null) {
                return this.getDropItem(pipeTile);
            }
            if (result.cuboid6.data instanceof EnumFacing) {
                EnumFacing coverSide = (EnumFacing)result.cuboid6.data;
                CoverBehavior coverBehavior = pipeTile.getCoverableImplementation().getCoverAtSide(coverSide);
                return coverBehavior == null ? ItemStack.field_190927_a : coverBehavior.getCoverDefinition().getDropItemStack();
            }
        }
        return this.getDropItem(pipeTile);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        SimpleItemStack simpleItemStack;
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile == null) {
            return false;
        }
        CuboidRayTraceResult rayTraceResult = (CuboidRayTraceResult)RayTracer.retraceBlock((World)worldIn, (EntityPlayer)playerIn, (BlockPos)pos);
        EnumFacing coverSide = ICoverable.traceCoverSide((RayTraceResult)rayTraceResult);
        if (coverSide == null) {
            return false;
        }
        CoverBehavior coverBehavior = pipeTile.getCoverableImplementation().getCoverAtSide(coverSide);
        if (coverBehavior == null) {
            return false;
        }
        ItemStack itemInHand = playerIn.func_184586_b(hand);
        SimpleItemStack simpleItemStack2 = simpleItemStack = itemInHand.func_190926_b() ? null : new SimpleItemStack(itemInHand);
        if (simpleItemStack != null && GregTechAPI.screwdriverList.contains(simpleItemStack)) {
            if (GTUtility.doDamageItem(itemInHand, 2, true) && coverBehavior.onScrewdriverClick(playerIn, hand, rayTraceResult) == EnumActionResult.SUCCESS) {
                GTUtility.doDamageItem(itemInHand, 2, false);
                return true;
            }
            return false;
        }
        return coverBehavior.onRightClick(playerIn, hand, rayTraceResult) == EnumActionResult.SUCCESS;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        EnumFacing coverSide;
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile == null) {
            return;
        }
        CuboidRayTraceResult rayTraceResult = (CuboidRayTraceResult)RayTracer.retraceBlock((World)worldIn, (EntityPlayer)playerIn, (BlockPos)pos);
        EnumFacing enumFacing = coverSide = rayTraceResult == null ? null : ICoverable.traceCoverSide((RayTraceResult)rayTraceResult);
        if (coverSide == null) {
            return;
        }
        CoverBehavior coverBehavior = pipeTile.getCoverableImplementation().getCoverAtSide(coverSide);
        if (coverBehavior == null) {
            return;
        }
        coverBehavior.onLeftClick(playerIn, rayTraceResult);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        this.tileEntities.set(te == null ? null : (IPipeTile)te);
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        this.tileEntities.set(null);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        IPipeTile<PipeType, NodeDataType> pipeTile;
        IPipeTile<PipeType, NodeDataType> iPipeTile = pipeTile = this.tileEntities.get() == null ? this.getPipeTileEntity(world, pos) : this.tileEntities.get();
        if (pipeTile == null) {
            return;
        }
        drops.add((Object)this.getDropItem(pipeTile));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        for (Cuboid6 cuboid6 : this.getCollisionBox((IBlockAccess)worldIn, pos, state)) {
            AxisAlignedBB offsetBox = cuboid6.aabb().func_186670_a(pos);
            if (!offsetBox.func_72326_a(entityBox)) continue;
            collidingBoxes.add(offsetBox);
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        return RayTracer.rayTraceCuboidsClosest((Vec3d)start, (Vec3d)end, (BlockPos)pos, this.getCollisionBox((IBlockAccess)worldIn, pos, blockState));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        IPipeTile tileEntityPipe = (IPipeTile)world.func_175625_s(pos);
        if (tileEntityPipe != null && tileEntityPipe.getPipeType() != null && ((IPipeType)tileEntityPipe.getPipeType()).isPaintable() && tileEntityPipe.getInsulationColor() != color.field_193351_w) {
            tileEntityPipe.setInsulationColor(color.field_193351_w);
            return true;
        }
        return false;
    }

    private boolean isThisPipeBlock(Block block) {
        return block.getClass().isAssignableFrom(this.getClass());
    }

    public IPipeTile<PipeType, NodeDataType> getPipeTileEntity(IBlockAccess world, BlockPos selfPos) {
        TileEntity tileEntityAtPos = world.func_175625_s(selfPos);
        return this.getPipeTileEntity(tileEntityAtPos);
    }

    public IPipeTile<PipeType, NodeDataType> getPipeTileEntity(TileEntity tileEntityAtPos) {
        if (tileEntityAtPos instanceof IPipeTile && this.isThisPipeBlock(((IPipeTile)tileEntityAtPos).getPipeBlock())) {
            return (IPipeTile)tileEntityAtPos;
        }
        if (GTValues.isModLoaded("forgemultipartcbe")) {
            return this.tryGetMultipartTile(tileEntityAtPos);
        }
        return null;
    }

    @Optional.Method(modid="forgemultipartcbe")
    private IPipeTile<PipeType, NodeDataType> tryGetMultipartTile(TileEntity tileEntityAtPos) {
        if (tileEntityAtPos instanceof TileMultipart) {
            TileMultipart tileMultipart = (TileMultipart)tileEntityAtPos;
            List partList = tileMultipart.jPartList();
            for (TMultiPart multiPart : partList) {
                IPipeTile pipePart;
                if (!(multiPart instanceof IPipeTile) || !this.isThisPipeBlock((pipePart = (IPipeTile)multiPart).getPipeBlock())) continue;
                return pipePart;
            }
        }
        return null;
    }

    protected final int isPipeAccessibleAtSide(IBlockAccess world, IPipeTile<PipeType, NodeDataType> selfTile, EnumFacing side) {
        IPipeTile<PipeType, NodeDataType> tileEntityPipe = this.getPipeTileEntity(world, selfTile.getPipePos().func_177972_a(side));
        if (tileEntityPipe == null) {
            return 0;
        }
        if ((tileEntityPipe.getBlockedConnections() & 1 << side.func_176734_d().func_176745_a()) > 0 || (selfTile.getBlockedConnections() & 1 << side.func_176745_a()) > 0) {
            return 1;
        }
        int insulationColor = selfTile.getInsulationColor();
        if (insulationColor != 0x777777 && tileEntityPipe.getInsulationColor() != 0x777777 && insulationColor != tileEntityPipe.getInsulationColor()) {
            return 1;
        }
        if (!this.canPipesConnect(selfTile, side, tileEntityPipe)) {
            return 1;
        }
        PipeType otherPipeType = tileEntityPipe.getPipeType();
        PipeType myPipeType = selfTile.getPipeType();
        if (otherPipeType == null || myPipeType == null) {
            return 0;
        }
        return ((IPipeType)myPipeType).getThickness() > ((IPipeType)otherPipeType).getThickness() ? 3 : 2;
    }

    protected boolean canPipesConnect(IPipeTile<PipeType, NodeDataType> selfTile, EnumFacing side, IPipeTile<PipeType, NodeDataType> sideTile) {
        return true;
    }

    public int getActualConnections(IPipeTile<PipeType, NodeDataType> selfTile, IBlockAccess world) {
        int connectedSidesMask = 0;
        int activeNodeConnections = this.getActiveNodeConnections(world, selfTile.getPipePos());
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (selfTile.getCoverableImplementation().getCoverAtSide(side) != null) {
                connectedSidesMask |= 1 << side.func_176745_a();
            }
            if ((selfTile.getBlockedConnections() & 1 << side.func_176745_a()) > 0) continue;
            int cableState = this.isPipeAccessibleAtSide(world, selfTile, side);
            if (cableState >= 2) {
                connectedSidesMask |= 1 << side.func_176745_a();
                if (cableState < 3) continue;
                connectedSidesMask |= 1 << 6 + side.func_176745_a();
                continue;
            }
            if (cableState != 0 || (activeNodeConnections & 1 << side.func_176745_a()) <= 0) continue;
            connectedSidesMask |= 1 << side.func_176745_a();
            connectedSidesMask |= 1 << 6 + side.func_176745_a();
        }
        return connectedSidesMask;
    }

    private List<IndexedCuboid6> getCollisionBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity(world, pos);
        if (pipeTile == null) {
            return Collections.emptyList();
        }
        PipeType pipeType = pipeTile.getPipeType();
        if (pipeType == null) {
            return Collections.emptyList();
        }
        int actualConnections = this.getActualConnections(pipeTile, world);
        float thickness = ((IPipeType)pipeType).getThickness();
        ArrayList<IndexedCuboid6> result = new ArrayList<IndexedCuboid6>();
        result.add(new IndexedCuboid6(null, BlockPipe.getSideBox(null, thickness)));
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if ((actualConnections & 1 << side.func_176745_a()) <= 0) continue;
            result.add(new IndexedCuboid6(null, BlockPipe.getSideBox(side, thickness)));
        }
        pipeTile.getCoverableImplementation().addCoverCollisionBoundingBox(result, false);
        return result;
    }

    public static Cuboid6 getSideBox(EnumFacing side, float thickness) {
        float min = (1.0f - thickness) / 2.0f;
        float max = min + thickness;
        if (side == null) {
            return new Cuboid6((double)min, (double)min, (double)min, (double)max, (double)max, (double)max);
        }
        if (side == EnumFacing.DOWN) {
            return new Cuboid6((double)min, 0.0, (double)min, (double)max, (double)min, (double)max);
        }
        if (side == EnumFacing.UP) {
            return new Cuboid6((double)min, (double)max, (double)min, (double)max, 1.0, (double)max);
        }
        if (side == EnumFacing.WEST) {
            return new Cuboid6(0.0, (double)min, (double)min, (double)min, (double)max, (double)max);
        }
        if (side == EnumFacing.EAST) {
            return new Cuboid6((double)max, (double)min, (double)min, 1.0, (double)max, (double)max);
        }
        if (side == EnumFacing.NORTH) {
            return new Cuboid6((double)min, (double)min, 0.0, (double)max, (double)max, (double)min);
        }
        if (side == EnumFacing.SOUTH) {
            return new Cuboid6((double)min, (double)min, (double)max, (double)max, (double)max, 1.0);
        }
        throw new IllegalArgumentException(side.toString());
    }
}

