/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.capability.impl.FluidHandlerProxy;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.DischargerSlotWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.WorkableTieredMetaTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.render.OrientedOverlayRenderer;
import gregtech.api.render.Textures;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class SimpleMachineMetaTileEntity
extends WorkableTieredMetaTileEntity {
    private ItemStackHandler chargerInventory;
    private EnumFacing outputFacing;
    private FluidHandlerProxy[] sidedTankOverrides = new FluidHandlerProxy[6];
    private boolean autoOutputItems;
    private boolean autoOutputFluids;
    private boolean hasFrontFacing;

    public SimpleMachineMetaTileEntity(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, OrientedOverlayRenderer renderer, int tier) {
        this(metaTileEntityId, recipeMap, renderer, tier, true);
    }

    public SimpleMachineMetaTileEntity(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, OrientedOverlayRenderer renderer, int tier, boolean hasFrontFacing) {
        super(metaTileEntityId, recipeMap, renderer, tier);
        this.hasFrontFacing = hasFrontFacing;
        this.chargerInventory = new ItemStackHandler(1){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new SimpleMachineMetaTileEntity(this.metaTileEntityId, this.workable.recipeMap, this.renderer, this.getTier(), this.hasFrontFacing);
    }

    @Override
    public boolean hasFrontFacing() {
        return this.hasFrontFacing;
    }

    @Override
    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af()) {
            EnumFacing currentOutputSide = this.getOutputFacing();
            if (currentOutputSide == facing || this.getFrontFacing() == facing) {
                return false;
            }
            this.setOutputFacing(facing);
            return true;
        }
        return super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.outputFacing != null) {
            Textures.PIPE_OUT_OVERLAY.renderSided(this.outputFacing, renderState, translation, pipeline);
            if (this.autoOutputItems) {
                Textures.ITEM_OUTPUT_OVERLAY.renderSided(this.outputFacing, renderState, translation, pipeline);
            }
            if (this.autoOutputFluids) {
                Textures.FLUID_OUTPUT_OVERLAY.renderSided(this.outputFacing, renderState, translation, pipeline);
            }
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            ((EnergyContainerHandler)this.energyContainer).dischargeEnergyContainers((IItemHandlerModifiable)this.chargerInventory, 0);
            if (this.getTimer() % 5L == 0L) {
                EnumFacing outputFacing = this.getOutputFacing();
                if (this.autoOutputFluids) {
                    this.pushFluidsIntoNearbyHandlers(outputFacing);
                }
                if (this.autoOutputItems) {
                    this.pushItemsIntoNearbyHandlers(outputFacing);
                }
            }
        }
    }

    public void setOutputOverride(EnumFacing side, int overrideIndex) {
        FluidTankList fluidTank = overrideIndex < 0 ? this.exportFluids : (IFluidHandler)this.exportFluids.getTankAt(overrideIndex);
        this.sidedTankOverrides[side.func_176745_a()] = new FluidHandlerProxy(this.importFluids, fluidTank);
    }

    public int getOutputOverride(EnumFacing side) {
        FluidHandlerProxy override = this.sidedTankOverrides[side.func_176745_a()];
        return override == null ? -1 : this.exportFluids.getFluidTanks().indexOf(override.output);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        FluidHandlerProxy sideOverride = side == null ? null : this.sidedTankOverrides[side.func_176745_a()];
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && sideOverride != null ? sideOverride : super.getCapability(capability, side));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("ChargerInventory", (NBTBase)this.chargerInventory.serializeNBT());
        data.func_74768_a("OutputFacing", this.getOutputFacing().func_176745_a());
        data.func_74757_a("AutoOutputItems", this.autoOutputItems);
        data.func_74757_a("AutoOutputFluids", this.autoOutputFluids);
        int[] sidedTankOverrides = new int[6];
        for (int i = 0; i < this.sidedTankOverrides.length; ++i) {
            int overrideIndex;
            FluidHandlerProxy override = this.sidedTankOverrides[i];
            sidedTankOverrides[i] = overrideIndex = override == null ? -1 : this.exportFluids.getFluidTanks().indexOf(override.output);
        }
        data.func_74783_a("SidedTankOverride", sidedTankOverrides);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.chargerInventory.deserializeNBT(data.func_74775_l("ChargerInventory"));
        this.outputFacing = EnumFacing.field_82609_l[data.func_74762_e("OutputFacing")];
        this.autoOutputItems = data.func_74767_n("AutoOutputItems");
        this.autoOutputFluids = data.func_74767_n("AutoOutputFluids");
        int[] sidedTankOverrides = data.func_74759_k("SidedTankOverride");
        for (int i = 0; i < sidedTankOverrides.length; ++i) {
            int overrideValue = sidedTankOverrides[i];
            if (overrideValue < 0) continue;
            this.setOutputOverride(EnumFacing.field_82609_l[i], overrideValue);
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeByte(this.getOutputFacing().func_176745_a());
        buf.writeBoolean(this.autoOutputItems);
        buf.writeBoolean(this.autoOutputFluids);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.outputFacing = EnumFacing.field_82609_l[buf.readByte()];
        this.autoOutputItems = buf.readBoolean();
        this.autoOutputFluids = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 100) {
            this.outputFacing = EnumFacing.field_82609_l[buf.readByte()];
            this.getHolder().scheduleChunkForRenderUpdate();
        } else if (dataId == 101) {
            this.autoOutputItems = buf.readBoolean();
            this.getHolder().scheduleChunkForRenderUpdate();
        } else if (dataId == 102) {
            this.autoOutputFluids = buf.readBoolean();
            this.getHolder().scheduleChunkForRenderUpdate();
        }
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return super.isValidFrontFacing(facing) && facing != this.outputFacing;
    }

    public void setOutputFacing(EnumFacing outputFacing) {
        this.outputFacing = outputFacing;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(100, buf -> buf.writeByte(outputFacing.func_176745_a()));
            this.markDirty();
        }
    }

    public void setAutoOutputItems(boolean autoOutputItems) {
        this.autoOutputItems = autoOutputItems;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(101, buf -> buf.writeBoolean(autoOutputItems));
            this.markDirty();
        }
    }

    public void setAutoOutputFluids(boolean autoOutputFluids) {
        this.autoOutputFluids = autoOutputFluids;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(102, buf -> buf.writeBoolean(autoOutputFluids));
            this.markDirty();
        }
    }

    @Override
    public void setFrontFacing(EnumFacing frontFacing) {
        super.setFrontFacing(frontFacing);
        if (this.outputFacing == null) {
            this.setOutputFacing(frontFacing.func_176734_d());
        }
    }

    public EnumFacing getOutputFacing() {
        return this.outputFacing == null ? EnumFacing.SOUTH : this.outputFacing;
    }

    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        super.clearMachineInventory(itemBuffer);
        SimpleMachineMetaTileEntity.clearInventory(itemBuffer, (IItemHandlerModifiable)this.chargerInventory);
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (this.exportFluids.getTanks() == 0) {
            return false;
        }
        if (this.getWorld().field_72995_K) {
            return true;
        }
        int overrideIndex = this.getOutputOverride(facing);
        if (++overrideIndex >= this.exportFluids.getTanks()) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.basic.output_override.reset", new Object[0]), true);
            this.setOutputOverride(facing, -1);
            return true;
        }
        playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.basic.output_override.set", new Object[]{overrideIndex}), true);
        this.setOutputOverride(facing, overrideIndex);
        return true;
    }

    protected ModularUI.Builder createGuiTemplate(EntityPlayer player) {
        ModularUI.Builder builder = this.workable.recipeMap.createUITemplate(this.workable::getProgressPercent, this.importItems, this.exportItems, this.importFluids, this.exportFluids).widget(new LabelWidget(5, 5, this.getMetaFullName(), new Object[0])).widget(new DischargerSlotWidget((IItemHandlerModifiable)this.chargerInventory, 0, 79, 62).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.CHARGER_OVERLAY)).widget(new ImageWidget(79, 42, 18, 18, GuiTextures.INDICATOR_NO_ENERGY).setPredicate(this.workable::isHasNotEnoughEnergy)).bindPlayerInventory(player.field_71071_by);
        int buttonStartX = 7;
        if (this.exportItems.getSlots() > 0) {
            builder.widget(new ToggleButtonWidget(buttonStartX, 62, 18, 18, GuiTextures.BUTTON_ITEM_OUTPUT, this::isAutoOutputItems, this::setAutoOutputItems));
            buttonStartX += 18;
        }
        if (this.exportFluids.getTanks() > 0) {
            builder.widget(new ToggleButtonWidget(buttonStartX, 62, 18, 18, GuiTextures.BUTTON_FLUID_OUTPUT, this::isAutoOutputFluids, this::setAutoOutputFluids));
        }
        return builder;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createGuiTemplate(entityPlayer).build(this.getHolder(), entityPlayer);
    }
}

