/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import java.util.function.DoubleSupplier;
import net.minecraft.network.PacketBuffer;

public class ProgressWidget
extends Widget {
    public final DoubleSupplier progressSupplier;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private MoveType moveType;
    private TextureArea emptyBarArea;
    private TextureArea filledBarArea;
    private double lastProgressValue;

    public ProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height) {
        this.progressSupplier = progressSupplier;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public ProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height, TextureArea fullImage, MoveType moveType) {
        this.progressSupplier = progressSupplier;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.emptyBarArea = fullImage.getSubArea(0.0, 0.0, 1.0, 0.5);
        this.filledBarArea = fullImage.getSubArea(0.0, 0.5, 1.0, 0.5);
        this.moveType = moveType;
    }

    public ProgressWidget setProgressBar(TextureArea emptyBarArea, TextureArea filledBarArea, MoveType moveType) {
        this.emptyBarArea = emptyBarArea;
        this.filledBarArea = filledBarArea;
        this.moveType = moveType;
        return this;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY) {
        if (this.emptyBarArea != null) {
            this.emptyBarArea.draw(this.x, this.y, this.width, this.height);
        }
        if (this.filledBarArea != null) {
            if (this.moveType == MoveType.HORIZONTAL) {
                this.filledBarArea.drawSubArea(this.x, this.y, (int)((double)this.width * this.lastProgressValue), this.height, 0.0, 0.0, (double)((int)((double)this.width * this.lastProgressValue)) / ((double)this.width * 1.0), 1.0);
            } else if (this.moveType == MoveType.VERTICAL) {
                int progressValueScaled = (int)((double)this.height * this.lastProgressValue);
                this.filledBarArea.drawSubArea(this.x, this.y + this.height - progressValueScaled, this.width, progressValueScaled, 0.0, 1.0 - (double)progressValueScaled / ((double)this.height * 1.0), 1.0, (double)progressValueScaled / ((double)this.height * 1.0));
            }
        }
    }

    @Override
    public void detectAndSendChanges() {
        double actualValue = this.progressSupplier.getAsDouble();
        if (Math.abs(actualValue - this.lastProgressValue) > 0.005) {
            this.lastProgressValue = actualValue;
            this.writeUpdateInfo(0, buffer -> buffer.writeDouble(actualValue));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 0) {
            this.lastProgressValue = buffer.readDouble();
        }
    }

    public static enum MoveType {
        VERTICAL,
        HORIZONTAL;

    }
}

