/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.IWorkable;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class RecipeMapWorkableHandler
extends MTETrait
implements IWorkable {
    public final RecipeMap<?> recipeMap;
    protected boolean forceRecipeRecheck;
    protected ItemStack[] lastItemInputs;
    protected FluidStack[] lastFluidInputs;
    protected Recipe previousRecipe;
    protected int progressTime;
    protected int maxProgressTime;
    protected int recipeEUt;
    protected List<FluidStack> fluidOutputs;
    protected NonNullList<ItemStack> itemOutputs;
    protected final Random random = new Random();
    private boolean isActive;
    private boolean workingEnabled = true;
    private boolean hasNotEnoughEnergy;
    private boolean wasActiveAndNeedsUpdate;

    public RecipeMapWorkableHandler(MetaTileEntity tileEntity, RecipeMap<?> recipeMap) {
        super(tileEntity);
        this.recipeMap = recipeMap;
    }

    protected abstract long getEnergyStored();

    protected abstract long getEnergyCapacity();

    protected abstract boolean drawEnergy(int var1);

    protected abstract long getMaxVoltage();

    protected IItemHandlerModifiable getInputInventory() {
        return this.metaTileEntity.getImportItems();
    }

    protected IItemHandlerModifiable getOutputInventory() {
        return this.metaTileEntity.getExportItems();
    }

    protected IMultipleTankHandler getInputTank() {
        return this.metaTileEntity.getImportFluids();
    }

    protected IMultipleTankHandler getOutputTank() {
        return this.metaTileEntity.getExportFluids();
    }

    @Override
    public String getName() {
        return "RecipeMapWorkable";
    }

    @Override
    public int getNetworkID() {
        return 2;
    }

    @Override
    public Capability<?> getImplementingCapability() {
        return GregtechCapabilities.CAPABILITY_WORKABLE;
    }

    @Override
    public void update() {
        if (!this.getMetaTileEntity().getWorld().field_72995_K) {
            if (this.workingEnabled) {
                if (this.progressTime > 0) {
                    this.updateRecipeProgress();
                }
                if (this.progressTime == 0) {
                    this.trySearchNewRecipe();
                }
            }
            if (this.wasActiveAndNeedsUpdate) {
                this.wasActiveAndNeedsUpdate = false;
                this.setActive(false);
            }
        }
    }

    private void updateRecipeProgress() {
        boolean drawEnergy = this.drawEnergy(this.recipeEUt);
        if (drawEnergy || this.recipeEUt < 0 && this.ignoreTooMuchEnergy()) {
            if (++this.progressTime >= this.maxProgressTime) {
                this.completeRecipe();
            }
        } else if (this.recipeEUt > 0) {
            this.hasNotEnoughEnergy = true;
            if (this.progressTime >= 2) {
                this.progressTime = ConfigHolder.insufficientEnergySupplyWipesRecipeProgress ? 1 : Math.max(1, this.progressTime - 2);
            }
        }
    }

    private void trySearchNewRecipe() {
        long maxVoltage = this.getMaxVoltage();
        Recipe currentRecipe = null;
        IItemHandlerModifiable importInventory = this.getInputInventory();
        IMultipleTankHandler importFluids = this.getInputTank();
        if (this.previousRecipe != null && this.previousRecipe.matches(false, importInventory, importFluids)) {
            currentRecipe = this.previousRecipe;
        } else {
            boolean dirty = this.checkRecipeInputsDirty((IItemHandler)importInventory, importFluids);
            if (dirty || this.forceRecipeRecheck) {
                this.forceRecipeRecheck = false;
                currentRecipe = this.findRecipe(maxVoltage, importInventory, importFluids);
                if (currentRecipe != null && currentRecipe.canBeBuffered()) {
                    this.previousRecipe = currentRecipe;
                }
            }
        }
        if (currentRecipe != null && this.setupAndConsumeRecipeInputs(currentRecipe)) {
            this.setupRecipe(currentRecipe);
        }
    }

    public void forceRecipeRecheck() {
        this.forceRecipeRecheck = true;
    }

    protected Recipe findRecipe(long maxVoltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
        return this.recipeMap.findRecipe(maxVoltage, inputs, fluidInputs);
    }

    protected boolean checkRecipeInputsDirty(IItemHandler inputs, IMultipleTankHandler fluidInputs) {
        ItemStack lastStack;
        ItemStack currentStack;
        int i;
        boolean shouldRecheckRecipe = false;
        if (this.lastItemInputs == null || this.lastItemInputs.length != inputs.getSlots()) {
            this.lastItemInputs = new ItemStack[inputs.getSlots()];
            Arrays.fill(this.lastItemInputs, ItemStack.field_190927_a);
        }
        if (this.lastFluidInputs == null || this.lastFluidInputs.length != fluidInputs.getTanks()) {
            this.lastFluidInputs = new FluidStack[fluidInputs.getTanks()];
        }
        for (i = 0; i < this.lastItemInputs.length; ++i) {
            currentStack = inputs.getStackInSlot(i);
            if (!ItemStack.func_179545_c((ItemStack)currentStack, (ItemStack)(lastStack = this.lastItemInputs[i])) || !ItemStack.func_77970_a((ItemStack)currentStack, (ItemStack)lastStack)) {
                this.lastItemInputs[i] = currentStack.func_190926_b() ? ItemStack.field_190927_a : currentStack.func_77946_l();
                shouldRecheckRecipe = true;
                continue;
            }
            if (currentStack.func_190916_E() == lastStack.func_190916_E()) continue;
            lastStack.func_190920_e(currentStack.func_190916_E());
            shouldRecheckRecipe = true;
        }
        for (i = 0; i < this.lastFluidInputs.length; ++i) {
            currentStack = fluidInputs.getTankAt(i).getFluid();
            lastStack = this.lastFluidInputs[i];
            if (currentStack == null && lastStack != null || currentStack != null && !currentStack.isFluidEqual((FluidStack)lastStack)) {
                this.lastFluidInputs[i] = currentStack == null ? null : currentStack.copy();
                shouldRecheckRecipe = true;
                continue;
            }
            if (currentStack == null || lastStack == null || currentStack.amount == lastStack.amount) continue;
            lastStack.amount = currentStack.amount;
            shouldRecheckRecipe = true;
        }
        return shouldRecheckRecipe;
    }

    protected boolean setupAndConsumeRecipeInputs(Recipe recipe) {
        int[] resultOverclock = this.calculateOverclock(recipe.getEUt(), this.getMaxVoltage(), this.recipeMap.getAmperage(), recipe.getDuration(), false);
        int totalEUt = resultOverclock[0] * resultOverclock[1];
        IItemHandlerModifiable importInventory = this.getInputInventory();
        IItemHandlerModifiable exportInventory = this.getOutputInventory();
        IMultipleTankHandler importFluids = this.getInputTank();
        IMultipleTankHandler exportFluids = this.getOutputTank();
        return (totalEUt >= 0 ? this.getEnergyStored() >= (long)((long)totalEUt > this.getEnergyCapacity() / 2L ? resultOverclock[0] : totalEUt) : this.ignoreTooMuchEnergy() || this.getEnergyStored() - (long)resultOverclock[0] <= this.getEnergyCapacity()) && (!recipe.needsEmptyOutput() || MetaTileEntity.isItemHandlerEmpty((IItemHandler)exportInventory)) && MetaTileEntity.addItemsToItemHandler((IItemHandler)exportInventory, true, recipe.getOutputs()) && MetaTileEntity.addFluidsToFluidHandler(exportFluids, true, recipe.getFluidOutputs()) && recipe.matches(true, importInventory, importFluids);
    }

    protected boolean ignoreTooMuchEnergy() {
        return false;
    }

    protected int[] calculateOverclock(int EUt, long voltage, long amperage, int duration, boolean consumeInputs) {
        double resultDuration;
        double durationMultiplier;
        boolean negativeEU = EUt < 0;
        EUt = (int)((long)EUt * amperage);
        int tier = this.getOverclockingTier(voltage);
        if (GTValues.V[tier] <= (long)EUt || tier == 0) {
            return new int[]{EUt, duration};
        }
        if (negativeEU) {
            EUt = -EUt;
        }
        if (EUt <= 16) {
            int multiplier = EUt <= 8 ? tier : tier - 1;
            int resultEUt = EUt * (1 << multiplier) * (1 << multiplier);
            int resultDuration2 = duration / (1 << multiplier);
            return new int[]{negativeEU ? -resultEUt : resultEUt, resultDuration2};
        }
        int resultEUt = EUt;
        double d = durationMultiplier = negativeEU ? 3.8 : 2.0;
        for (resultDuration = (double)duration; resultDuration >= durationMultiplier && (long)resultEUt <= GTValues.V[tier - 1] * amperage; resultDuration /= durationMultiplier) {
            resultEUt *= 4;
        }
        return new int[]{negativeEU ? -resultEUt : resultEUt, (int)Math.floor(resultDuration)};
    }

    protected int getOverclockingTier(long voltage) {
        return GTUtility.getTierByVoltage(voltage);
    }

    protected void setupRecipe(Recipe recipe) {
        int[] resultOverclock = this.calculateOverclock(recipe.getEUt(), this.getMaxVoltage(), this.recipeMap.getAmperage(), recipe.getDuration(), true);
        this.progressTime = 1;
        this.setMaxProgress(resultOverclock[1]);
        this.recipeEUt = resultOverclock[0];
        this.fluidOutputs = GTUtility.copyFluidList(recipe.getFluidOutputs());
        int byproductChanceMultiplier = this.getByproductChanceMultiplier(recipe);
        this.itemOutputs = GTUtility.copyStackList(recipe.getResultItemOutputs(this.random, byproductChanceMultiplier));
        if (this.wasActiveAndNeedsUpdate) {
            this.wasActiveAndNeedsUpdate = false;
        } else {
            this.setActive(true);
        }
    }

    protected int getByproductChanceMultiplier(Recipe recipe) {
        int byproductChanceMultiplier = 1;
        byte tier = GTUtility.getTierByVoltage(this.getMaxVoltage());
        byte recipeTier = GTUtility.getTierByVoltage(recipe.getEUt());
        if (tier > 1 && tier > recipeTier) {
            byproductChanceMultiplier = 1 << tier - recipeTier;
        }
        return byproductChanceMultiplier;
    }

    protected void completeRecipe() {
        MetaTileEntity.addItemsToItemHandler((IItemHandler)this.getOutputInventory(), false, this.itemOutputs);
        MetaTileEntity.addFluidsToFluidHandler(this.getOutputTank(), false, this.fluidOutputs);
        this.progressTime = 0;
        this.setMaxProgress(0);
        this.recipeEUt = 0;
        this.fluidOutputs = null;
        this.itemOutputs = null;
        this.hasNotEnoughEnergy = false;
        this.wasActiveAndNeedsUpdate = true;
        this.forceRecipeRecheck = true;
    }

    public double getProgressPercent() {
        return this.getMaxProgress() == 0 ? 0.0 : (double)this.getProgress() / ((double)this.getMaxProgress() * 1.0);
    }

    public int getTicksTimeLeft() {
        return this.maxProgressTime == 0 ? 0 : this.maxProgressTime - this.progressTime;
    }

    @Override
    public int getProgress() {
        return this.progressTime;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgressTime;
    }

    public int getRecipeEUt() {
        return this.recipeEUt;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgressTime = maxProgress;
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.metaTileEntity.markDirty();
        }
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.metaTileEntity.markDirty();
            this.writeCustomData(1, buf -> buf.writeBoolean(active));
        }
    }

    @Override
    public void increaseProgress(int progress) {
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.progressTime = Math.min(this.progressTime + progress, this.maxProgressTime);
            this.metaTileEntity.markDirty();
        }
    }

    @Override
    public boolean hasWorkToDo() {
        return this.progressTime > 0;
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.metaTileEntity.markDirty();
        }
    }

    public boolean isHasNotEnoughEnergy() {
        return this.hasNotEnoughEnergy;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        if (dataId == 1) {
            this.isActive = buf.readBoolean();
            this.getMetaTileEntity().getHolder().scheduleChunkForRenderUpdate();
        }
    }

    @Override
    public void writeInitialData(PacketBuffer buf) {
        buf.writeBoolean(this.isActive);
    }

    @Override
    public void receiveInitialData(PacketBuffer buf) {
        this.isActive = buf.readBoolean();
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("WorkEnabled", this.workingEnabled);
        if (this.progressTime > 0) {
            compound.func_74768_a("Progress", this.progressTime);
            compound.func_74768_a("MaxProgress", this.maxProgressTime);
            compound.func_74768_a("RecipeEUt", this.recipeEUt);
            NBTTagList itemOutputsList = new NBTTagList();
            for (ItemStack itemOutput : this.itemOutputs) {
                itemOutputsList.func_74742_a((NBTBase)itemOutput.func_77955_b(new NBTTagCompound()));
            }
            NBTTagList fluidOutputsList = new NBTTagList();
            for (FluidStack fluidOutput : this.fluidOutputs) {
                fluidOutputsList.func_74742_a((NBTBase)fluidOutput.writeToNBT(new NBTTagCompound()));
            }
            compound.func_74782_a("ItemOutputs", (NBTBase)itemOutputsList);
            compound.func_74782_a("FluidOutputs", (NBTBase)fluidOutputsList);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        this.workingEnabled = compound.func_74767_n("WorkEnabled");
        this.progressTime = compound.func_74762_e("Progress");
        this.isActive = false;
        if (this.progressTime > 0) {
            this.isActive = true;
            this.maxProgressTime = compound.func_74762_e("MaxProgress");
            this.recipeEUt = compound.func_74762_e("RecipeEUt");
            NBTTagList itemOutputsList = compound.func_150295_c("ItemOutputs", 10);
            this.itemOutputs = NonNullList.func_191196_a();
            for (int i = 0; i < itemOutputsList.func_74745_c(); ++i) {
                this.itemOutputs.add((Object)new ItemStack(itemOutputsList.func_150305_b(i)));
            }
            NBTTagList fluidOutputsList = compound.func_150295_c("FluidOutputs", 10);
            this.fluidOutputs = new ArrayList<FluidStack>();
            for (int i = 0; i < fluidOutputsList.func_74745_c(); ++i) {
                this.fluidOutputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidOutputsList.func_150305_b(i)));
            }
        }
    }
}

