/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public interface IEnergyContainer {
    public long acceptEnergyFromNetwork(EnumFacing var1, long var2, long var4);

    public boolean inputsEnergy(EnumFacing var1);

    default public boolean outputsEnergy(EnumFacing side) {
        return false;
    }

    public long changeEnergy(long var1);

    default public long addEnergy(long energyToAdd) {
        return this.changeEnergy(energyToAdd);
    }

    default public long removeEnergy(long energyToRemove) {
        return this.changeEnergy(-energyToRemove);
    }

    default public long getEnergyCanBeInserted() {
        return this.getEnergyCapacity() - this.getEnergyStored();
    }

    public long getEnergyStored();

    public long getEnergyCapacity();

    default public long getOutputAmperage() {
        return 0L;
    }

    default public long getOutputVoltage() {
        return 0L;
    }

    public long getInputAmperage();

    public long getInputVoltage();

    default public boolean isOneProbeHidden() {
        return false;
    }

    public static void doOvervoltageExplosion(MetaTileEntity metaTileEntity, long voltage) {
        BlockPos pos = metaTileEntity.getPos();
        metaTileEntity.getWorld().func_175698_g(pos);
        if (!metaTileEntity.getWorld().field_72995_K) {
            double posX = (double)pos.func_177958_n() + 0.5;
            double posY = (double)pos.func_177956_o() + 0.5;
            double posZ = (double)pos.func_177952_p() + 0.5;
            ((WorldServer)metaTileEntity.getWorld()).func_175739_a(EnumParticleTypes.SMOKE_LARGE, posX, posY, posZ, 10, 0.2, 0.2, 0.2, 0.0, new int[0]);
            if (ConfigHolder.doExplosions) {
                metaTileEntity.getWorld().func_72876_a(null, posX, posY, posZ, (float)GTUtility.getTierByVoltage(voltage), true);
            }
        }
    }
}

