/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.util;

import com.codetaylor.mc.athenaeum.util.Properties;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PortalFramePlacer {
    private final World world;
    private final EnumFacing.Axis axis;
    private final EnumFacing rightDir;
    private final EnumFacing leftDir;
    private int portalBlockCount;
    private BlockPos bottomLeft;
    private int height;
    private int width;
    private final IBlockState portalFrameBlockState;
    private final Block portalBlock;

    public PortalFramePlacer(World worldIn, BlockPos pos, EnumFacing.Axis axis, IBlockState portalFrameBlockState, Block portalBlock) {
        this.world = worldIn;
        this.axis = axis;
        this.portalFrameBlockState = portalFrameBlockState;
        this.portalBlock = portalBlock;
        if (axis == EnumFacing.Axis.X) {
            this.leftDir = EnumFacing.EAST;
            this.rightDir = EnumFacing.WEST;
        } else {
            this.leftDir = EnumFacing.NORTH;
            this.rightDir = EnumFacing.SOUTH;
        }
        BlockPos blockpos = pos;
        while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c())) {
            pos = pos.func_177977_b();
        }
        int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
        if (i >= 0) {
            this.bottomLeft = pos.func_177967_a(this.leftDir, i);
            this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
            if (this.width < 2 || this.width > 21) {
                this.bottomLeft = null;
                this.width = 0;
            }
        }
        if (this.bottomLeft != null) {
            this.height = this.calculatePortalHeight();
        }
    }

    protected int getDistanceUntilEdge(BlockPos p_180120_1_, EnumFacing p_180120_2_) {
        BlockPos blockpos;
        int i;
        for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(blockpos = p_180120_1_.func_177967_a(p_180120_2_, i)).func_177230_c()) && this.world.func_180495_p(blockpos.func_177977_b()) == this.portalFrameBlockState; ++i) {
        }
        IBlockState blockState = this.world.func_180495_p(p_180120_1_.func_177967_a(p_180120_2_, i));
        return blockState == this.portalFrameBlockState ? i : 0;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    protected int calculatePortalHeight() {
        this.height = 0;
        block0: while (this.height < 21) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                IBlockState blockState = this.world.func_180495_p(blockpos);
                Block block = blockState.func_177230_c();
                if (!this.isEmptyBlock(block)) break block0;
                if (block == this.portalBlock) {
                    ++this.portalBlockCount;
                }
                if (i == 0 ? (blockState = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir))) != this.portalFrameBlockState : i == this.width - 1 && (blockState = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir))) != this.portalFrameBlockState) break block0;
            }
            ++this.height;
        }
        for (int j = 0; j < this.width; ++j) {
            IBlockState blockState = this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height));
            if (blockState == this.portalFrameBlockState) continue;
            this.height = 0;
            break;
        }
        if (this.height <= 21 && this.height >= 3) {
            return this.height;
        }
        this.bottomLeft = null;
        this.width = 0;
        this.height = 0;
        return 0;
    }

    protected boolean isEmptyBlock(Block blockIn) {
        return blockIn.func_149688_o(blockIn.func_176223_P()) == Material.field_151579_a || blockIn == this.portalBlock;
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void placePortalBlocks() {
        for (int i = 0; i < this.width; ++i) {
            BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
            for (int j = 0; j < this.height; ++j) {
                this.world.func_180501_a(blockpos.func_177981_b(j), this.portalBlock.func_176223_P().func_177226_a(Properties.PORTAL_AXIS, (Comparable)this.axis), 2);
            }
        }
    }

    public int getPortalBlockCount() {
        return this.portalBlockCount;
    }

    public EnumFacing getRightDir() {
        return this.rightDir;
    }

    public EnumFacing getLeftDir() {
        return this.leftDir;
    }

    public BlockPos getBottomLeft() {
        return this.bottomLeft;
    }
}

