/*
 * Decompiled with CFR 0.152.
 */
package zentriggers.zentriggers;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.block.IMaterial;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.event.entity.living.LivingEvent;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.zentriggers.PredicateBuilder")
@ZenRegister
public class PredicateBuilder {
    private static final Random rand = new Random();
    private final ArrayDeque<Predicate<LivingEvent.LivingUpdateEvent>> predicates = new ArrayDeque();

    @ZenMethod
    public static PredicateBuilder create() {
        return new PredicateBuilder();
    }

    public boolean test(LivingEvent.LivingUpdateEvent event) {
        return this.predicates.stream().allMatch(p -> p.test(event));
    }

    @ZenMethod
    public PredicateBuilder negateLatest() {
        this.predicates.push(this.predicates.pop().negate());
        return this;
    }

    @ZenMethod
    public PredicateBuilder isInDimension(int id) {
        this.predicates.push(event -> event.getEntityLiving().field_71093_bK == id);
        return this;
    }

    @ZenMethod
    public PredicateBuilder isNthTick(int x) {
        this.predicates.push(event -> event.getEntity().field_70170_p.func_82737_E() % (long)x == 0L);
        return this;
    }

    @ZenMethod
    public PredicateBuilder isInMaterial(IMaterial material) {
        Material mat = (Material)material.getInternal();
        this.predicates.push(event -> event.getEntityLiving().func_70055_a(mat));
        return this;
    }

    @ZenMethod
    public PredicateBuilder isInBlock(IBlock block) {
        this.predicates.push(event -> CraftTweakerMC.getBlock((IBlock)block).equals(event.getEntityLiving().field_70170_p.func_180495_p(event.getEntityLiving().func_180425_c()).func_177230_c()));
        return this;
    }

    @ZenMethod
    public PredicateBuilder isInBlockArea(IBlock block, int expandX, int expandY) {
        return this.isInBlockArea(block, expandX, expandX, expandY, expandY);
    }

    @ZenMethod
    public PredicateBuilder isInBlockArea(IBlock block, int expandXPos, int expandXNeg, int expandYPos, int expandYNeg) {
        ArrayList<BlockPos> offsets = PredicateBuilder.getOffsetPositions(expandXPos, expandXNeg, expandYPos, expandYNeg);
        this.predicates.push(event -> offsets.stream().anyMatch(offset -> CraftTweakerMC.getBlock((IBlock)block).equals(event.getEntityLiving().field_70170_p.func_180495_p(event.getEntityLiving().func_180425_c().func_177971_a((Vec3i)offset)).func_177230_c())));
        return this;
    }

    @ZenMethod
    public PredicateBuilder isRandom(double chance) {
        this.predicates.push(event -> rand.nextDouble() < chance);
        return this;
    }

    @ZenMethod
    public PredicateBuilder isInBlockState(crafttweaker.api.block.IBlockState state) {
        this.predicates.push(event -> state.matches(CraftTweakerMC.getBlockState((IBlockState)event.getEntityLiving().field_70170_p.func_180495_p(event.getEntityLiving().func_180425_c()))));
        return this;
    }

    @ZenMethod
    public PredicateBuilder isInBlockStateArea(crafttweaker.api.block.IBlockState state, int expandX, int expandY) {
        return this.isInBlockStateArea(state, expandX, expandX, expandY, expandY);
    }

    @ZenMethod
    public PredicateBuilder isInBlockStateArea(crafttweaker.api.block.IBlockState state, int expandXPos, int expandXNeg, int expandYPos, int expandYNeg) {
        ArrayList<BlockPos> offsets = PredicateBuilder.getOffsetPositions(expandXPos, expandXNeg, expandYPos, expandYNeg);
        this.predicates.push(event -> offsets.stream().anyMatch(offset -> state.matches(CraftTweakerMC.getBlockState((IBlockState)event.getEntityLiving().field_70170_p.func_180495_p(event.getEntityLiving().func_180425_c().func_177971_a((Vec3i)offset))))));
        return this;
    }

    private static ArrayList<BlockPos> getOffsetPositions(int expandXPos, int expandXNeg, int expandYPos, int expandYNeg) {
        ArrayList<BlockPos> offsets = new ArrayList<BlockPos>();
        for (int x = -expandYNeg; x <= expandXPos; ++x) {
            for (int dx = -expandXNeg; dx <= expandXPos; ++dx) {
                for (int y = -expandYNeg; y <= expandYPos; ++y) {
                    offsets.add(new BlockPos(x, y, dx));
                }
            }
        }
        return offsets;
    }

    @ZenMethod
    public PredicateBuilder isNotNull() {
        this.predicates.push(event -> event != null && event.getEntityLiving() != null && event.getEntity() != null && event.getEntity().field_70170_p != null);
        return this;
    }

    @ZenMethod
    public PredicateBuilder isInstanceOf(IEntityDefinition entity) {
        if (entity == null || entity.getName() == null) {
            System.out.println("Provided entity is null or has no name, can't add isInstanceOf to the chain!");
            this.predicates.push(__ -> false);
            return this;
        }
        this.predicates.push(event -> EntityList.func_191301_a((Entity)event.getEntity()) != null && entity.getId().equalsIgnoreCase(EntityList.func_191301_a((Entity)event.getEntity()).toString()));
        return this;
    }

    @ZenMethod
    public PredicateBuilder isInstanceOf(String name) {
        this.predicates.push(event -> EntityList.func_191301_a((Entity)event.getEntity()) != null && EntityList.func_191301_a((Entity)event.getEntity()).toString().equalsIgnoreCase(name));
        return this;
    }

    static {
        rand.setSeed(1L);
    }
}

