/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import mcjty.incontrol.InControl;
import mcjty.incontrol.rules.ExperienceRule;
import mcjty.incontrol.rules.LootRule;
import mcjty.incontrol.rules.PotentialSpawnRule;
import mcjty.incontrol.rules.RulesManager;
import mcjty.incontrol.rules.SpawnRule;
import mcjty.incontrol.rules.SummonAidRule;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public class ForgeEventHandlers {
    public static boolean debug = false;

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        int i = 0;
        for (SpawnRule rule : RulesManager.rules) {
            if (rule.isOnJoin() && rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    InControl.logger.log(Level.INFO, "Join Rule " + i + ": " + result + " entity: " + event.getEntity().func_70005_c_() + " y: " + event.getEntity().func_180425_c().func_177956_o());
                }
                if (result != Event.Result.DENY) {
                    rule.action(event);
                } else {
                    event.setCanceled(true);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onEntitySpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        int i = 0;
        for (SpawnRule rule : RulesManager.rules) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    InControl.logger.log(Level.INFO, "Rule " + i + ": " + result + " entity: " + event.getEntity().func_70005_c_() + " y: " + event.getY() + " biome: " + event.getWorld().func_180494_b((BlockPos)new BlockPos((double)((double)event.getX()), (double)((double)event.getY()), (double)((double)event.getZ()))).field_76791_y);
                }
                event.setResult(result);
                if (result != Event.Result.DENY) {
                    rule.action(event);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onSummonAidEvent(ZombieEvent.SummonAidEvent event) {
        int i = 0;
        for (SummonAidRule rule : RulesManager.summonAidRules) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    InControl.logger.log(Level.INFO, "SummonAid " + i + ": " + result + " entity: " + event.getEntity().func_70005_c_() + " y: " + event.getY() + " biome: " + event.getWorld().func_180494_b((BlockPos)new BlockPos((int)event.getX(), (int)event.getY(), (int)event.getZ())).field_76791_y);
                }
                event.setResult(result);
                if (result != Event.Result.DENY) {
                    rule.action(event);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onPotentialSpawns(WorldEvent.PotentialSpawns event) {
        int i = 0;
        for (PotentialSpawnRule rule : RulesManager.potentialSpawnRules) {
            if (rule.match(event)) {
                for (Class clazz : rule.getToRemoveMobs()) {
                    for (int idx = event.getList().size() - 1; idx >= 0; --idx) {
                        if (((Biome.SpawnListEntry)event.getList().get((int)idx)).field_76300_b != clazz) continue;
                        event.getList().remove(idx);
                    }
                }
                List<Biome.SpawnListEntry> spawnEntries = rule.getSpawnEntries();
                for (Biome.SpawnListEntry entry : spawnEntries) {
                    if (debug) {
                        InControl.logger.log(Level.INFO, "Potential " + i + ": " + entry.field_76300_b.toString());
                    }
                    event.getList().add(entry);
                }
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        int i = 0;
        for (ExperienceRule rule : RulesManager.experienceRules) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    InControl.logger.log(Level.INFO, "Experience Rule " + i + ": " + result + " entity: " + event.getEntity().func_70005_c_() + " y: " + event.getEntity().func_180425_c().func_177956_o());
                }
                if (result != Event.Result.DENY) {
                    int newxp = rule.modifyXp(event.getDroppedExperience());
                    event.setDroppedExperience(newxp);
                } else {
                    event.setCanceled(true);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        int i = 0;
        for (LootRule rule : RulesManager.lootRules) {
            if (rule.match(event)) {
                if (debug) {
                    InControl.logger.log(Level.INFO, "Loot " + i + ":  entity: " + event.getEntity().func_70005_c_());
                }
                if (rule.isRemoveAll()) {
                    event.getDrops().clear();
                } else {
                    for (Predicate<ItemStack> predicate : rule.getToRemoveItems()) {
                        for (int idx = event.getDrops().size() - 1; idx >= 0; --idx) {
                            ItemStack stack = ((EntityItem)event.getDrops().get(idx)).func_92059_d();
                            if (!predicate.test(stack)) continue;
                            event.getDrops().remove(idx);
                        }
                    }
                }
                for (Pair pair : rule.getToAddItems()) {
                    ItemStack copy;
                    int amount;
                    ItemStack item = (ItemStack)pair.getLeft();
                    int fortune = event.getLootingLevel();
                    BlockPos pos = event.getEntity().func_180425_c();
                    for (amount = ((Integer)((Function)pair.getValue()).apply(fortune)).intValue(); amount > item.func_77976_d(); amount -= item.func_77976_d()) {
                        copy = item.func_77946_l();
                        copy.func_190920_e(item.func_77976_d());
                        event.getDrops().add(new EntityItem(event.getEntity().func_130014_f_(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), copy));
                    }
                    if (amount <= 0) continue;
                    copy = item.func_77946_l();
                    copy.func_190920_e(amount);
                    event.getDrops().add(new EntityItem(event.getEntity().func_130014_f_(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), copy));
                }
            }
            ++i;
        }
    }
}

