/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.Vector3F;

public class StatsRocket {
    private int thrust = 0;
    private int weight = 0;
    private float drillingPower = 0.0f;
    private int fuelLiquid = 0;
    private int fuelNuclear;
    private int fuelIon;
    private int fuelWarp;
    private int fuelImpulse;
    private int fuelCapacityLiquid;
    private int fuelCapacityNuclear;
    private int fuelCapacityIon;
    private int fuelCapacityWarp;
    private int fuelCapacityImpulse;
    private int fuelRateLiquid;
    private int fuelRateNuclear;
    private int fuelRateIon;
    private int fuelRateWarp;
    private int fuelRateImpulse;
    HashedBlockPosition pilotSeatPos;
    private final List<HashedBlockPosition> passengerSeats = new ArrayList<HashedBlockPosition>();
    private List<Vector3F<Float>> engineLoc;
    private static final String TAGNAME = "rocketStats";
    private HashMap<String, Object> statTags;
    private static final int INVALID_SEAT = Integer.MIN_VALUE;

    public StatsRocket() {
        this.pilotSeatPos = new HashedBlockPosition(0, 0, 0);
        this.pilotSeatPos.x = Integer.MIN_VALUE;
        this.engineLoc = new ArrayList<Vector3F<Float>>();
        this.statTags = new HashMap();
    }

    public int getSeatX() {
        return this.pilotSeatPos.x;
    }

    public int getSeatY() {
        return this.pilotSeatPos.y;
    }

    public int getSeatZ() {
        return this.pilotSeatPos.z;
    }

    public HashedBlockPosition getPassengerSeat(int index) {
        return this.passengerSeats.get(index);
    }

    public int getNumPassengerSeats() {
        return this.passengerSeats.size();
    }

    public int getThrust() {
        return (int)((double)this.thrust * Configuration.rocketThrustMultiplier);
    }

    public int getWeight() {
        return this.weight;
    }

    public float getDrillingPower() {
        return this.drillingPower;
    }

    public void setDrillingPower(float power) {
        this.drillingPower = power;
    }

    public float getAcceleration() {
        return (float)(this.getThrust() - this.weight) / 10000.0f;
    }

    public List<Vector3F<Float>> getEngineLocations() {
        return this.engineLoc;
    }

    public void setThrust(int thrust) {
        this.thrust = thrust;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void setSeatLocation(int x, int y, int z) {
        this.pilotSeatPos.x = x;
        this.pilotSeatPos.y = (short)y;
        this.pilotSeatPos.z = z;
    }

    public void addPassengerSeat(int x, int y, int z) {
        if (!this.hasSeat()) {
            this.setSeatLocation(x, y, z);
        }
        this.passengerSeats.add(new HashedBlockPosition(x, y, z));
    }

    public void addEngineLocation(float x, float y, float z) {
        this.engineLoc.add((Vector3F<Float>)new Vector3F((Object)Float.valueOf(x), (Object)Float.valueOf(y), (Object)Float.valueOf(z)));
    }

    public void clearEngineLocations() {
        this.engineLoc.clear();
    }

    public StatsRocket copy() {
        StatsRocket stat = new StatsRocket();
        stat.thrust = this.thrust;
        stat.weight = this.weight;
        stat.drillingPower = this.drillingPower;
        for (FuelRegistry.FuelType type : FuelRegistry.FuelType.values()) {
            stat.setFuelAmount(type, this.getFuelAmount(type));
            stat.setFuelRate(type, this.getFuelRate(type));
            stat.setFuelCapacity(type, this.getFuelCapacity(type));
        }
        stat.pilotSeatPos = new HashedBlockPosition(this.pilotSeatPos.x, (int)this.pilotSeatPos.y, this.pilotSeatPos.z);
        stat.passengerSeats.addAll(this.passengerSeats);
        stat.engineLoc = new ArrayList<Vector3F<Float>>(this.engineLoc);
        stat.statTags = new HashMap<String, Object>(this.statTags);
        return stat;
    }

    public int getFuelAmount(FuelRegistry.FuelType type) {
        switch (type) {
            case WARP: {
                return this.fuelWarp;
            }
            case IMPULSE: {
                return this.fuelImpulse;
            }
            case ION: {
                return this.fuelIon;
            }
            case LIQUID: {
                return this.fuelLiquid;
            }
            case NUCLEAR: {
                return this.fuelNuclear;
            }
        }
        return 0;
    }

    public int getFuelCapacity(FuelRegistry.FuelType type) {
        switch (type) {
            case WARP: {
                return this.fuelCapacityWarp;
            }
            case IMPULSE: {
                return this.fuelCapacityImpulse;
            }
            case ION: {
                return this.fuelCapacityIon;
            }
            case LIQUID: {
                return this.fuelCapacityLiquid;
            }
            case NUCLEAR: {
                return this.fuelCapacityNuclear;
            }
        }
        return 0;
    }

    public int getFuelRate(FuelRegistry.FuelType type) {
        if (!Configuration.rocketRequireFuel) {
            return 0;
        }
        switch (type) {
            case WARP: {
                return this.fuelRateWarp;
            }
            case IMPULSE: {
                return this.fuelRateImpulse;
            }
            case ION: {
                return this.fuelRateIon;
            }
            case LIQUID: {
                return this.fuelRateLiquid;
            }
            case NUCLEAR: {
                return this.fuelRateNuclear;
            }
        }
        return 0;
    }

    public void setFuelAmount(FuelRegistry.FuelType type, int amt) {
        switch (type) {
            case WARP: {
                this.fuelWarp = amt;
                break;
            }
            case IMPULSE: {
                this.fuelImpulse = amt;
                break;
            }
            case ION: {
                this.fuelIon = amt;
                break;
            }
            case LIQUID: {
                this.fuelLiquid = amt;
                break;
            }
            case NUCLEAR: {
                this.fuelNuclear = amt;
            }
        }
    }

    public void setFuelRate(FuelRegistry.FuelType type, int amt) {
        switch (type) {
            case WARP: {
                this.fuelRateWarp = amt;
                break;
            }
            case IMPULSE: {
                this.fuelRateImpulse = amt;
                break;
            }
            case ION: {
                this.fuelRateIon = amt;
                break;
            }
            case LIQUID: {
                this.fuelRateLiquid = amt;
                break;
            }
            case NUCLEAR: {
                this.fuelRateNuclear = amt;
            }
        }
    }

    public void setFuelCapacity(FuelRegistry.FuelType type, int amt) {
        switch (type) {
            case WARP: {
                this.fuelCapacityWarp = amt;
                break;
            }
            case IMPULSE: {
                this.fuelCapacityImpulse = amt;
                break;
            }
            case ION: {
                this.fuelCapacityIon = amt;
                break;
            }
            case LIQUID: {
                this.fuelCapacityLiquid = amt;
                break;
            }
            case NUCLEAR: {
                this.fuelCapacityNuclear = amt;
            }
        }
    }

    public int addFuelAmount(FuelRegistry.FuelType type, int amt) {
        switch (type) {
            case WARP: {
                this.fuelWarp += amt;
                return this.fuelWarp;
            }
            case IMPULSE: {
                this.fuelImpulse += amt;
                return this.fuelImpulse;
            }
            case ION: {
                this.fuelIon += amt;
                return this.fuelIon;
            }
            case LIQUID: {
                int maxAdd = this.fuelCapacityLiquid - this.fuelLiquid;
                int amountToAdd = Math.min(amt, maxAdd);
                this.fuelLiquid += amountToAdd;
                return amountToAdd;
            }
            case NUCLEAR: {
                this.fuelNuclear += amt;
                return this.fuelNuclear;
            }
        }
        return 0;
    }

    public boolean hasSeat() {
        return this.pilotSeatPos.x != Integer.MIN_VALUE;
    }

    public void reset() {
        this.thrust = 0;
        this.weight = 0;
        this.drillingPower = 0.0f;
        for (FuelRegistry.FuelType type : FuelRegistry.FuelType.values()) {
            this.setFuelAmount(type, 0);
            this.setFuelRate(type, 0);
            this.setFuelCapacity(type, 0);
        }
        this.fuelLiquid = 0;
        this.pilotSeatPos.x = Integer.MIN_VALUE;
        this.clearEngineLocations();
        this.passengerSeats.clear();
        this.statTags.clear();
    }

    public void setStatTag(String str, float value) {
        this.statTags.put(str, new Float(value));
    }

    public void setStatTag(String str, int value) {
        this.statTags.put(str, new Integer(value));
    }

    public Object getStatTag(String str) {
        Object obj = this.statTags.get(str);
        return obj == null ? Integer.valueOf(0) : obj;
    }

    public static StatsRocket createFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(TAGNAME)) {
            NBTTagCompound stats = nbt.func_74775_l(TAGNAME);
            StatsRocket statsRocket = new StatsRocket();
            statsRocket.readFromNBT(stats);
            return statsRocket;
        }
        return new StatsRocket();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        HashedBlockPosition vec;
        int[] locs;
        NBTTagCompound stats = new NBTTagCompound();
        stats.func_74768_a("thrust", this.thrust);
        stats.func_74768_a("weight", this.weight);
        stats.func_74776_a("drillingPower", this.drillingPower);
        stats.func_74768_a("fuelLiquid", this.fuelLiquid);
        stats.func_74768_a("fuelImpulse", this.fuelImpulse);
        stats.func_74768_a("fuelIon", this.fuelIon);
        stats.func_74768_a("fuelNuclear", this.fuelNuclear);
        stats.func_74768_a("fuelWarp", this.fuelWarp);
        stats.func_74768_a("fuelCapacityLiquid", this.fuelCapacityLiquid);
        stats.func_74768_a("fuelCapacityImpulse", this.fuelCapacityImpulse);
        stats.func_74768_a("fuelCapacityIon", this.fuelCapacityIon);
        stats.func_74768_a("fuelCapacityNuclear", this.fuelCapacityNuclear);
        stats.func_74768_a("fuelCapacityWarp", this.fuelCapacityWarp);
        stats.func_74768_a("fuelRateLiquid", this.fuelRateLiquid);
        stats.func_74768_a("fuelRateImpulse", this.fuelRateImpulse);
        stats.func_74768_a("fuelRateIon", this.fuelRateIon);
        stats.func_74768_a("fuelRateNuclear", this.fuelRateNuclear);
        stats.func_74768_a("fuelRateWarp", this.fuelRateWarp);
        NBTTagCompound dynStats = new NBTTagCompound();
        for (String key : this.statTags.keySet()) {
            Object obj = this.statTags.get(key);
            if (obj instanceof Float) {
                dynStats.func_74776_a(key, ((Float)obj).floatValue());
                continue;
            }
            if (!(obj instanceof Integer)) continue;
            dynStats.func_74768_a(key, ((Integer)obj).intValue());
        }
        if (!dynStats.func_82582_d()) {
            stats.func_74782_a("dynStats", (NBTBase)dynStats);
        }
        stats.func_74768_a("playerXPos", this.pilotSeatPos.x);
        stats.func_74768_a("playerYPos", (int)this.pilotSeatPos.y);
        stats.func_74768_a("playerZPos", this.pilotSeatPos.z);
        if (!this.engineLoc.isEmpty()) {
            locs = new int[this.engineLoc.size() * 3];
            int i = 0;
            while (i / 3 < this.engineLoc.size()) {
                vec = this.engineLoc.get(i / 3);
                locs[i] = ((Float)vec.x).intValue();
                locs[i + 1] = ((Float)vec.y).intValue();
                locs[i + 2] = ((Float)vec.z).intValue();
                i += 3;
            }
            stats.func_74783_a("engineLoc", locs);
        }
        if (!this.passengerSeats.isEmpty()) {
            locs = new int[this.passengerSeats.size() * 3];
            int i = 0;
            while (i / 3 < this.passengerSeats.size()) {
                vec = this.passengerSeats.get(i / 3);
                locs[i] = vec.x;
                locs[i + 1] = vec.y;
                locs[i + 2] = vec.z;
                i += 3;
            }
            stats.func_74783_a("passengerSeats", locs);
        }
        nbt.func_74782_a(TAGNAME, (NBTBase)stats);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(TAGNAME)) {
            int[] locations;
            NBTTagCompound stats = nbt.func_74775_l(TAGNAME);
            this.thrust = stats.func_74762_e("thrust");
            this.weight = stats.func_74762_e("weight");
            this.drillingPower = stats.func_74760_g("drillingPower");
            this.fuelLiquid = stats.func_74762_e("fuelLiquid");
            this.fuelImpulse = stats.func_74762_e("fuelImpulse");
            this.fuelIon = stats.func_74762_e("fuelIon");
            this.fuelNuclear = stats.func_74762_e("fuelNuclear");
            this.fuelWarp = stats.func_74762_e("fuelWarp");
            this.fuelCapacityLiquid = stats.func_74762_e("fuelCapacityLiquid");
            this.fuelCapacityImpulse = stats.func_74762_e("fuelCapacityImpulse");
            this.fuelCapacityIon = stats.func_74762_e("fuelCapacityIon");
            this.fuelCapacityNuclear = stats.func_74762_e("fuelCapacityNuclear");
            this.fuelCapacityWarp = stats.func_74762_e("fuelCapacityWarp");
            this.fuelRateLiquid = stats.func_74762_e("fuelRateLiquid");
            this.fuelRateImpulse = stats.func_74762_e("fuelRateImpulse");
            this.fuelRateIon = stats.func_74762_e("fuelRateIon");
            this.fuelRateNuclear = stats.func_74762_e("fuelRateNuclear");
            this.fuelRateWarp = stats.func_74762_e("fuelRateWarp");
            if (stats.func_74764_b("dynStats")) {
                NBTTagCompound dynStats = stats.func_74775_l("dynStats");
                for (Object key : dynStats.func_150296_c()) {
                    NBTBase obj = dynStats.func_74781_a((String)key);
                    if (obj instanceof NBTTagFloat) {
                        this.setStatTag((String)key, dynStats.func_74760_g((String)key));
                        continue;
                    }
                    if (!(obj instanceof NBTTagInt)) continue;
                    this.setStatTag((String)key, dynStats.func_74762_e((String)key));
                }
            }
            this.pilotSeatPos.x = stats.func_74762_e("playerXPos");
            this.pilotSeatPos.y = (short)stats.func_74762_e("playerYPos");
            this.pilotSeatPos.z = stats.func_74762_e("playerZPos");
            if (stats.func_74764_b("engineLoc")) {
                locations = stats.func_74759_k("engineLoc");
                for (int i = 0; i < locations.length; i += 3) {
                    this.addEngineLocation(locations[i], locations[i + 1], locations[i + 2]);
                }
            }
            if (stats.func_74764_b("passengerSeats")) {
                locations = stats.func_74759_k("passengerSeats");
                for (int i = 0; i < locations.length; i += 3) {
                    this.addPassengerSeat(locations[i], locations[i + 1], locations[i + 2]);
                }
            }
        }
    }
}

